/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccountAssignmentDeletionStatusResponse extends SsoAdminResponse implements
        ToCopyableBuilder<ListAccountAssignmentDeletionStatusResponse.Builder, ListAccountAssignmentDeletionStatusResponse> {
    private static final SdkField<List<AccountAssignmentOperationStatusMetadata>> ACCOUNT_ASSIGNMENTS_DELETION_STATUS_FIELD = SdkField
            .<List<AccountAssignmentOperationStatusMetadata>> builder(MarshallingType.LIST)
            .getter(getter(ListAccountAssignmentDeletionStatusResponse::accountAssignmentsDeletionStatus))
            .setter(setter(Builder::accountAssignmentsDeletionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssignmentsDeletionStatus")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountAssignmentOperationStatusMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountAssignmentOperationStatusMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAccountAssignmentDeletionStatusResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACCOUNT_ASSIGNMENTS_DELETION_STATUS_FIELD, NEXT_TOKEN_FIELD));

    private final List<AccountAssignmentOperationStatusMetadata> accountAssignmentsDeletionStatus;

    private final String nextToken;

    private ListAccountAssignmentDeletionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.accountAssignmentsDeletionStatus = builder.accountAssignmentsDeletionStatus;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AccountAssignmentsDeletionStatus property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasAccountAssignmentsDeletionStatus() {
        return accountAssignmentsDeletionStatus != null && !(accountAssignmentsDeletionStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status object for the account assignment deletion operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccountAssignmentsDeletionStatus()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The status object for the account assignment deletion operation.
     */
    public List<AccountAssignmentOperationStatusMetadata> accountAssignmentsDeletionStatus() {
        return accountAssignmentsDeletionStatus;
    }

    /**
     * <p>
     * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make
     * subsequent calls.
     * </p>
     * 
     * @return The pagination token for the list API. Initially the value is null. Use the output of previous API calls
     *         to make subsequent calls.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountAssignmentsDeletionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountAssignmentDeletionStatusResponse)) {
            return false;
        }
        ListAccountAssignmentDeletionStatusResponse other = (ListAccountAssignmentDeletionStatusResponse) obj;
        return Objects.equals(accountAssignmentsDeletionStatus(), other.accountAssignmentsDeletionStatus())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAccountAssignmentDeletionStatusResponse")
                .add("AccountAssignmentsDeletionStatus", accountAssignmentsDeletionStatus()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountAssignmentsDeletionStatus":
            return Optional.ofNullable(clazz.cast(accountAssignmentsDeletionStatus()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccountAssignmentDeletionStatusResponse, T> g) {
        return obj -> g.apply((ListAccountAssignmentDeletionStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAccountAssignmentDeletionStatusResponse> {
        /**
         * <p>
         * The status object for the account assignment deletion operation.
         * </p>
         * 
         * @param accountAssignmentsDeletionStatus
         *        The status object for the account assignment deletion operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssignmentsDeletionStatus(
                Collection<AccountAssignmentOperationStatusMetadata> accountAssignmentsDeletionStatus);

        /**
         * <p>
         * The status object for the account assignment deletion operation.
         * </p>
         * 
         * @param accountAssignmentsDeletionStatus
         *        The status object for the account assignment deletion operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssignmentsDeletionStatus(AccountAssignmentOperationStatusMetadata... accountAssignmentsDeletionStatus);

        /**
         * <p>
         * The status object for the account assignment deletion operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AccountAssignmentOperationStatusMetadata>.Builder} avoiding the need to create one manually via {@link List
         * <AccountAssignmentOperationStatusMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccountAssignmentOperationStatusMetadata>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #accountAssignmentsDeletionStatus(List<AccountAssignmentOperationStatusMetadata>)}.
         * 
         * @param accountAssignmentsDeletionStatus
         *        a consumer that will call methods on {@link List<AccountAssignmentOperationStatusMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountAssignmentsDeletionStatus(List<AccountAssignmentOperationStatusMetadata>)
         */
        Builder accountAssignmentsDeletionStatus(
                Consumer<AccountAssignmentOperationStatusMetadata.Builder>... accountAssignmentsDeletionStatus);

        /**
         * <p>
         * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to
         * make subsequent calls.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the list API. Initially the value is null. Use the output of previous API
         *        calls to make subsequent calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private List<AccountAssignmentOperationStatusMetadata> accountAssignmentsDeletionStatus = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountAssignmentDeletionStatusResponse model) {
            super(model);
            accountAssignmentsDeletionStatus(model.accountAssignmentsDeletionStatus);
            nextToken(model.nextToken);
        }

        public final Collection<AccountAssignmentOperationStatusMetadata.Builder> getAccountAssignmentsDeletionStatus() {
            return accountAssignmentsDeletionStatus != null ? accountAssignmentsDeletionStatus.stream()
                    .map(AccountAssignmentOperationStatusMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountAssignmentsDeletionStatus(
                Collection<AccountAssignmentOperationStatusMetadata> accountAssignmentsDeletionStatus) {
            this.accountAssignmentsDeletionStatus = AccountAssignmentOperationStatusListCopier
                    .copy(accountAssignmentsDeletionStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAssignmentsDeletionStatus(
                AccountAssignmentOperationStatusMetadata... accountAssignmentsDeletionStatus) {
            accountAssignmentsDeletionStatus(Arrays.asList(accountAssignmentsDeletionStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAssignmentsDeletionStatus(
                Consumer<AccountAssignmentOperationStatusMetadata.Builder>... accountAssignmentsDeletionStatus) {
            accountAssignmentsDeletionStatus(Stream.of(accountAssignmentsDeletionStatus)
                    .map(c -> AccountAssignmentOperationStatusMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAccountAssignmentsDeletionStatus(
                Collection<AccountAssignmentOperationStatusMetadata.BuilderImpl> accountAssignmentsDeletionStatus) {
            this.accountAssignmentsDeletionStatus = AccountAssignmentOperationStatusListCopier
                    .copyFromBuilder(accountAssignmentsDeletionStatus);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAccountAssignmentDeletionStatusResponse build() {
            return new ListAccountAssignmentDeletionStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
