/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value used for mapping a specified attribute to an identity source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessControlAttributeValue implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessControlAttributeValue.Builder, AccessControlAttributeValue> {
    private static final SdkField<List<String>> SOURCE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Source")
            .getter(getter(AccessControlAttributeValue::source))
            .setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> source;

    private AccessControlAttributeValue(BuilderImpl builder) {
        this.source = builder.source;
    }

    /**
     * Returns true if the Source property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSource() {
        return source != null && !(source instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identity source to use when mapping a specified attribute to AWS SSO.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSource()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identity source to use when mapping a specified attribute to AWS SSO.
     */
    public List<String> source() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSource() ? source() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessControlAttributeValue)) {
            return false;
        }
        AccessControlAttributeValue other = (AccessControlAttributeValue) obj;
        return hasSource() == other.hasSource() && Objects.equals(source(), other.source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AccessControlAttributeValue").add("Source", hasSource() ? source() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessControlAttributeValue, T> g) {
        return obj -> g.apply((AccessControlAttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessControlAttributeValue> {
        /**
         * <p>
         * The identity source to use when mapping a specified attribute to AWS SSO.
         * </p>
         * 
         * @param source
         *        The identity source to use when mapping a specified attribute to AWS SSO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Collection<String> source);

        /**
         * <p>
         * The identity source to use when mapping a specified attribute to AWS SSO.
         * </p>
         * 
         * @param source
         *        The identity source to use when mapping a specified attribute to AWS SSO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String... source);
    }

    static final class BuilderImpl implements Builder {
        private List<String> source = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccessControlAttributeValue model) {
            source(model.source);
        }

        public final Collection<String> getSource() {
            if (source instanceof SdkAutoConstructList) {
                return null;
            }
            return source;
        }

        @Override
        public final Builder source(Collection<String> source) {
            this.source = AccessControlAttributeValueSourceListCopier.copy(source);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder source(String... source) {
            source(Arrays.asList(source));
            return this;
        }

        public final void setSource(Collection<String> source) {
            this.source = AccessControlAttributeValueSourceListCopier.copy(source);
        }

        @Override
        public AccessControlAttributeValue build() {
            return new AccessControlAttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
