/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInstancesResponse extends SsoAdminResponse implements
        ToCopyableBuilder<ListInstancesResponse.Builder, ListInstancesResponse> {
    private static final SdkField<List<InstanceMetadata>> INSTANCES_FIELD = SdkField
            .<List<InstanceMetadata>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(ListInstancesResponse::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInstancesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<InstanceMetadata> instances;

    private final String nextToken;

    private ListInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Instances property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the SSO instances that the caller has access to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Lists the SSO instances that the caller has access to.
     */
    public List<InstanceMetadata> instances() {
        return instances;
    }

    /**
     * <p>
     * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make
     * subsequent calls.
     * </p>
     * 
     * @return The pagination token for the list API. Initially the value is null. Use the output of previous API calls
     *         to make subsequent calls.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesResponse)) {
            return false;
        }
        ListInstancesResponse other = (ListInstancesResponse) obj;
        return hasInstances() == other.hasInstances() && Objects.equals(instances(), other.instances())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListInstancesResponse").add("Instances", hasInstances() ? instances() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInstancesResponse, T> g) {
        return obj -> g.apply((ListInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInstancesResponse> {
        /**
         * <p>
         * Lists the SSO instances that the caller has access to.
         * </p>
         * 
         * @param instances
         *        Lists the SSO instances that the caller has access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<InstanceMetadata> instances);

        /**
         * <p>
         * Lists the SSO instances that the caller has access to.
         * </p>
         * 
         * @param instances
         *        Lists the SSO instances that the caller has access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(InstanceMetadata... instances);

        /**
         * <p>
         * Lists the SSO instances that the caller has access to.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceMetadata>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #instances(List<InstanceMetadata>)}.
         * 
         * @param instances
         *        a consumer that will call methods on {@link List<InstanceMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(List<InstanceMetadata>)
         */
        Builder instances(Consumer<InstanceMetadata.Builder>... instances);

        /**
         * <p>
         * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to
         * make subsequent calls.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the list API. Initially the value is null. Use the output of previous API
         *        calls to make subsequent calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private List<InstanceMetadata> instances = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesResponse model) {
            super(model);
            instances(model.instances);
            nextToken(model.nextToken);
        }

        public final Collection<InstanceMetadata.Builder> getInstances() {
            if (instances instanceof SdkAutoConstructList) {
                return null;
            }
            return instances != null ? instances.stream().map(InstanceMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<InstanceMetadata> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(InstanceMetadata... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<InstanceMetadata.Builder>... instances) {
            instances(Stream.of(instances).map(c -> InstanceMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<InstanceMetadata.BuilderImpl> instances) {
            this.instances = InstanceListCopier.copyFromBuilder(instances);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInstancesResponse build() {
            return new ListInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
