/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.TagResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.TagResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.UntagResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.UntagResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourcePublisher;

/**
 * Service client for accessing SSO Admin asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface SsoAdminAsyncClient extends SdkClient {
    String SERVICE_NAME = "sso";

    /**
     * Create a {@link SsoAdminAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SsoAdminAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SsoAdminAsyncClient}.
     */
    static SsoAdminAsyncClientBuilder builder() {
        return new DefaultSsoAdminAsyncClientBuilder();
    }

    /**
     * <p>
     * Attaches an IAM managed policy ARN to a permission set.
     * </p>
     * <note>
     * <p>
     * If the permission set is already referenced by one or more account assignments, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> after this action to apply the corresponding IAM policy updates to
     * all assigned accounts.
     * </p>
     * </note>
     *
     * @param attachManagedPolicyToPermissionSetRequest
     * @return A Java Future containing the result of the AttachManagedPolicyToPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.AttachManagedPolicyToPermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachManagedPolicyToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachManagedPolicyToPermissionSetResponse> attachManagedPolicyToPermissionSet(
            AttachManagedPolicyToPermissionSetRequest attachManagedPolicyToPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an IAM managed policy ARN to a permission set.
     * </p>
     * <note>
     * <p>
     * If the permission set is already referenced by one or more account assignments, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> after this action to apply the corresponding IAM policy updates to
     * all assigned accounts.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachManagedPolicyToPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link AttachManagedPolicyToPermissionSetRequest#builder()}
     * </p>
     *
     * @param attachManagedPolicyToPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link AttachManagedPolicyToPermissionSetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AttachManagedPolicyToPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.AttachManagedPolicyToPermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachManagedPolicyToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachManagedPolicyToPermissionSetResponse> attachManagedPolicyToPermissionSet(
            Consumer<AttachManagedPolicyToPermissionSetRequest.Builder> attachManagedPolicyToPermissionSetRequest) {
        return attachManagedPolicyToPermissionSet(AttachManagedPolicyToPermissionSetRequest.builder()
                .applyMutation(attachManagedPolicyToPermissionSetRequest).build());
    }

    /**
     * <p>
     * Assigns access to a principal for a specified AWS account using a specified permission set.
     * </p>
     * <note>
     * <p>
     * The term <i>principal</i> here refers to a user or group that is defined in AWS SSO.
     * </p>
     * </note> <note>
     * <p>
     * As part of a successful <code>CreateAccountAssignment</code> call, the specified permission set will
     * automatically be provisioned to the account in the form of an IAM policy attached to the SSO-created IAM role. If
     * the permission set is subsequently updated, the corresponding IAM policies attached to roles in your accounts
     * will not be updated automatically. In this case, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> to make these updates.
     * </p>
     * </note>
     *
     * @param createAccountAssignmentRequest
     * @return A Java Future containing the result of the CreateAccountAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateAccountAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateAccountAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccountAssignmentResponse> createAccountAssignment(
            CreateAccountAssignmentRequest createAccountAssignmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns access to a principal for a specified AWS account using a specified permission set.
     * </p>
     * <note>
     * <p>
     * The term <i>principal</i> here refers to a user or group that is defined in AWS SSO.
     * </p>
     * </note> <note>
     * <p>
     * As part of a successful <code>CreateAccountAssignment</code> call, the specified permission set will
     * automatically be provisioned to the account in the form of an IAM policy attached to the SSO-created IAM role. If
     * the permission set is subsequently updated, the corresponding IAM policies attached to roles in your accounts
     * will not be updated automatically. In this case, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> to make these updates.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccountAssignmentRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAccountAssignmentRequest#builder()}
     * </p>
     *
     * @param createAccountAssignmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateAccountAssignmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAccountAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateAccountAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateAccountAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccountAssignmentResponse> createAccountAssignment(
            Consumer<CreateAccountAssignmentRequest.Builder> createAccountAssignmentRequest) {
        return createAccountAssignment(CreateAccountAssignmentRequest.builder().applyMutation(createAccountAssignmentRequest)
                .build());
    }

    /**
     * <p>
     * Enables the attributes-based access control (ABAC) feature for the specified AWS SSO instance. You can also
     * specify new attributes to add to your ABAC configuration during the enabling process. For more information about
     * ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>AWS SSO
     * User Guide</i>.
     * </p>
     *
     * @param createInstanceAccessControlAttributeConfigurationRequest
     * @return A Java Future containing the result of the CreateInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInstanceAccessControlAttributeConfigurationResponse> createInstanceAccessControlAttributeConfiguration(
            CreateInstanceAccessControlAttributeConfigurationRequest createInstanceAccessControlAttributeConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the attributes-based access control (ABAC) feature for the specified AWS SSO instance. You can also
     * specify new attributes to add to your ABAC configuration during the enabling process. For more information about
     * ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>AWS SSO
     * User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateInstanceAccessControlAttributeConfigurationRequest.Builder} avoiding the need to create one manually
     * via {@link CreateInstanceAccessControlAttributeConfigurationRequest#builder()}
     * </p>
     *
     * @param createInstanceAccessControlAttributeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link CreateInstanceAccessControlAttributeConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInstanceAccessControlAttributeConfigurationResponse> createInstanceAccessControlAttributeConfiguration(
            Consumer<CreateInstanceAccessControlAttributeConfigurationRequest.Builder> createInstanceAccessControlAttributeConfigurationRequest) {
        return createInstanceAccessControlAttributeConfiguration(CreateInstanceAccessControlAttributeConfigurationRequest
                .builder().applyMutation(createInstanceAccessControlAttributeConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a permission set within a specified SSO instance.
     * </p>
     * <note>
     * <p>
     * To grant users and groups access to AWS account resources, use <code> <a>CreateAccountAssignment</a> </code>.
     * </p>
     * </note>
     *
     * @param createPermissionSetRequest
     * @return A Java Future containing the result of the CreatePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreatePermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreatePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePermissionSetResponse> createPermissionSet(
            CreatePermissionSetRequest createPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a permission set within a specified SSO instance.
     * </p>
     * <note>
     * <p>
     * To grant users and groups access to AWS account resources, use <code> <a>CreateAccountAssignment</a> </code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePermissionSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePermissionSetRequest#builder()}
     * </p>
     *
     * @param createPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link CreatePermissionSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreatePermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreatePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePermissionSetResponse> createPermissionSet(
            Consumer<CreatePermissionSetRequest.Builder> createPermissionSetRequest) {
        return createPermissionSet(CreatePermissionSetRequest.builder().applyMutation(createPermissionSetRequest).build());
    }

    /**
     * <p>
     * Deletes a principal's access from a specified AWS account using a specified permission set.
     * </p>
     *
     * @param deleteAccountAssignmentRequest
     * @return A Java Future containing the result of the DeleteAccountAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteAccountAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteAccountAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccountAssignmentResponse> deleteAccountAssignment(
            DeleteAccountAssignmentRequest deleteAccountAssignmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a principal's access from a specified AWS account using a specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountAssignmentRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAccountAssignmentRequest#builder()}
     * </p>
     *
     * @param deleteAccountAssignmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAccountAssignmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAccountAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteAccountAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteAccountAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccountAssignmentResponse> deleteAccountAssignment(
            Consumer<DeleteAccountAssignmentRequest.Builder> deleteAccountAssignmentRequest) {
        return deleteAccountAssignment(DeleteAccountAssignmentRequest.builder().applyMutation(deleteAccountAssignmentRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the inline policy from a specified permission set.
     * </p>
     *
     * @param deleteInlinePolicyFromPermissionSetRequest
     * @return A Java Future containing the result of the DeleteInlinePolicyFromPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteInlinePolicyFromPermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInlinePolicyFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInlinePolicyFromPermissionSetResponse> deleteInlinePolicyFromPermissionSet(
            DeleteInlinePolicyFromPermissionSetRequest deleteInlinePolicyFromPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the inline policy from a specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInlinePolicyFromPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteInlinePolicyFromPermissionSetRequest#builder()}
     * </p>
     *
     * @param deleteInlinePolicyFromPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInlinePolicyFromPermissionSetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteInlinePolicyFromPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteInlinePolicyFromPermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInlinePolicyFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInlinePolicyFromPermissionSetResponse> deleteInlinePolicyFromPermissionSet(
            Consumer<DeleteInlinePolicyFromPermissionSetRequest.Builder> deleteInlinePolicyFromPermissionSetRequest) {
        return deleteInlinePolicyFromPermissionSet(DeleteInlinePolicyFromPermissionSetRequest.builder()
                .applyMutation(deleteInlinePolicyFromPermissionSetRequest).build());
    }

    /**
     * <p>
     * Disables the attributes-based access control (ABAC) feature for the specified AWS SSO instance and deletes all of
     * the attribute mappings that have been configured. Once deleted, any attributes that are received from an identity
     * source and any custom attributes you have previously configured will not be passed. For more information about
     * ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>AWS SSO
     * User Guide</i>.
     * </p>
     *
     * @param deleteInstanceAccessControlAttributeConfigurationRequest
     * @return A Java Future containing the result of the DeleteInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInstanceAccessControlAttributeConfigurationResponse> deleteInstanceAccessControlAttributeConfiguration(
            DeleteInstanceAccessControlAttributeConfigurationRequest deleteInstanceAccessControlAttributeConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the attributes-based access control (ABAC) feature for the specified AWS SSO instance and deletes all of
     * the attribute mappings that have been configured. Once deleted, any attributes that are received from an identity
     * source and any custom attributes you have previously configured will not be passed. For more information about
     * ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>AWS SSO
     * User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteInstanceAccessControlAttributeConfigurationRequest.Builder} avoiding the need to create one manually
     * via {@link DeleteInstanceAccessControlAttributeConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteInstanceAccessControlAttributeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteInstanceAccessControlAttributeConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInstanceAccessControlAttributeConfigurationResponse> deleteInstanceAccessControlAttributeConfiguration(
            Consumer<DeleteInstanceAccessControlAttributeConfigurationRequest.Builder> deleteInstanceAccessControlAttributeConfigurationRequest) {
        return deleteInstanceAccessControlAttributeConfiguration(DeleteInstanceAccessControlAttributeConfigurationRequest
                .builder().applyMutation(deleteInstanceAccessControlAttributeConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified permission set.
     * </p>
     *
     * @param deletePermissionSetRequest
     * @return A Java Future containing the result of the DeletePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeletePermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePermissionSetResponse> deletePermissionSet(
            DeletePermissionSetRequest deletePermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePermissionSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePermissionSetRequest#builder()}
     * </p>
     *
     * @param deletePermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link DeletePermissionSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeletePermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePermissionSetResponse> deletePermissionSet(
            Consumer<DeletePermissionSetRequest.Builder> deletePermissionSetRequest) {
        return deletePermissionSet(DeletePermissionSetRequest.builder().applyMutation(deletePermissionSetRequest).build());
    }

    /**
     * <p>
     * Describes the status of the assignment creation request.
     * </p>
     *
     * @param describeAccountAssignmentCreationStatusRequest
     * @return A Java Future containing the result of the DescribeAccountAssignmentCreationStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeAccountAssignmentCreationStatus
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAssignmentCreationStatusResponse> describeAccountAssignmentCreationStatus(
            DescribeAccountAssignmentCreationStatusRequest describeAccountAssignmentCreationStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the status of the assignment creation request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAccountAssignmentCreationStatusRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAccountAssignmentCreationStatusRequest#builder()}
     * </p>
     *
     * @param describeAccountAssignmentCreationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeAccountAssignmentCreationStatusRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeAccountAssignmentCreationStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeAccountAssignmentCreationStatus
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAssignmentCreationStatusResponse> describeAccountAssignmentCreationStatus(
            Consumer<DescribeAccountAssignmentCreationStatusRequest.Builder> describeAccountAssignmentCreationStatusRequest) {
        return describeAccountAssignmentCreationStatus(DescribeAccountAssignmentCreationStatusRequest.builder()
                .applyMutation(describeAccountAssignmentCreationStatusRequest).build());
    }

    /**
     * <p>
     * Describes the status of the assignment deletion request.
     * </p>
     *
     * @param describeAccountAssignmentDeletionStatusRequest
     * @return A Java Future containing the result of the DescribeAccountAssignmentDeletionStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeAccountAssignmentDeletionStatus
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAssignmentDeletionStatusResponse> describeAccountAssignmentDeletionStatus(
            DescribeAccountAssignmentDeletionStatusRequest describeAccountAssignmentDeletionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the status of the assignment deletion request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAccountAssignmentDeletionStatusRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAccountAssignmentDeletionStatusRequest#builder()}
     * </p>
     *
     * @param describeAccountAssignmentDeletionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeAccountAssignmentDeletionStatusRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeAccountAssignmentDeletionStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeAccountAssignmentDeletionStatus
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAssignmentDeletionStatusResponse> describeAccountAssignmentDeletionStatus(
            Consumer<DescribeAccountAssignmentDeletionStatusRequest.Builder> describeAccountAssignmentDeletionStatusRequest) {
        return describeAccountAssignmentDeletionStatus(DescribeAccountAssignmentDeletionStatusRequest.builder()
                .applyMutation(describeAccountAssignmentDeletionStatusRequest).build());
    }

    /**
     * <p>
     * Returns the list of AWS SSO identity store attributes that have been configured to work with attributes-based
     * access control (ABAC) for the specified AWS SSO instance. This will not return attributes configured and sent by
     * an external identity provider. For more information about ABAC, see <a
     * href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>AWS SSO User
     * Guide</i>.
     * </p>
     *
     * @param describeInstanceAccessControlAttributeConfigurationRequest
     * @return A Java Future containing the result of the DescribeInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceAccessControlAttributeConfigurationResponse> describeInstanceAccessControlAttributeConfiguration(
            DescribeInstanceAccessControlAttributeConfigurationRequest describeInstanceAccessControlAttributeConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of AWS SSO identity store attributes that have been configured to work with attributes-based
     * access control (ABAC) for the specified AWS SSO instance. This will not return attributes configured and sent by
     * an external identity provider. For more information about ABAC, see <a
     * href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>AWS SSO User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeInstanceAccessControlAttributeConfigurationRequest.Builder} avoiding the need to create one
     * manually via {@link DescribeInstanceAccessControlAttributeConfigurationRequest#builder()}
     * </p>
     *
     * @param describeInstanceAccessControlAttributeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeInstanceAccessControlAttributeConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceAccessControlAttributeConfigurationResponse> describeInstanceAccessControlAttributeConfiguration(
            Consumer<DescribeInstanceAccessControlAttributeConfigurationRequest.Builder> describeInstanceAccessControlAttributeConfigurationRequest) {
        return describeInstanceAccessControlAttributeConfiguration(DescribeInstanceAccessControlAttributeConfigurationRequest
                .builder().applyMutation(describeInstanceAccessControlAttributeConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets the details of the permission set.
     * </p>
     *
     * @param describePermissionSetRequest
     * @return A Java Future containing the result of the DescribePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribePermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePermissionSetResponse> describePermissionSet(
            DescribePermissionSetRequest describePermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of the permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePermissionSetRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePermissionSetRequest#builder()}
     * </p>
     *
     * @param describePermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link DescribePermissionSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribePermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePermissionSetResponse> describePermissionSet(
            Consumer<DescribePermissionSetRequest.Builder> describePermissionSetRequest) {
        return describePermissionSet(DescribePermissionSetRequest.builder().applyMutation(describePermissionSetRequest).build());
    }

    /**
     * <p>
     * Describes the status for the given permission set provisioning request.
     * </p>
     *
     * @param describePermissionSetProvisioningStatusRequest
     * @return A Java Future containing the result of the DescribePermissionSetProvisioningStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribePermissionSetProvisioningStatus
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePermissionSetProvisioningStatusResponse> describePermissionSetProvisioningStatus(
            DescribePermissionSetProvisioningStatusRequest describePermissionSetProvisioningStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the status for the given permission set provisioning request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribePermissionSetProvisioningStatusRequest.Builder} avoiding the need to create one manually via
     * {@link DescribePermissionSetProvisioningStatusRequest#builder()}
     * </p>
     *
     * @param describePermissionSetProvisioningStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribePermissionSetProvisioningStatusRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribePermissionSetProvisioningStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribePermissionSetProvisioningStatus
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePermissionSetProvisioningStatusResponse> describePermissionSetProvisioningStatus(
            Consumer<DescribePermissionSetProvisioningStatusRequest.Builder> describePermissionSetProvisioningStatusRequest) {
        return describePermissionSetProvisioningStatus(DescribePermissionSetProvisioningStatusRequest.builder()
                .applyMutation(describePermissionSetProvisioningStatusRequest).build());
    }

    /**
     * <p>
     * Detaches the attached IAM managed policy ARN from the specified permission set.
     * </p>
     *
     * @param detachManagedPolicyFromPermissionSetRequest
     * @return A Java Future containing the result of the DetachManagedPolicyFromPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DetachManagedPolicyFromPermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachManagedPolicyFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachManagedPolicyFromPermissionSetResponse> detachManagedPolicyFromPermissionSet(
            DetachManagedPolicyFromPermissionSetRequest detachManagedPolicyFromPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches the attached IAM managed policy ARN from the specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DetachManagedPolicyFromPermissionSetRequest.Builder} avoiding the need to create one manually via
     * {@link DetachManagedPolicyFromPermissionSetRequest#builder()}
     * </p>
     *
     * @param detachManagedPolicyFromPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link DetachManagedPolicyFromPermissionSetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DetachManagedPolicyFromPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DetachManagedPolicyFromPermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachManagedPolicyFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetachManagedPolicyFromPermissionSetResponse> detachManagedPolicyFromPermissionSet(
            Consumer<DetachManagedPolicyFromPermissionSetRequest.Builder> detachManagedPolicyFromPermissionSetRequest) {
        return detachManagedPolicyFromPermissionSet(DetachManagedPolicyFromPermissionSetRequest.builder()
                .applyMutation(detachManagedPolicyFromPermissionSetRequest).build());
    }

    /**
     * <p>
     * Obtains the inline policy assigned to the permission set.
     * </p>
     *
     * @param getInlinePolicyForPermissionSetRequest
     * @return A Java Future containing the result of the GetInlinePolicyForPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetInlinePolicyForPermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetInlinePolicyForPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInlinePolicyForPermissionSetResponse> getInlinePolicyForPermissionSet(
            GetInlinePolicyForPermissionSetRequest getInlinePolicyForPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains the inline policy assigned to the permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInlinePolicyForPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link GetInlinePolicyForPermissionSetRequest#builder()}
     * </p>
     *
     * @param getInlinePolicyForPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link GetInlinePolicyForPermissionSetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetInlinePolicyForPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetInlinePolicyForPermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetInlinePolicyForPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInlinePolicyForPermissionSetResponse> getInlinePolicyForPermissionSet(
            Consumer<GetInlinePolicyForPermissionSetRequest.Builder> getInlinePolicyForPermissionSetRequest) {
        return getInlinePolicyForPermissionSet(GetInlinePolicyForPermissionSetRequest.builder()
                .applyMutation(getInlinePolicyForPermissionSetRequest).build());
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment creation requests for a specified SSO instance.
     * </p>
     *
     * @param listAccountAssignmentCreationStatusRequest
     * @return A Java Future containing the result of the ListAccountAssignmentCreationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentCreationStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssignmentCreationStatusResponse> listAccountAssignmentCreationStatus(
            ListAccountAssignmentCreationStatusRequest listAccountAssignmentCreationStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment creation requests for a specified SSO instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentCreationStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListAccountAssignmentCreationStatusRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentCreationStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountAssignmentCreationStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAccountAssignmentCreationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentCreationStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssignmentCreationStatusResponse> listAccountAssignmentCreationStatus(
            Consumer<ListAccountAssignmentCreationStatusRequest.Builder> listAccountAssignmentCreationStatusRequest) {
        return listAccountAssignmentCreationStatus(ListAccountAssignmentCreationStatusRequest.builder()
                .applyMutation(listAccountAssignmentCreationStatusRequest).build());
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment creation requests for a specified SSO instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentCreationStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusPublisher publisher = client.listAccountAssignmentCreationStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusPublisher publisher = client.listAccountAssignmentCreationStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentCreationStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssignmentCreationStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentCreationStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentCreationStatusPublisher listAccountAssignmentCreationStatusPaginator(
            ListAccountAssignmentCreationStatusRequest listAccountAssignmentCreationStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment creation requests for a specified SSO instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentCreationStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusPublisher publisher = client.listAccountAssignmentCreationStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusPublisher publisher = client.listAccountAssignmentCreationStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentCreationStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentCreationStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListAccountAssignmentCreationStatusRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentCreationStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountAssignmentCreationStatusRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentCreationStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentCreationStatusPublisher listAccountAssignmentCreationStatusPaginator(
            Consumer<ListAccountAssignmentCreationStatusRequest.Builder> listAccountAssignmentCreationStatusRequest) {
        return listAccountAssignmentCreationStatusPaginator(ListAccountAssignmentCreationStatusRequest.builder()
                .applyMutation(listAccountAssignmentCreationStatusRequest).build());
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment deletion requests for a specified SSO instance.
     * </p>
     *
     * @param listAccountAssignmentDeletionStatusRequest
     * @return A Java Future containing the result of the ListAccountAssignmentDeletionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentDeletionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssignmentDeletionStatusResponse> listAccountAssignmentDeletionStatus(
            ListAccountAssignmentDeletionStatusRequest listAccountAssignmentDeletionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment deletion requests for a specified SSO instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentDeletionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListAccountAssignmentDeletionStatusRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentDeletionStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountAssignmentDeletionStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAccountAssignmentDeletionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentDeletionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssignmentDeletionStatusResponse> listAccountAssignmentDeletionStatus(
            Consumer<ListAccountAssignmentDeletionStatusRequest.Builder> listAccountAssignmentDeletionStatusRequest) {
        return listAccountAssignmentDeletionStatus(ListAccountAssignmentDeletionStatusRequest.builder()
                .applyMutation(listAccountAssignmentDeletionStatusRequest).build());
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment deletion requests for a specified SSO instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentDeletionStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusPublisher publisher = client.listAccountAssignmentDeletionStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusPublisher publisher = client.listAccountAssignmentDeletionStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentDeletionStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssignmentDeletionStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentDeletionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentDeletionStatusPublisher listAccountAssignmentDeletionStatusPaginator(
            ListAccountAssignmentDeletionStatusRequest listAccountAssignmentDeletionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment deletion requests for a specified SSO instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentDeletionStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusPublisher publisher = client.listAccountAssignmentDeletionStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusPublisher publisher = client.listAccountAssignmentDeletionStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentDeletionStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentDeletionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListAccountAssignmentDeletionStatusRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentDeletionStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountAssignmentDeletionStatusRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentDeletionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentDeletionStatusPublisher listAccountAssignmentDeletionStatusPaginator(
            Consumer<ListAccountAssignmentDeletionStatusRequest.Builder> listAccountAssignmentDeletionStatusRequest) {
        return listAccountAssignmentDeletionStatusPaginator(ListAccountAssignmentDeletionStatusRequest.builder()
                .applyMutation(listAccountAssignmentDeletionStatusRequest).build());
    }

    /**
     * <p>
     * Lists the assignee of the specified AWS account with the specified permission set.
     * </p>
     *
     * @param listAccountAssignmentsRequest
     * @return A Java Future containing the result of the ListAccountAssignments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssignmentsResponse> listAccountAssignments(
            ListAccountAssignmentsRequest listAccountAssignmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the assignee of the specified AWS account with the specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountAssignmentsRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountAssignmentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAccountAssignments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssignmentsResponse> listAccountAssignments(
            Consumer<ListAccountAssignmentsRequest.Builder> listAccountAssignmentsRequest) {
        return listAccountAssignments(ListAccountAssignmentsRequest.builder().applyMutation(listAccountAssignmentsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the assignee of the specified AWS account with the specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignments(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsPublisher publisher = client.listAccountAssignmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsPublisher publisher = client.listAccountAssignmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignments(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssignmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentsPublisher listAccountAssignmentsPaginator(
            ListAccountAssignmentsRequest listAccountAssignmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the assignee of the specified AWS account with the specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignments(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsPublisher publisher = client.listAccountAssignmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsPublisher publisher = client.listAccountAssignmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignments(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountAssignmentsRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountAssignmentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentsPublisher listAccountAssignmentsPaginator(
            Consumer<ListAccountAssignmentsRequest.Builder> listAccountAssignmentsRequest) {
        return listAccountAssignmentsPaginator(ListAccountAssignmentsRequest.builder()
                .applyMutation(listAccountAssignmentsRequest).build());
    }

    /**
     * <p>
     * Lists all the AWS accounts where the specified permission set is provisioned.
     * </p>
     *
     * @param listAccountsForProvisionedPermissionSetRequest
     * @return A Java Future containing the result of the ListAccountsForProvisionedPermissionSet operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountsForProvisionedPermissionSet
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountsForProvisionedPermissionSetResponse> listAccountsForProvisionedPermissionSet(
            ListAccountsForProvisionedPermissionSetRequest listAccountsForProvisionedPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the AWS accounts where the specified permission set is provisioned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAccountsForProvisionedPermissionSetRequest.Builder} avoiding the need to create one manually via
     * {@link ListAccountsForProvisionedPermissionSetRequest#builder()}
     * </p>
     *
     * @param listAccountsForProvisionedPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListAccountsForProvisionedPermissionSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAccountsForProvisionedPermissionSet operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountsForProvisionedPermissionSet
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountsForProvisionedPermissionSetResponse> listAccountsForProvisionedPermissionSet(
            Consumer<ListAccountsForProvisionedPermissionSetRequest.Builder> listAccountsForProvisionedPermissionSetRequest) {
        return listAccountsForProvisionedPermissionSet(ListAccountsForProvisionedPermissionSetRequest.builder()
                .applyMutation(listAccountsForProvisionedPermissionSetRequest).build());
    }

    /**
     * <p>
     * Lists all the AWS accounts where the specified permission set is provisioned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountsForProvisionedPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetPublisher publisher = client.listAccountsForProvisionedPermissionSetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetPublisher publisher = client.listAccountsForProvisionedPermissionSetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountsForProvisionedPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountsForProvisionedPermissionSetRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountsForProvisionedPermissionSet
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountsForProvisionedPermissionSetPublisher listAccountsForProvisionedPermissionSetPaginator(
            ListAccountsForProvisionedPermissionSetRequest listAccountsForProvisionedPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the AWS accounts where the specified permission set is provisioned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountsForProvisionedPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetPublisher publisher = client.listAccountsForProvisionedPermissionSetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetPublisher publisher = client.listAccountsForProvisionedPermissionSetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountsForProvisionedPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAccountsForProvisionedPermissionSetRequest.Builder} avoiding the need to create one manually via
     * {@link ListAccountsForProvisionedPermissionSetRequest#builder()}
     * </p>
     *
     * @param listAccountsForProvisionedPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListAccountsForProvisionedPermissionSetRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountsForProvisionedPermissionSet
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountsForProvisionedPermissionSetPublisher listAccountsForProvisionedPermissionSetPaginator(
            Consumer<ListAccountsForProvisionedPermissionSetRequest.Builder> listAccountsForProvisionedPermissionSetRequest) {
        return listAccountsForProvisionedPermissionSetPaginator(ListAccountsForProvisionedPermissionSetRequest.builder()
                .applyMutation(listAccountsForProvisionedPermissionSetRequest).build());
    }

    /**
     * <p>
     * Lists the SSO instances that the caller has access to.
     * </p>
     *
     * @param listInstancesRequest
     * @return A Java Future containing the result of the ListInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInstancesResponse> listInstances(ListInstancesRequest listInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the SSO instances that the caller has access to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListInstancesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInstancesResponse> listInstances(Consumer<ListInstancesRequest.Builder> listInstancesRequest) {
        return listInstances(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * Lists the SSO instances that the caller has access to.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listInstances(software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest)} operation.</b>
     * </p>
     *
     * @param listInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesPublisher listInstancesPaginator(ListInstancesRequest listInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the SSO instances that the caller has access to.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listInstances(software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListInstancesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesPublisher listInstancesPaginator(Consumer<ListInstancesRequest.Builder> listInstancesRequest) {
        return listInstancesPaginator(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * Lists the IAM managed policy that is attached to a specified permission set.
     * </p>
     *
     * @param listManagedPoliciesInPermissionSetRequest
     * @return A Java Future containing the result of the ListManagedPoliciesInPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListManagedPoliciesInPermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedPoliciesInPermissionSetResponse> listManagedPoliciesInPermissionSet(
            ListManagedPoliciesInPermissionSetRequest listManagedPoliciesInPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IAM managed policy that is attached to a specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedPoliciesInPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedPoliciesInPermissionSetRequest#builder()}
     * </p>
     *
     * @param listManagedPoliciesInPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link ListManagedPoliciesInPermissionSetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListManagedPoliciesInPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListManagedPoliciesInPermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedPoliciesInPermissionSetResponse> listManagedPoliciesInPermissionSet(
            Consumer<ListManagedPoliciesInPermissionSetRequest.Builder> listManagedPoliciesInPermissionSetRequest) {
        return listManagedPoliciesInPermissionSet(ListManagedPoliciesInPermissionSetRequest.builder()
                .applyMutation(listManagedPoliciesInPermissionSetRequest).build());
    }

    /**
     * <p>
     * Lists the IAM managed policy that is attached to a specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listManagedPoliciesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetPublisher publisher = client.listManagedPoliciesInPermissionSetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetPublisher publisher = client.listManagedPoliciesInPermissionSetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedPoliciesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedPoliciesInPermissionSetRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListManagedPoliciesInPermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedPoliciesInPermissionSetPublisher listManagedPoliciesInPermissionSetPaginator(
            ListManagedPoliciesInPermissionSetRequest listManagedPoliciesInPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IAM managed policy that is attached to a specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listManagedPoliciesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetPublisher publisher = client.listManagedPoliciesInPermissionSetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetPublisher publisher = client.listManagedPoliciesInPermissionSetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedPoliciesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedPoliciesInPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedPoliciesInPermissionSetRequest#builder()}
     * </p>
     *
     * @param listManagedPoliciesInPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link ListManagedPoliciesInPermissionSetRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListManagedPoliciesInPermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedPoliciesInPermissionSetPublisher listManagedPoliciesInPermissionSetPaginator(
            Consumer<ListManagedPoliciesInPermissionSetRequest.Builder> listManagedPoliciesInPermissionSetRequest) {
        return listManagedPoliciesInPermissionSetPaginator(ListManagedPoliciesInPermissionSetRequest.builder()
                .applyMutation(listManagedPoliciesInPermissionSetRequest).build());
    }

    /**
     * <p>
     * Lists the status of the permission set provisioning requests for a specified SSO instance.
     * </p>
     *
     * @param listPermissionSetProvisioningStatusRequest
     * @return A Java Future containing the result of the ListPermissionSetProvisioningStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetProvisioningStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPermissionSetProvisioningStatusResponse> listPermissionSetProvisioningStatus(
            ListPermissionSetProvisioningStatusRequest listPermissionSetProvisioningStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of the permission set provisioning requests for a specified SSO instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionSetProvisioningStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListPermissionSetProvisioningStatusRequest#builder()}
     * </p>
     *
     * @param listPermissionSetProvisioningStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionSetProvisioningStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListPermissionSetProvisioningStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetProvisioningStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPermissionSetProvisioningStatusResponse> listPermissionSetProvisioningStatus(
            Consumer<ListPermissionSetProvisioningStatusRequest.Builder> listPermissionSetProvisioningStatusRequest) {
        return listPermissionSetProvisioningStatus(ListPermissionSetProvisioningStatusRequest.builder()
                .applyMutation(listPermissionSetProvisioningStatusRequest).build());
    }

    /**
     * <p>
     * Lists the status of the permission set provisioning requests for a specified SSO instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSetProvisioningStatus(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusPublisher publisher = client.listPermissionSetProvisioningStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusPublisher publisher = client.listPermissionSetProvisioningStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSetProvisioningStatus(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionSetProvisioningStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetProvisioningStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionSetProvisioningStatusPublisher listPermissionSetProvisioningStatusPaginator(
            ListPermissionSetProvisioningStatusRequest listPermissionSetProvisioningStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of the permission set provisioning requests for a specified SSO instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSetProvisioningStatus(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusPublisher publisher = client.listPermissionSetProvisioningStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusPublisher publisher = client.listPermissionSetProvisioningStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSetProvisioningStatus(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionSetProvisioningStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListPermissionSetProvisioningStatusRequest#builder()}
     * </p>
     *
     * @param listPermissionSetProvisioningStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionSetProvisioningStatusRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetProvisioningStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionSetProvisioningStatusPublisher listPermissionSetProvisioningStatusPaginator(
            Consumer<ListPermissionSetProvisioningStatusRequest.Builder> listPermissionSetProvisioningStatusRequest) {
        return listPermissionSetProvisioningStatusPaginator(ListPermissionSetProvisioningStatusRequest.builder()
                .applyMutation(listPermissionSetProvisioningStatusRequest).build());
    }

    /**
     * <p>
     * Lists the <a>PermissionSet</a>s in an SSO instance.
     * </p>
     *
     * @param listPermissionSetsRequest
     * @return A Java Future containing the result of the ListPermissionSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPermissionSetsResponse> listPermissionSets(ListPermissionSetsRequest listPermissionSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the <a>PermissionSet</a>s in an SSO instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPermissionSetsRequest#builder()}
     * </p>
     *
     * @param listPermissionSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionSetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPermissionSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPermissionSetsResponse> listPermissionSets(
            Consumer<ListPermissionSetsRequest.Builder> listPermissionSetsRequest) {
        return listPermissionSets(ListPermissionSetsRequest.builder().applyMutation(listPermissionSetsRequest).build());
    }

    /**
     * <p>
     * Lists the <a>PermissionSet</a>s in an SSO instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSets(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsPublisher publisher = client.listPermissionSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsPublisher publisher = client.listPermissionSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSets(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionSetsPublisher listPermissionSetsPaginator(ListPermissionSetsRequest listPermissionSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the <a>PermissionSet</a>s in an SSO instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSets(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsPublisher publisher = client.listPermissionSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsPublisher publisher = client.listPermissionSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSets(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPermissionSetsRequest#builder()}
     * </p>
     *
     * @param listPermissionSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionSetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionSetsPublisher listPermissionSetsPaginator(
            Consumer<ListPermissionSetsRequest.Builder> listPermissionSetsRequest) {
        return listPermissionSetsPaginator(ListPermissionSetsRequest.builder().applyMutation(listPermissionSetsRequest).build());
    }

    /**
     * <p>
     * Lists all the permission sets that are provisioned to a specified AWS account.
     * </p>
     *
     * @param listPermissionSetsProvisionedToAccountRequest
     * @return A Java Future containing the result of the ListPermissionSetsProvisionedToAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetsProvisionedToAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPermissionSetsProvisionedToAccountResponse> listPermissionSetsProvisionedToAccount(
            ListPermissionSetsProvisionedToAccountRequest listPermissionSetsProvisionedToAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the permission sets that are provisioned to a specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListPermissionSetsProvisionedToAccountRequest.Builder} avoiding the need to create one manually via
     * {@link ListPermissionSetsProvisionedToAccountRequest#builder()}
     * </p>
     *
     * @param listPermissionSetsProvisionedToAccountRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionSetsProvisionedToAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListPermissionSetsProvisionedToAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetsProvisionedToAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPermissionSetsProvisionedToAccountResponse> listPermissionSetsProvisionedToAccount(
            Consumer<ListPermissionSetsProvisionedToAccountRequest.Builder> listPermissionSetsProvisionedToAccountRequest) {
        return listPermissionSetsProvisionedToAccount(ListPermissionSetsProvisionedToAccountRequest.builder()
                .applyMutation(listPermissionSetsProvisionedToAccountRequest).build());
    }

    /**
     * <p>
     * Lists all the permission sets that are provisioned to a specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSetsProvisionedToAccount(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountPublisher publisher = client.listPermissionSetsProvisionedToAccountPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountPublisher publisher = client.listPermissionSetsProvisionedToAccountPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSetsProvisionedToAccount(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionSetsProvisionedToAccountRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetsProvisionedToAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionSetsProvisionedToAccountPublisher listPermissionSetsProvisionedToAccountPaginator(
            ListPermissionSetsProvisionedToAccountRequest listPermissionSetsProvisionedToAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the permission sets that are provisioned to a specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSetsProvisionedToAccount(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountPublisher publisher = client.listPermissionSetsProvisionedToAccountPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountPublisher publisher = client.listPermissionSetsProvisionedToAccountPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSetsProvisionedToAccount(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListPermissionSetsProvisionedToAccountRequest.Builder} avoiding the need to create one manually via
     * {@link ListPermissionSetsProvisionedToAccountRequest#builder()}
     * </p>
     *
     * @param listPermissionSetsProvisionedToAccountRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionSetsProvisionedToAccountRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetsProvisionedToAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionSetsProvisionedToAccountPublisher listPermissionSetsProvisionedToAccountPaginator(
            Consumer<ListPermissionSetsProvisionedToAccountRequest.Builder> listPermissionSetsProvisionedToAccountRequest) {
        return listPermissionSetsProvisionedToAccountPaginator(ListPermissionSetsProvisionedToAccountRequest.builder()
                .applyMutation(listPermissionSetsProvisionedToAccountRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to a specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * The process by which a specified permission set is provisioned to the specified target.
     * </p>
     *
     * @param provisionPermissionSetRequest
     * @return A Java Future containing the result of the ProvisionPermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ProvisionPermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ProvisionPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ProvisionPermissionSetResponse> provisionPermissionSet(
            ProvisionPermissionSetRequest provisionPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The process by which a specified permission set is provisioned to the specified target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ProvisionPermissionSetRequest.Builder} avoiding the
     * need to create one manually via {@link ProvisionPermissionSetRequest#builder()}
     * </p>
     *
     * @param provisionPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link ProvisionPermissionSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ProvisionPermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ProvisionPermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ProvisionPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ProvisionPermissionSetResponse> provisionPermissionSet(
            Consumer<ProvisionPermissionSetRequest.Builder> provisionPermissionSetRequest) {
        return provisionPermissionSet(ProvisionPermissionSetRequest.builder().applyMutation(provisionPermissionSetRequest)
                .build());
    }

    /**
     * <p>
     * Attaches an IAM inline policy to a permission set.
     * </p>
     * <note>
     * <p>
     * If the permission set is already referenced by one or more account assignments, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> after this action to apply the corresponding IAM policy updates to
     * all assigned accounts.
     * </p>
     * </note>
     *
     * @param putInlinePolicyToPermissionSetRequest
     * @return A Java Future containing the result of the PutInlinePolicyToPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutInlinePolicyToPermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutInlinePolicyToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInlinePolicyToPermissionSetResponse> putInlinePolicyToPermissionSet(
            PutInlinePolicyToPermissionSetRequest putInlinePolicyToPermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an IAM inline policy to a permission set.
     * </p>
     * <note>
     * <p>
     * If the permission set is already referenced by one or more account assignments, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> after this action to apply the corresponding IAM policy updates to
     * all assigned accounts.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutInlinePolicyToPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link PutInlinePolicyToPermissionSetRequest#builder()}
     * </p>
     *
     * @param putInlinePolicyToPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link PutInlinePolicyToPermissionSetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutInlinePolicyToPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutInlinePolicyToPermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutInlinePolicyToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInlinePolicyToPermissionSetResponse> putInlinePolicyToPermissionSet(
            Consumer<PutInlinePolicyToPermissionSetRequest.Builder> putInlinePolicyToPermissionSetRequest) {
        return putInlinePolicyToPermissionSet(PutInlinePolicyToPermissionSetRequest.builder()
                .applyMutation(putInlinePolicyToPermissionSetRequest).build());
    }

    /**
     * <p>
     * Associates a set of tags with a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a set of tags with a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Disassociates a set of tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a set of tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the AWS SSO identity store attributes to use with the AWS SSO instance for attributes-based access
     * control (ABAC). When using an external identity provider as an identity source, you can pass attributes through
     * the SAML assertion as an alternative to configuring attributes from the AWS SSO identity store. If a SAML
     * assertion passes any of these attributes, AWS SSO will replace the attribute value with the value from the AWS
     * SSO identity store. For more information about ABAC, see <a
     * href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>AWS SSO User
     * Guide</i>.
     * </p>
     *
     * @param updateInstanceAccessControlAttributeConfigurationRequest
     * @return A Java Future containing the result of the UpdateInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UpdateInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateInstanceAccessControlAttributeConfigurationResponse> updateInstanceAccessControlAttributeConfiguration(
            UpdateInstanceAccessControlAttributeConfigurationRequest updateInstanceAccessControlAttributeConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the AWS SSO identity store attributes to use with the AWS SSO instance for attributes-based access
     * control (ABAC). When using an external identity provider as an identity source, you can pass attributes through
     * the SAML assertion as an alternative to configuring attributes from the AWS SSO identity store. If a SAML
     * assertion passes any of these attributes, AWS SSO will replace the attribute value with the value from the AWS
     * SSO identity store. For more information about ABAC, see <a
     * href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>AWS SSO User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateInstanceAccessControlAttributeConfigurationRequest.Builder} avoiding the need to create one manually
     * via {@link UpdateInstanceAccessControlAttributeConfigurationRequest#builder()}
     * </p>
     *
     * @param updateInstanceAccessControlAttributeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link UpdateInstanceAccessControlAttributeConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UpdateInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateInstanceAccessControlAttributeConfigurationResponse> updateInstanceAccessControlAttributeConfiguration(
            Consumer<UpdateInstanceAccessControlAttributeConfigurationRequest.Builder> updateInstanceAccessControlAttributeConfigurationRequest) {
        return updateInstanceAccessControlAttributeConfiguration(UpdateInstanceAccessControlAttributeConfigurationRequest
                .builder().applyMutation(updateInstanceAccessControlAttributeConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an existing permission set.
     * </p>
     *
     * @param updatePermissionSetRequest
     * @return A Java Future containing the result of the UpdatePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UpdatePermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdatePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdatePermissionSetResponse> updatePermissionSet(
            UpdatePermissionSetRequest updatePermissionSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePermissionSetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdatePermissionSetRequest#builder()}
     * </p>
     *
     * @param updatePermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePermissionSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UpdatePermissionSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdatePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdatePermissionSetResponse> updatePermissionSet(
            Consumer<UpdatePermissionSetRequest.Builder> updatePermissionSetRequest) {
        return updatePermissionSet(UpdatePermissionSetRequest.builder().applyMutation(updatePermissionSetRequest).build());
    }
}
