/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that is used to provide the status of the provisioning operation for a specified permission set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PermissionSetProvisioningStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<PermissionSetProvisioningStatus.Builder, PermissionSetProvisioningStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PermissionSetProvisioningStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(PermissionSetProvisioningStatus::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(PermissionSetProvisioningStatus::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> PERMISSION_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionSetArn").getter(getter(PermissionSetProvisioningStatus::permissionSetArn))
            .setter(setter(Builder::permissionSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetArn").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(PermissionSetProvisioningStatus::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate").getter(getter(PermissionSetProvisioningStatus::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            REQUEST_ID_FIELD, ACCOUNT_ID_FIELD, PERMISSION_SET_ARN_FIELD, FAILURE_REASON_FIELD, CREATED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String requestId;

    private final String accountId;

    private final String permissionSetArn;

    private final String failureReason;

    private final Instant createdDate;

    private PermissionSetProvisioningStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.requestId = builder.requestId;
        this.accountId = builder.accountId;
        this.permissionSetArn = builder.permissionSetArn;
        this.failureReason = builder.failureReason;
        this.createdDate = builder.createdDate;
    }

    /**
     * <p>
     * The status of the permission set provisioning process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the permission set provisioning process.
     * @see StatusValues
     */
    public final StatusValues status() {
        return StatusValues.fromValue(status);
    }

    /**
     * <p>
     * The status of the permission set provisioning process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the permission set provisioning process.
     * @see StatusValues
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The identifier for tracking the request operation that is generated by the universally unique identifier (UUID)
     * workflow.
     * </p>
     * 
     * @return The identifier for tracking the request operation that is generated by the universally unique identifier
     *         (UUID) workflow.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The identifier of the AWS account from which to list the assignments.
     * </p>
     * 
     * @return The identifier of the AWS account from which to list the assignments.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The ARN of the permission set that is being provisioned. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service
     * Namespaces</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The ARN of the permission set that is being provisioned. For more information about ARNs, see <a
     *         href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service
     *         Namespaces</a> in the <i>AWS General Reference</i>.
     */
    public final String permissionSetArn() {
        return permissionSetArn;
    }

    /**
     * <p>
     * The message that contains an error or exception in case of an operation failure.
     * </p>
     * 
     * @return The message that contains an error or exception in case of an operation failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The date that the permission set was created.
     * </p>
     * 
     * @return The date that the permission set was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(permissionSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionSetProvisioningStatus)) {
            return false;
        }
        PermissionSetProvisioningStatus other = (PermissionSetProvisioningStatus) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(permissionSetArn(), other.permissionSetArn())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(createdDate(), other.createdDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PermissionSetProvisioningStatus").add("Status", statusAsString()).add("RequestId", requestId())
                .add("AccountId", accountId()).add("PermissionSetArn", permissionSetArn()).add("FailureReason", failureReason())
                .add("CreatedDate", createdDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "PermissionSetArn":
            return Optional.ofNullable(clazz.cast(permissionSetArn()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PermissionSetProvisioningStatus, T> g) {
        return obj -> g.apply((PermissionSetProvisioningStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PermissionSetProvisioningStatus> {
        /**
         * <p>
         * The status of the permission set provisioning process.
         * </p>
         * 
         * @param status
         *        The status of the permission set provisioning process.
         * @see StatusValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusValues
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the permission set provisioning process.
         * </p>
         * 
         * @param status
         *        The status of the permission set provisioning process.
         * @see StatusValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusValues
         */
        Builder status(StatusValues status);

        /**
         * <p>
         * The identifier for tracking the request operation that is generated by the universally unique identifier
         * (UUID) workflow.
         * </p>
         * 
         * @param requestId
         *        The identifier for tracking the request operation that is generated by the universally unique
         *        identifier (UUID) workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The identifier of the AWS account from which to list the assignments.
         * </p>
         * 
         * @param accountId
         *        The identifier of the AWS account from which to list the assignments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The ARN of the permission set that is being provisioned. For more information about ARNs, see <a
         * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service
         * Namespaces</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param permissionSetArn
         *        The ARN of the permission set that is being provisioned. For more information about ARNs, see <a
         *        href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service
         *        Namespaces</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionSetArn(String permissionSetArn);

        /**
         * <p>
         * The message that contains an error or exception in case of an operation failure.
         * </p>
         * 
         * @param failureReason
         *        The message that contains an error or exception in case of an operation failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The date that the permission set was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the permission set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String requestId;

        private String accountId;

        private String permissionSetArn;

        private String failureReason;

        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionSetProvisioningStatus model) {
            status(model.status);
            requestId(model.requestId);
            accountId(model.accountId);
            permissionSetArn(model.permissionSetArn);
            failureReason(model.failureReason);
            createdDate(model.createdDate);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusValues status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getPermissionSetArn() {
            return permissionSetArn;
        }

        @Override
        public final Builder permissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
            return this;
        }

        public final void setPermissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public PermissionSetProvisioningStatus build() {
            return new PermissionSetProvisioningStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
