/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountAssignmentCreationStatusRequest extends SsoAdminRequest implements
        ToCopyableBuilder<DescribeAccountAssignmentCreationStatusRequest.Builder, DescribeAccountAssignmentCreationStatusRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(DescribeAccountAssignmentCreationStatusRequest::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<String> ACCOUNT_ASSIGNMENT_CREATION_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountAssignmentCreationRequestId")
            .getter(getter(DescribeAccountAssignmentCreationStatusRequest::accountAssignmentCreationRequestId))
            .setter(setter(Builder::accountAssignmentCreationRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssignmentCreationRequestId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD,
            ACCOUNT_ASSIGNMENT_CREATION_REQUEST_ID_FIELD));

    private final String instanceArn;

    private final String accountAssignmentCreationRequestId;

    private DescribeAccountAssignmentCreationStatusRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.accountAssignmentCreationRequestId = builder.accountAssignmentCreationRequestId;
    }

    /**
     * <p>
     * The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service
     * Namespaces</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The ARN of the SSO instance under which the operation will be executed. For more information about ARNs,
     *         see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS
     *         Service Namespaces</a> in the <i>AWS General Reference</i>.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The identifier that is used to track the request operation progress.
     * </p>
     * 
     * @return The identifier that is used to track the request operation progress.
     */
    public final String accountAssignmentCreationRequestId() {
        return accountAssignmentCreationRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(accountAssignmentCreationRequestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAssignmentCreationStatusRequest)) {
            return false;
        }
        DescribeAccountAssignmentCreationStatusRequest other = (DescribeAccountAssignmentCreationStatusRequest) obj;
        return Objects.equals(instanceArn(), other.instanceArn())
                && Objects.equals(accountAssignmentCreationRequestId(), other.accountAssignmentCreationRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountAssignmentCreationStatusRequest").add("InstanceArn", instanceArn())
                .add("AccountAssignmentCreationRequestId", accountAssignmentCreationRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "AccountAssignmentCreationRequestId":
            return Optional.ofNullable(clazz.cast(accountAssignmentCreationRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountAssignmentCreationStatusRequest, T> g) {
        return obj -> g.apply((DescribeAccountAssignmentCreationStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountAssignmentCreationStatusRequest> {
        /**
         * <p>
         * The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see
         * <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service
         * Namespaces</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the SSO instance under which the operation will be executed. For more information about
         *        ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
         *        AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The identifier that is used to track the request operation progress.
         * </p>
         * 
         * @param accountAssignmentCreationRequestId
         *        The identifier that is used to track the request operation progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssignmentCreationRequestId(String accountAssignmentCreationRequestId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String instanceArn;

        private String accountAssignmentCreationRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAssignmentCreationStatusRequest model) {
            super(model);
            instanceArn(model.instanceArn);
            accountAssignmentCreationRequestId(model.accountAssignmentCreationRequestId);
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        public final String getAccountAssignmentCreationRequestId() {
            return accountAssignmentCreationRequestId;
        }

        @Override
        public final Builder accountAssignmentCreationRequestId(String accountAssignmentCreationRequestId) {
            this.accountAssignmentCreationRequestId = accountAssignmentCreationRequestId;
            return this;
        }

        public final void setAccountAssignmentCreationRequestId(String accountAssignmentCreationRequestId) {
            this.accountAssignmentCreationRequestId = accountAssignmentCreationRequestId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAccountAssignmentCreationStatusRequest build() {
            return new DescribeAccountAssignmentCreationStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
