/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInlinePolicyForPermissionSetResponse extends SsoAdminResponse implements
        ToCopyableBuilder<GetInlinePolicyForPermissionSetResponse.Builder, GetInlinePolicyForPermissionSetResponse> {
    private static final SdkField<String> INLINE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InlinePolicy").getter(getter(GetInlinePolicyForPermissionSetResponse::inlinePolicy))
            .setter(setter(Builder::inlinePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InlinePolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_POLICY_FIELD));

    private final String inlinePolicy;

    private GetInlinePolicyForPermissionSetResponse(BuilderImpl builder) {
        super(builder);
        this.inlinePolicy = builder.inlinePolicy;
    }

    /**
     * <p>
     * The IAM inline policy that is attached to the permission set.
     * </p>
     * 
     * @return The IAM inline policy that is attached to the permission set.
     */
    public final String inlinePolicy() {
        return inlinePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inlinePolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInlinePolicyForPermissionSetResponse)) {
            return false;
        }
        GetInlinePolicyForPermissionSetResponse other = (GetInlinePolicyForPermissionSetResponse) obj;
        return Objects.equals(inlinePolicy(), other.inlinePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInlinePolicyForPermissionSetResponse")
                .add("InlinePolicy", inlinePolicy() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InlinePolicy":
            return Optional.ofNullable(clazz.cast(inlinePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInlinePolicyForPermissionSetResponse, T> g) {
        return obj -> g.apply((GetInlinePolicyForPermissionSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetInlinePolicyForPermissionSetResponse> {
        /**
         * <p>
         * The IAM inline policy that is attached to the permission set.
         * </p>
         * 
         * @param inlinePolicy
         *        The IAM inline policy that is attached to the permission set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlinePolicy(String inlinePolicy);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private String inlinePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInlinePolicyForPermissionSetResponse model) {
            super(model);
            inlinePolicy(model.inlinePolicy);
        }

        public final String getInlinePolicy() {
            return inlinePolicy;
        }

        @Override
        public final Builder inlinePolicy(String inlinePolicy) {
            this.inlinePolicy = inlinePolicy;
            return this;
        }

        public final void setInlinePolicy(String inlinePolicy) {
            this.inlinePolicy = inlinePolicy;
        }

        @Override
        public GetInlinePolicyForPermissionSetResponse build() {
            return new GetInlinePolicyForPermissionSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
