/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.ssoadmin.model.AccessDeniedException;
import software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ConflictException;
import software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.InternalServerException;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ssoadmin.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminException;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.services.ssoadmin.model.TagResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.TagResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.ThrottlingException;
import software.amazon.awssdk.services.ssoadmin.model.UntagResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.UntagResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ValidationException;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsPublisher;
import software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.ssoadmin.transform.AttachManagedPolicyToPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.CreateAccountAssignmentRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.CreateInstanceAccessControlAttributeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.CreatePermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeleteAccountAssignmentRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeleteInlinePolicyFromPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeleteInstanceAccessControlAttributeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeletePermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribeAccountAssignmentCreationStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribeAccountAssignmentDeletionStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribeInstanceAccessControlAttributeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribePermissionSetProvisioningStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribePermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DetachManagedPolicyFromPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.GetInlinePolicyForPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListAccountAssignmentCreationStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListAccountAssignmentDeletionStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListAccountAssignmentsRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListAccountsForProvisionedPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListInstancesRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListManagedPoliciesInPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListPermissionSetProvisioningStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListPermissionSetsProvisionedToAccountRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListPermissionSetsRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ProvisionPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.PutInlinePolicyToPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.UpdateInstanceAccessControlAttributeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.UpdatePermissionSetRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link SsoAdminAsyncClient}.
 *
 * @see SsoAdminAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultSsoAdminAsyncClient implements SsoAdminAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSsoAdminAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSsoAdminAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Attaches an IAM managed policy ARN to a permission set.
     * </p>
     * <note>
     * <p>
     * If the permission set is already referenced by one or more account assignments, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> after this operation. Calling <code>ProvisionPermissionSet</code>
     * applies the corresponding IAM policy updates to all assigned accounts.
     * </p>
     * </note>
     *
     * @param attachManagedPolicyToPermissionSetRequest
     * @return A Java Future containing the result of the AttachManagedPolicyToPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.AttachManagedPolicyToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachManagedPolicyToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachManagedPolicyToPermissionSetResponse> attachManagedPolicyToPermissionSet(
            AttachManagedPolicyToPermissionSetRequest attachManagedPolicyToPermissionSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                attachManagedPolicyToPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachManagedPolicyToPermissionSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachManagedPolicyToPermissionSetResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AttachManagedPolicyToPermissionSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachManagedPolicyToPermissionSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachManagedPolicyToPermissionSetRequest, AttachManagedPolicyToPermissionSetResponse>()
                            .withOperationName("AttachManagedPolicyToPermissionSet")
                            .withMarshaller(new AttachManagedPolicyToPermissionSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(attachManagedPolicyToPermissionSetRequest));
            CompletableFuture<AttachManagedPolicyToPermissionSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns access to a principal for a specified Amazon Web Services account using a specified permission set.
     * </p>
     * <note>
     * <p>
     * The term <i>principal</i> here refers to a user or group that is defined in Amazon Web Services SSO.
     * </p>
     * </note> <note>
     * <p>
     * As part of a successful <code>CreateAccountAssignment</code> call, the specified permission set will
     * automatically be provisioned to the account in the form of an IAM policy. That policy is attached to the
     * SSO-created IAM role. If the permission set is subsequently updated, the corresponding IAM policies attached to
     * roles in your accounts will not be updated automatically. In this case, you must call
     * <code> <a>ProvisionPermissionSet</a> </code> to make these updates.
     * </p>
     * </note>
     *
     * @param createAccountAssignmentRequest
     * @return A Java Future containing the result of the CreateAccountAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateAccountAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateAccountAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAccountAssignmentResponse> createAccountAssignment(
            CreateAccountAssignmentRequest createAccountAssignmentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccountAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccountAssignment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAccountAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAccountAssignmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAccountAssignmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAccountAssignmentRequest, CreateAccountAssignmentResponse>()
                            .withOperationName("CreateAccountAssignment")
                            .withMarshaller(new CreateAccountAssignmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createAccountAssignmentRequest));
            CompletableFuture<CreateAccountAssignmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the attributes-based access control (ABAC) feature for the specified Amazon Web Services SSO instance.
     * You can also specify new attributes to add to your ABAC configuration during the enabling process. For more
     * information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a>
     * in the <i>Amazon Web Services SSO User Guide</i>.
     * </p>
     *
     * @param createInstanceAccessControlAttributeConfigurationRequest
     * @return A Java Future containing the result of the CreateInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreateInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstanceAccessControlAttributeConfigurationResponse> createInstanceAccessControlAttributeConfiguration(
            CreateInstanceAccessControlAttributeConfigurationRequest createInstanceAccessControlAttributeConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createInstanceAccessControlAttributeConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstanceAccessControlAttributeConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInstanceAccessControlAttributeConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateInstanceAccessControlAttributeConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInstanceAccessControlAttributeConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInstanceAccessControlAttributeConfigurationRequest, CreateInstanceAccessControlAttributeConfigurationResponse>()
                            .withOperationName("CreateInstanceAccessControlAttributeConfiguration")
                            .withMarshaller(
                                    new CreateInstanceAccessControlAttributeConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(createInstanceAccessControlAttributeConfigurationRequest));
            CompletableFuture<CreateInstanceAccessControlAttributeConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a permission set within a specified SSO instance.
     * </p>
     * <note>
     * <p>
     * To grant users and groups access to Amazon Web Services account resources, use
     * <code> <a>CreateAccountAssignment</a> </code>.
     * </p>
     * </note>
     *
     * @param createPermissionSetRequest
     * @return A Java Future containing the result of the CreatePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.CreatePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreatePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePermissionSetResponse> createPermissionSet(
            CreatePermissionSetRequest createPermissionSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPermissionSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePermissionSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePermissionSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePermissionSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePermissionSetRequest, CreatePermissionSetResponse>()
                            .withOperationName("CreatePermissionSet")
                            .withMarshaller(new CreatePermissionSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createPermissionSetRequest));
            CompletableFuture<CreatePermissionSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a principal's access from a specified Amazon Web Services account using a specified permission set.
     * </p>
     *
     * @param deleteAccountAssignmentRequest
     * @return A Java Future containing the result of the DeleteAccountAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteAccountAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteAccountAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccountAssignmentResponse> deleteAccountAssignment(
            DeleteAccountAssignmentRequest deleteAccountAssignmentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountAssignment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAccountAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAccountAssignmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAccountAssignmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountAssignmentRequest, DeleteAccountAssignmentResponse>()
                            .withOperationName("DeleteAccountAssignment")
                            .withMarshaller(new DeleteAccountAssignmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAccountAssignmentRequest));
            CompletableFuture<DeleteAccountAssignmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the inline policy from a specified permission set.
     * </p>
     *
     * @param deleteInlinePolicyFromPermissionSetRequest
     * @return A Java Future containing the result of the DeleteInlinePolicyFromPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteInlinePolicyFromPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInlinePolicyFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInlinePolicyFromPermissionSetResponse> deleteInlinePolicyFromPermissionSet(
            DeleteInlinePolicyFromPermissionSetRequest deleteInlinePolicyFromPermissionSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteInlinePolicyFromPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInlinePolicyFromPermissionSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInlinePolicyFromPermissionSetResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteInlinePolicyFromPermissionSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInlinePolicyFromPermissionSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInlinePolicyFromPermissionSetRequest, DeleteInlinePolicyFromPermissionSetResponse>()
                            .withOperationName("DeleteInlinePolicyFromPermissionSet")
                            .withMarshaller(new DeleteInlinePolicyFromPermissionSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteInlinePolicyFromPermissionSetRequest));
            CompletableFuture<DeleteInlinePolicyFromPermissionSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the attributes-based access control (ABAC) feature for the specified Amazon Web Services SSO instance
     * and deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are
     * received from an identity source and any custom attributes you have previously configured will not be passed. For
     * more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access
     * Control</a> in the <i>Amazon Web Services SSO User Guide</i>.
     * </p>
     *
     * @param deleteInstanceAccessControlAttributeConfigurationRequest
     * @return A Java Future containing the result of the DeleteInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeleteInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInstanceAccessControlAttributeConfigurationResponse> deleteInstanceAccessControlAttributeConfiguration(
            DeleteInstanceAccessControlAttributeConfigurationRequest deleteInstanceAccessControlAttributeConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteInstanceAccessControlAttributeConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInstanceAccessControlAttributeConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInstanceAccessControlAttributeConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteInstanceAccessControlAttributeConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInstanceAccessControlAttributeConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInstanceAccessControlAttributeConfigurationRequest, DeleteInstanceAccessControlAttributeConfigurationResponse>()
                            .withOperationName("DeleteInstanceAccessControlAttributeConfiguration")
                            .withMarshaller(
                                    new DeleteInstanceAccessControlAttributeConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInstanceAccessControlAttributeConfigurationRequest));
            CompletableFuture<DeleteInstanceAccessControlAttributeConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified permission set.
     * </p>
     *
     * @param deletePermissionSetRequest
     * @return A Java Future containing the result of the DeletePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DeletePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePermissionSetResponse> deletePermissionSet(
            DeletePermissionSetRequest deletePermissionSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePermissionSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePermissionSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePermissionSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePermissionSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePermissionSetRequest, DeletePermissionSetResponse>()
                            .withOperationName("DeletePermissionSet")
                            .withMarshaller(new DeletePermissionSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deletePermissionSetRequest));
            CompletableFuture<DeletePermissionSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the status of the assignment creation request.
     * </p>
     *
     * @param describeAccountAssignmentCreationStatusRequest
     * @return A Java Future containing the result of the DescribeAccountAssignmentCreationStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeAccountAssignmentCreationStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountAssignmentCreationStatusResponse> describeAccountAssignmentCreationStatus(
            DescribeAccountAssignmentCreationStatusRequest describeAccountAssignmentCreationStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAccountAssignmentCreationStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountAssignmentCreationStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAccountAssignmentCreationStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeAccountAssignmentCreationStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAccountAssignmentCreationStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountAssignmentCreationStatusRequest, DescribeAccountAssignmentCreationStatusResponse>()
                            .withOperationName("DescribeAccountAssignmentCreationStatus")
                            .withMarshaller(new DescribeAccountAssignmentCreationStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAccountAssignmentCreationStatusRequest));
            CompletableFuture<DescribeAccountAssignmentCreationStatusResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the status of the assignment deletion request.
     * </p>
     *
     * @param describeAccountAssignmentDeletionStatusRequest
     * @return A Java Future containing the result of the DescribeAccountAssignmentDeletionStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeAccountAssignmentDeletionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountAssignmentDeletionStatusResponse> describeAccountAssignmentDeletionStatus(
            DescribeAccountAssignmentDeletionStatusRequest describeAccountAssignmentDeletionStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAccountAssignmentDeletionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountAssignmentDeletionStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAccountAssignmentDeletionStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeAccountAssignmentDeletionStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAccountAssignmentDeletionStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountAssignmentDeletionStatusRequest, DescribeAccountAssignmentDeletionStatusResponse>()
                            .withOperationName("DescribeAccountAssignmentDeletionStatus")
                            .withMarshaller(new DescribeAccountAssignmentDeletionStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAccountAssignmentDeletionStatusRequest));
            CompletableFuture<DescribeAccountAssignmentDeletionStatusResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of Amazon Web Services SSO identity store attributes that have been configured to work with
     * attributes-based access control (ABAC) for the specified Amazon Web Services SSO instance. This will not return
     * attributes configured and sent by an external identity provider. For more information about ABAC, see <a
     * href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>Amazon Web Services
     * SSO User Guide</i>.
     * </p>
     *
     * @param describeInstanceAccessControlAttributeConfigurationRequest
     * @return A Java Future containing the result of the DescribeInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribeInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstanceAccessControlAttributeConfigurationResponse> describeInstanceAccessControlAttributeConfiguration(
            DescribeInstanceAccessControlAttributeConfigurationRequest describeInstanceAccessControlAttributeConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeInstanceAccessControlAttributeConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstanceAccessControlAttributeConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInstanceAccessControlAttributeConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata,
                            DescribeInstanceAccessControlAttributeConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInstanceAccessControlAttributeConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInstanceAccessControlAttributeConfigurationRequest, DescribeInstanceAccessControlAttributeConfigurationResponse>()
                            .withOperationName("DescribeInstanceAccessControlAttributeConfiguration")
                            .withMarshaller(
                                    new DescribeInstanceAccessControlAttributeConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeInstanceAccessControlAttributeConfigurationRequest));
            CompletableFuture<DescribeInstanceAccessControlAttributeConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the details of the permission set.
     * </p>
     *
     * @param describePermissionSetRequest
     * @return A Java Future containing the result of the DescribePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePermissionSetResponse> describePermissionSet(
            DescribePermissionSetRequest describePermissionSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePermissionSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePermissionSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePermissionSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePermissionSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePermissionSetRequest, DescribePermissionSetResponse>()
                            .withOperationName("DescribePermissionSet")
                            .withMarshaller(new DescribePermissionSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describePermissionSetRequest));
            CompletableFuture<DescribePermissionSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the status for the given permission set provisioning request.
     * </p>
     *
     * @param describePermissionSetProvisioningStatusRequest
     * @return A Java Future containing the result of the DescribePermissionSetProvisioningStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DescribePermissionSetProvisioningStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePermissionSetProvisioningStatusResponse> describePermissionSetProvisioningStatus(
            DescribePermissionSetProvisioningStatusRequest describePermissionSetProvisioningStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describePermissionSetProvisioningStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePermissionSetProvisioningStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePermissionSetProvisioningStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribePermissionSetProvisioningStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePermissionSetProvisioningStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePermissionSetProvisioningStatusRequest, DescribePermissionSetProvisioningStatusResponse>()
                            .withOperationName("DescribePermissionSetProvisioningStatus")
                            .withMarshaller(new DescribePermissionSetProvisioningStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describePermissionSetProvisioningStatusRequest));
            CompletableFuture<DescribePermissionSetProvisioningStatusResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches the attached IAM managed policy ARN from the specified permission set.
     * </p>
     *
     * @param detachManagedPolicyFromPermissionSetRequest
     * @return A Java Future containing the result of the DetachManagedPolicyFromPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.DetachManagedPolicyFromPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachManagedPolicyFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetachManagedPolicyFromPermissionSetResponse> detachManagedPolicyFromPermissionSet(
            DetachManagedPolicyFromPermissionSetRequest detachManagedPolicyFromPermissionSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                detachManagedPolicyFromPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachManagedPolicyFromPermissionSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachManagedPolicyFromPermissionSetResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DetachManagedPolicyFromPermissionSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetachManagedPolicyFromPermissionSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachManagedPolicyFromPermissionSetRequest, DetachManagedPolicyFromPermissionSetResponse>()
                            .withOperationName("DetachManagedPolicyFromPermissionSet")
                            .withMarshaller(new DetachManagedPolicyFromPermissionSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(detachManagedPolicyFromPermissionSetRequest));
            CompletableFuture<DetachManagedPolicyFromPermissionSetResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtains the inline policy assigned to the permission set.
     * </p>
     *
     * @param getInlinePolicyForPermissionSetRequest
     * @return A Java Future containing the result of the GetInlinePolicyForPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.GetInlinePolicyForPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetInlinePolicyForPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInlinePolicyForPermissionSetResponse> getInlinePolicyForPermissionSet(
            GetInlinePolicyForPermissionSetRequest getInlinePolicyForPermissionSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getInlinePolicyForPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInlinePolicyForPermissionSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInlinePolicyForPermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInlinePolicyForPermissionSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInlinePolicyForPermissionSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInlinePolicyForPermissionSetRequest, GetInlinePolicyForPermissionSetResponse>()
                            .withOperationName("GetInlinePolicyForPermissionSet")
                            .withMarshaller(new GetInlinePolicyForPermissionSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getInlinePolicyForPermissionSetRequest));
            CompletableFuture<GetInlinePolicyForPermissionSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the status of the Amazon Web Services account assignment creation requests for a specified SSO instance.
     * </p>
     *
     * @param listAccountAssignmentCreationStatusRequest
     * @return A Java Future containing the result of the ListAccountAssignmentCreationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentCreationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccountAssignmentCreationStatusResponse> listAccountAssignmentCreationStatus(
            ListAccountAssignmentCreationStatusRequest listAccountAssignmentCreationStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAccountAssignmentCreationStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountAssignmentCreationStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAccountAssignmentCreationStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListAccountAssignmentCreationStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAccountAssignmentCreationStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccountAssignmentCreationStatusRequest, ListAccountAssignmentCreationStatusResponse>()
                            .withOperationName("ListAccountAssignmentCreationStatus")
                            .withMarshaller(new ListAccountAssignmentCreationStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAccountAssignmentCreationStatusRequest));
            CompletableFuture<ListAccountAssignmentCreationStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the status of the Amazon Web Services account assignment creation requests for a specified SSO instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentCreationStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusPublisher publisher = client.listAccountAssignmentCreationStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusPublisher publisher = client.listAccountAssignmentCreationStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentCreationStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssignmentCreationStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentCreationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    public ListAccountAssignmentCreationStatusPublisher listAccountAssignmentCreationStatusPaginator(
            ListAccountAssignmentCreationStatusRequest listAccountAssignmentCreationStatusRequest) {
        return new ListAccountAssignmentCreationStatusPublisher(this,
                applyPaginatorUserAgent(listAccountAssignmentCreationStatusRequest));
    }

    /**
     * <p>
     * Lists the status of the Amazon Web Services account assignment deletion requests for a specified SSO instance.
     * </p>
     *
     * @param listAccountAssignmentDeletionStatusRequest
     * @return A Java Future containing the result of the ListAccountAssignmentDeletionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccountAssignmentDeletionStatusResponse> listAccountAssignmentDeletionStatus(
            ListAccountAssignmentDeletionStatusRequest listAccountAssignmentDeletionStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAccountAssignmentDeletionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountAssignmentDeletionStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAccountAssignmentDeletionStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListAccountAssignmentDeletionStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAccountAssignmentDeletionStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccountAssignmentDeletionStatusRequest, ListAccountAssignmentDeletionStatusResponse>()
                            .withOperationName("ListAccountAssignmentDeletionStatus")
                            .withMarshaller(new ListAccountAssignmentDeletionStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAccountAssignmentDeletionStatusRequest));
            CompletableFuture<ListAccountAssignmentDeletionStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the status of the Amazon Web Services account assignment deletion requests for a specified SSO instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentDeletionStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusPublisher publisher = client.listAccountAssignmentDeletionStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusPublisher publisher = client.listAccountAssignmentDeletionStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentDeletionStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssignmentDeletionStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignmentDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    public ListAccountAssignmentDeletionStatusPublisher listAccountAssignmentDeletionStatusPaginator(
            ListAccountAssignmentDeletionStatusRequest listAccountAssignmentDeletionStatusRequest) {
        return new ListAccountAssignmentDeletionStatusPublisher(this,
                applyPaginatorUserAgent(listAccountAssignmentDeletionStatusRequest));
    }

    /**
     * <p>
     * Lists the assignee of the specified Amazon Web Services account with the specified permission set.
     * </p>
     *
     * @param listAccountAssignmentsRequest
     * @return A Java Future containing the result of the ListAccountAssignments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccountAssignmentsResponse> listAccountAssignments(
            ListAccountAssignmentsRequest listAccountAssignmentsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccountAssignmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountAssignments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAccountAssignmentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAccountAssignmentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAccountAssignmentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccountAssignmentsRequest, ListAccountAssignmentsResponse>()
                            .withOperationName("ListAccountAssignments")
                            .withMarshaller(new ListAccountAssignmentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAccountAssignmentsRequest));
            CompletableFuture<ListAccountAssignmentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the assignee of the specified Amazon Web Services account with the specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignments(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsPublisher publisher = client.listAccountAssignmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsPublisher publisher = client.listAccountAssignmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignments(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssignmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    public ListAccountAssignmentsPublisher listAccountAssignmentsPaginator(
            ListAccountAssignmentsRequest listAccountAssignmentsRequest) {
        return new ListAccountAssignmentsPublisher(this, applyPaginatorUserAgent(listAccountAssignmentsRequest));
    }

    /**
     * <p>
     * Lists all the Amazon Web Services accounts where the specified permission set is provisioned.
     * </p>
     *
     * @param listAccountsForProvisionedPermissionSetRequest
     * @return A Java Future containing the result of the ListAccountsForProvisionedPermissionSet operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountsForProvisionedPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccountsForProvisionedPermissionSetResponse> listAccountsForProvisionedPermissionSet(
            ListAccountsForProvisionedPermissionSetRequest listAccountsForProvisionedPermissionSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAccountsForProvisionedPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountsForProvisionedPermissionSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAccountsForProvisionedPermissionSetResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListAccountsForProvisionedPermissionSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAccountsForProvisionedPermissionSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccountsForProvisionedPermissionSetRequest, ListAccountsForProvisionedPermissionSetResponse>()
                            .withOperationName("ListAccountsForProvisionedPermissionSet")
                            .withMarshaller(new ListAccountsForProvisionedPermissionSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(listAccountsForProvisionedPermissionSetRequest));
            CompletableFuture<ListAccountsForProvisionedPermissionSetResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the Amazon Web Services accounts where the specified permission set is provisioned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountsForProvisionedPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetPublisher publisher = client.listAccountsForProvisionedPermissionSetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetPublisher publisher = client.listAccountsForProvisionedPermissionSetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountsForProvisionedPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountsForProvisionedPermissionSetRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListAccountsForProvisionedPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    public ListAccountsForProvisionedPermissionSetPublisher listAccountsForProvisionedPermissionSetPaginator(
            ListAccountsForProvisionedPermissionSetRequest listAccountsForProvisionedPermissionSetRequest) {
        return new ListAccountsForProvisionedPermissionSetPublisher(this,
                applyPaginatorUserAgent(listAccountsForProvisionedPermissionSetRequest));
    }

    /**
     * <p>
     * Lists the SSO instances that the caller has access to.
     * </p>
     *
     * @param listInstancesRequest
     * @return A Java Future containing the result of the ListInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListInstancesResponse> listInstances(ListInstancesRequest listInstancesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListInstancesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInstancesRequest, ListInstancesResponse>()
                            .withOperationName("ListInstances")
                            .withMarshaller(new ListInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listInstancesRequest));
            CompletableFuture<ListInstancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the SSO instances that the caller has access to.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listInstances(software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest)} operation.</b>
     * </p>
     *
     * @param listInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    public ListInstancesPublisher listInstancesPaginator(ListInstancesRequest listInstancesRequest) {
        return new ListInstancesPublisher(this, applyPaginatorUserAgent(listInstancesRequest));
    }

    /**
     * <p>
     * Lists the IAM managed policy that is attached to a specified permission set.
     * </p>
     *
     * @param listManagedPoliciesInPermissionSetRequest
     * @return A Java Future containing the result of the ListManagedPoliciesInPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListManagedPoliciesInPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListManagedPoliciesInPermissionSetResponse> listManagedPoliciesInPermissionSet(
            ListManagedPoliciesInPermissionSetRequest listManagedPoliciesInPermissionSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listManagedPoliciesInPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListManagedPoliciesInPermissionSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListManagedPoliciesInPermissionSetResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListManagedPoliciesInPermissionSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListManagedPoliciesInPermissionSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListManagedPoliciesInPermissionSetRequest, ListManagedPoliciesInPermissionSetResponse>()
                            .withOperationName("ListManagedPoliciesInPermissionSet")
                            .withMarshaller(new ListManagedPoliciesInPermissionSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listManagedPoliciesInPermissionSetRequest));
            CompletableFuture<ListManagedPoliciesInPermissionSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the IAM managed policy that is attached to a specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listManagedPoliciesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetPublisher publisher = client.listManagedPoliciesInPermissionSetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetPublisher publisher = client.listManagedPoliciesInPermissionSetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedPoliciesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedPoliciesInPermissionSetRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListManagedPoliciesInPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    public ListManagedPoliciesInPermissionSetPublisher listManagedPoliciesInPermissionSetPaginator(
            ListManagedPoliciesInPermissionSetRequest listManagedPoliciesInPermissionSetRequest) {
        return new ListManagedPoliciesInPermissionSetPublisher(this,
                applyPaginatorUserAgent(listManagedPoliciesInPermissionSetRequest));
    }

    /**
     * <p>
     * Lists the status of the permission set provisioning requests for a specified SSO instance.
     * </p>
     *
     * @param listPermissionSetProvisioningStatusRequest
     * @return A Java Future containing the result of the ListPermissionSetProvisioningStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetProvisioningStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPermissionSetProvisioningStatusResponse> listPermissionSetProvisioningStatus(
            ListPermissionSetProvisioningStatusRequest listPermissionSetProvisioningStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listPermissionSetProvisioningStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPermissionSetProvisioningStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPermissionSetProvisioningStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListPermissionSetProvisioningStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPermissionSetProvisioningStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPermissionSetProvisioningStatusRequest, ListPermissionSetProvisioningStatusResponse>()
                            .withOperationName("ListPermissionSetProvisioningStatus")
                            .withMarshaller(new ListPermissionSetProvisioningStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listPermissionSetProvisioningStatusRequest));
            CompletableFuture<ListPermissionSetProvisioningStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the status of the permission set provisioning requests for a specified SSO instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSetProvisioningStatus(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusPublisher publisher = client.listPermissionSetProvisioningStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusPublisher publisher = client.listPermissionSetProvisioningStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSetProvisioningStatus(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionSetProvisioningStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetProvisioningStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    public ListPermissionSetProvisioningStatusPublisher listPermissionSetProvisioningStatusPaginator(
            ListPermissionSetProvisioningStatusRequest listPermissionSetProvisioningStatusRequest) {
        return new ListPermissionSetProvisioningStatusPublisher(this,
                applyPaginatorUserAgent(listPermissionSetProvisioningStatusRequest));
    }

    /**
     * <p>
     * Lists the <a>PermissionSet</a>s in an SSO instance.
     * </p>
     *
     * @param listPermissionSetsRequest
     * @return A Java Future containing the result of the ListPermissionSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPermissionSetsResponse> listPermissionSets(ListPermissionSetsRequest listPermissionSetsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPermissionSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPermissionSets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPermissionSetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPermissionSetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPermissionSetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPermissionSetsRequest, ListPermissionSetsResponse>()
                            .withOperationName("ListPermissionSets")
                            .withMarshaller(new ListPermissionSetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listPermissionSetsRequest));
            CompletableFuture<ListPermissionSetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the <a>PermissionSet</a>s in an SSO instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSets(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsPublisher publisher = client.listPermissionSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsPublisher publisher = client.listPermissionSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSets(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets" target="_top">AWS
     *      API Documentation</a>
     */
    public ListPermissionSetsPublisher listPermissionSetsPaginator(ListPermissionSetsRequest listPermissionSetsRequest) {
        return new ListPermissionSetsPublisher(this, applyPaginatorUserAgent(listPermissionSetsRequest));
    }

    /**
     * <p>
     * Lists all the permission sets that are provisioned to a specified Amazon Web Services account.
     * </p>
     *
     * @param listPermissionSetsProvisionedToAccountRequest
     * @return A Java Future containing the result of the ListPermissionSetsProvisionedToAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetsProvisionedToAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPermissionSetsProvisionedToAccountResponse> listPermissionSetsProvisionedToAccount(
            ListPermissionSetsProvisionedToAccountRequest listPermissionSetsProvisionedToAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listPermissionSetsProvisionedToAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPermissionSetsProvisionedToAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPermissionSetsProvisionedToAccountResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListPermissionSetsProvisionedToAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPermissionSetsProvisionedToAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPermissionSetsProvisionedToAccountRequest, ListPermissionSetsProvisionedToAccountResponse>()
                            .withOperationName("ListPermissionSetsProvisionedToAccount")
                            .withMarshaller(new ListPermissionSetsProvisionedToAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listPermissionSetsProvisionedToAccountRequest));
            CompletableFuture<ListPermissionSetsProvisionedToAccountResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the permission sets that are provisioned to a specified Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSetsProvisionedToAccount(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountPublisher publisher = client.listPermissionSetsProvisionedToAccountPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountPublisher publisher = client.listPermissionSetsProvisionedToAccountPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSetsProvisionedToAccount(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionSetsProvisionedToAccountRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListPermissionSetsProvisionedToAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    public ListPermissionSetsProvisionedToAccountPublisher listPermissionSetsProvisionedToAccountPaginator(
            ListPermissionSetsProvisionedToAccountRequest listPermissionSetsProvisionedToAccountRequest) {
        return new ListPermissionSetsProvisionedToAccountPublisher(this,
                applyPaginatorUserAgent(listPermissionSetsProvisionedToAccountRequest));
    }

    /**
     * <p>
     * Lists the tags that are attached to a specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags that are attached to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    public ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    /**
     * <p>
     * The process by which a specified permission set is provisioned to the specified target.
     * </p>
     *
     * @param provisionPermissionSetRequest
     * @return A Java Future containing the result of the ProvisionPermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.ProvisionPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ProvisionPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ProvisionPermissionSetResponse> provisionPermissionSet(
            ProvisionPermissionSetRequest provisionPermissionSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, provisionPermissionSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ProvisionPermissionSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ProvisionPermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ProvisionPermissionSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ProvisionPermissionSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ProvisionPermissionSetRequest, ProvisionPermissionSetResponse>()
                            .withOperationName("ProvisionPermissionSet")
                            .withMarshaller(new ProvisionPermissionSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(provisionPermissionSetRequest));
            CompletableFuture<ProvisionPermissionSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches an IAM inline policy to a permission set.
     * </p>
     * <note>
     * <p>
     * If the permission set is already referenced by one or more account assignments, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> after this action to apply the corresponding IAM policy updates to
     * all assigned accounts.
     * </p>
     * </note>
     *
     * @param putInlinePolicyToPermissionSetRequest
     * @return A Java Future containing the result of the PutInlinePolicyToPermissionSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.PutInlinePolicyToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutInlinePolicyToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutInlinePolicyToPermissionSetResponse> putInlinePolicyToPermissionSet(
            PutInlinePolicyToPermissionSetRequest putInlinePolicyToPermissionSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putInlinePolicyToPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutInlinePolicyToPermissionSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutInlinePolicyToPermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutInlinePolicyToPermissionSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutInlinePolicyToPermissionSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutInlinePolicyToPermissionSetRequest, PutInlinePolicyToPermissionSetResponse>()
                            .withOperationName("PutInlinePolicyToPermissionSet")
                            .withMarshaller(new PutInlinePolicyToPermissionSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putInlinePolicyToPermissionSetRequest));
            CompletableFuture<PutInlinePolicyToPermissionSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a set of tags with a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ServiceQuotaExceededException Indicates that the principal has crossed the permitted number of
     *         resources that can be created.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a set of tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the Amazon Web Services SSO identity store attributes that you can use with the Amazon Web Services SSO
     * instance for attributes-based access control (ABAC). When using an external identity provider as an identity
     * source, you can pass attributes through the SAML assertion as an alternative to configuring attributes from the
     * Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services
     * SSO replaces the attribute value with the value from the Amazon Web Services SSO identity store. For more
     * information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a>
     * in the <i>Amazon Web Services SSO User Guide</i>.
     * </p>
     *
     * @param updateInstanceAccessControlAttributeConfigurationRequest
     * @return A Java Future containing the result of the UpdateInstanceAccessControlAttributeConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UpdateInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateInstanceAccessControlAttributeConfigurationResponse> updateInstanceAccessControlAttributeConfiguration(
            UpdateInstanceAccessControlAttributeConfigurationRequest updateInstanceAccessControlAttributeConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateInstanceAccessControlAttributeConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInstanceAccessControlAttributeConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateInstanceAccessControlAttributeConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateInstanceAccessControlAttributeConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateInstanceAccessControlAttributeConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateInstanceAccessControlAttributeConfigurationRequest, UpdateInstanceAccessControlAttributeConfigurationResponse>()
                            .withOperationName("UpdateInstanceAccessControlAttributeConfiguration")
                            .withMarshaller(
                                    new UpdateInstanceAccessControlAttributeConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(updateInstanceAccessControlAttributeConfigurationRequest));
            CompletableFuture<UpdateInstanceAccessControlAttributeConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing permission set.
     * </p>
     *
     * @param updatePermissionSetRequest
     * @return A Java Future containing the result of the UpdatePermissionSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Indicates that a requested resource is not found.</li>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception, or
     *         failure with an internal server.</li>
     *         <li>ThrottlingException Indicates that the principal has crossed the throttling limits of the API
     *         operations.</li>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException Occurs when a conflict with a previous successful write is detected. This generally
     *         occurs when the previous write did not have time to propagate to the host serving the current request. A
     *         retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsoAdminException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsoAdminAsyncClient.UpdatePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdatePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePermissionSetResponse> updatePermissionSet(
            UpdatePermissionSetRequest updatePermissionSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePermissionSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePermissionSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePermissionSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePermissionSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePermissionSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePermissionSetRequest, UpdatePermissionSetResponse>()
                            .withOperationName("UpdatePermissionSet")
                            .withMarshaller(new UpdatePermissionSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updatePermissionSetRequest));
            CompletableFuture<UpdatePermissionSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(SsoAdminException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends SsoAdminRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
