/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachManagedPolicyToPermissionSetRequest extends SsoAdminRequest implements
        ToCopyableBuilder<AttachManagedPolicyToPermissionSetRequest.Builder, AttachManagedPolicyToPermissionSetRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(AttachManagedPolicyToPermissionSetRequest::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<String> PERMISSION_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionSetArn").getter(getter(AttachManagedPolicyToPermissionSetRequest::permissionSetArn))
            .setter(setter(Builder::permissionSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetArn").build()).build();

    private static final SdkField<String> MANAGED_POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedPolicyArn").getter(getter(AttachManagedPolicyToPermissionSetRequest::managedPolicyArn))
            .setter(setter(Builder::managedPolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedPolicyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD,
            PERMISSION_SET_ARN_FIELD, MANAGED_POLICY_ARN_FIELD));

    private final String instanceArn;

    private final String permissionSetArn;

    private final String managedPolicyArn;

    private AttachManagedPolicyToPermissionSetRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.permissionSetArn = builder.permissionSetArn;
        this.managedPolicyArn = builder.managedPolicyArn;
    }

    /**
     * <p>
     * The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services
     * Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The ARN of the SSO instance under which the operation will be executed. For more information about ARNs,
     *         see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web
     *         Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The ARN of the <a>PermissionSet</a> that the managed policy should be attached to.
     * </p>
     * 
     * @return The ARN of the <a>PermissionSet</a> that the managed policy should be attached to.
     */
    public final String permissionSetArn() {
        return permissionSetArn;
    }

    /**
     * <p>
     * The IAM managed policy ARN to be attached to a permission set.
     * </p>
     * 
     * @return The IAM managed policy ARN to be attached to a permission set.
     */
    public final String managedPolicyArn() {
        return managedPolicyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(permissionSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(managedPolicyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachManagedPolicyToPermissionSetRequest)) {
            return false;
        }
        AttachManagedPolicyToPermissionSetRequest other = (AttachManagedPolicyToPermissionSetRequest) obj;
        return Objects.equals(instanceArn(), other.instanceArn()) && Objects.equals(permissionSetArn(), other.permissionSetArn())
                && Objects.equals(managedPolicyArn(), other.managedPolicyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachManagedPolicyToPermissionSetRequest").add("InstanceArn", instanceArn())
                .add("PermissionSetArn", permissionSetArn()).add("ManagedPolicyArn", managedPolicyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "PermissionSetArn":
            return Optional.ofNullable(clazz.cast(permissionSetArn()));
        case "ManagedPolicyArn":
            return Optional.ofNullable(clazz.cast(managedPolicyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachManagedPolicyToPermissionSetRequest, T> g) {
        return obj -> g.apply((AttachManagedPolicyToPermissionSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AttachManagedPolicyToPermissionSetRequest> {
        /**
         * <p>
         * The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see
         * <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web
         * Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the SSO instance under which the operation will be executed. For more information about
         *        ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
         *        Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The ARN of the <a>PermissionSet</a> that the managed policy should be attached to.
         * </p>
         * 
         * @param permissionSetArn
         *        The ARN of the <a>PermissionSet</a> that the managed policy should be attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionSetArn(String permissionSetArn);

        /**
         * <p>
         * The IAM managed policy ARN to be attached to a permission set.
         * </p>
         * 
         * @param managedPolicyArn
         *        The IAM managed policy ARN to be attached to a permission set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedPolicyArn(String managedPolicyArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String instanceArn;

        private String permissionSetArn;

        private String managedPolicyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachManagedPolicyToPermissionSetRequest model) {
            super(model);
            instanceArn(model.instanceArn);
            permissionSetArn(model.permissionSetArn);
            managedPolicyArn(model.managedPolicyArn);
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getPermissionSetArn() {
            return permissionSetArn;
        }

        public final void setPermissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
        }

        @Override
        public final Builder permissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
            return this;
        }

        public final String getManagedPolicyArn() {
            return managedPolicyArn;
        }

        public final void setManagedPolicyArn(String managedPolicyArn) {
            this.managedPolicyArn = managedPolicyArn;
        }

        @Override
        public final Builder managedPolicyArn(String managedPolicyArn) {
            this.managedPolicyArn = managedPolicyArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachManagedPolicyToPermissionSetRequest build() {
            return new AttachManagedPolicyToPermissionSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
