/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * These are Amazon Web Services SSO identity store attributes that you can configure for use in attributes-based access
 * control (ABAC). You can create permissions policies that determine who can access your Amazon Web Services resources
 * based upon the configured attribute values. When you enable ABAC and specify <code>AccessControlAttributes</code>,
 * Amazon Web Services SSO passes the attribute values of the authenticated user into IAM for use in policy evaluation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessControlAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessControlAttribute.Builder, AccessControlAttribute> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(AccessControlAttribute::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<AccessControlAttributeValue> VALUE_FIELD = SdkField
            .<AccessControlAttributeValue> builder(MarshallingType.SDK_POJO).memberName("Value")
            .getter(getter(AccessControlAttribute::value)).setter(setter(Builder::value))
            .constructor(AccessControlAttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final AccessControlAttributeValue value;

    private AccessControlAttribute(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the attribute associated with your identities in your identity source. This is used to map a
     * specified attribute in your identity source with an attribute in Amazon Web Services SSO.
     * </p>
     * 
     * @return The name of the attribute associated with your identities in your identity source. This is used to map a
     *         specified attribute in your identity source with an attribute in Amazon Web Services SSO.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The value used for mapping a specified attribute to an identity source.
     * </p>
     * 
     * @return The value used for mapping a specified attribute to an identity source.
     */
    public final AccessControlAttributeValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessControlAttribute)) {
            return false;
        }
        AccessControlAttribute other = (AccessControlAttribute) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessControlAttribute").add("Key", key()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessControlAttribute, T> g) {
        return obj -> g.apply((AccessControlAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessControlAttribute> {
        /**
         * <p>
         * The name of the attribute associated with your identities in your identity source. This is used to map a
         * specified attribute in your identity source with an attribute in Amazon Web Services SSO.
         * </p>
         * 
         * @param key
         *        The name of the attribute associated with your identities in your identity source. This is used to map
         *        a specified attribute in your identity source with an attribute in Amazon Web Services SSO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value used for mapping a specified attribute to an identity source.
         * </p>
         * 
         * @param value
         *        The value used for mapping a specified attribute to an identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(AccessControlAttributeValue value);

        /**
         * <p>
         * The value used for mapping a specified attribute to an identity source.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessControlAttributeValue.Builder}
         * avoiding the need to create one manually via {@link AccessControlAttributeValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessControlAttributeValue.Builder#build()} is called
         * immediately and its result is passed to {@link #value(AccessControlAttributeValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link AccessControlAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(AccessControlAttributeValue)
         */
        default Builder value(Consumer<AccessControlAttributeValue.Builder> value) {
            return value(AccessControlAttributeValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private AccessControlAttributeValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessControlAttribute model) {
            key(model.key);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final AccessControlAttributeValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(AccessControlAttributeValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(AccessControlAttributeValue value) {
            this.value = value;
            return this;
        }

        @Override
        public AccessControlAttribute build() {
            return new AccessControlAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
