/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The assignment that indicates a principal's limited access to a specified Amazon Web Services account with a
 * specified permission set.
 * </p>
 * <note>
 * <p>
 * The term <i>principal</i> here refers to a user or group that is defined in Amazon Web Services SSO.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountAssignment implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountAssignment.Builder, AccountAssignment> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(AccountAssignment::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> PERMISSION_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionSetArn").getter(getter(AccountAssignment::permissionSetArn))
            .setter(setter(Builder::permissionSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetArn").build()).build();

    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalType").getter(getter(AccountAssignment::principalTypeAsString))
            .setter(setter(Builder::principalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalId").getter(getter(AccountAssignment::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            PERMISSION_SET_ARN_FIELD, PRINCIPAL_TYPE_FIELD, PRINCIPAL_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String permissionSetArn;

    private final String principalType;

    private final String principalId;

    private AccountAssignment(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.permissionSetArn = builder.permissionSetArn;
        this.principalType = builder.principalType;
        this.principalId = builder.principalId;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services account.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The ARN of the permission set. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services
     * Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The ARN of the permission set. For more information about ARNs, see <a
     *         href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web
     *         Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String permissionSetArn() {
        return permissionSetArn;
    }

    /**
     * <p>
     * The entity type for which the assignment will be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return The entity type for which the assignment will be created.
     * @see PrincipalType
     */
    public final PrincipalType principalType() {
        return PrincipalType.fromValue(principalType);
    }

    /**
     * <p>
     * The entity type for which the assignment will be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return The entity type for which the assignment will be created.
     * @see PrincipalType
     */
    public final String principalTypeAsString() {
        return principalType;
    }

    /**
     * <p>
     * An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For
     * example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services
     * SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO
     * Identity Store API Reference</a>.
     * </p>
     * 
     * @return An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs
     *         (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon
     *         Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon
     *         Web Services SSO Identity Store API Reference</a>.
     */
    public final String principalId() {
        return principalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(permissionSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(principalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAssignment)) {
            return false;
        }
        AccountAssignment other = (AccountAssignment) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(permissionSetArn(), other.permissionSetArn())
                && Objects.equals(principalTypeAsString(), other.principalTypeAsString())
                && Objects.equals(principalId(), other.principalId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountAssignment").add("AccountId", accountId()).add("PermissionSetArn", permissionSetArn())
                .add("PrincipalType", principalTypeAsString()).add("PrincipalId", principalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "PermissionSetArn":
            return Optional.ofNullable(clazz.cast(permissionSetArn()));
        case "PrincipalType":
            return Optional.ofNullable(clazz.cast(principalTypeAsString()));
        case "PrincipalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountAssignment, T> g) {
        return obj -> g.apply((AccountAssignment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountAssignment> {
        /**
         * <p>
         * The identifier of the Amazon Web Services account.
         * </p>
         * 
         * @param accountId
         *        The identifier of the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The ARN of the permission set. For more information about ARNs, see <a
         * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services
         * Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param permissionSetArn
         *        The ARN of the permission set. For more information about ARNs, see <a
         *        href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web
         *        Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionSetArn(String permissionSetArn);

        /**
         * <p>
         * The entity type for which the assignment will be created.
         * </p>
         * 
         * @param principalType
         *        The entity type for which the assignment will be created.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(String principalType);

        /**
         * <p>
         * The entity type for which the assignment will be created.
         * </p>
         * 
         * @param principalType
         *        The entity type for which the assignment will be created.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(PrincipalType principalType);

        /**
         * <p>
         * An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For
         * example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web
         * Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web
         * Services SSO Identity Store API Reference</a>.
         * </p>
         * 
         * @param principalId
         *        An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are
         *        GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in
         *        Amazon Web Services SSO, see the <a
         *        href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity
         *        Store API Reference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String permissionSetArn;

        private String principalType;

        private String principalId;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAssignment model) {
            accountId(model.accountId);
            permissionSetArn(model.permissionSetArn);
            principalType(model.principalType);
            principalId(model.principalId);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getPermissionSetArn() {
            return permissionSetArn;
        }

        public final void setPermissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
        }

        @Override
        public final Builder permissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
            return this;
        }

        public final String getPrincipalType() {
            return principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        @Override
        public AccountAssignment build() {
            return new AccountAssignment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
