/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccountAssignmentRequest extends SsoAdminRequest implements
        ToCopyableBuilder<CreateAccountAssignmentRequest.Builder, CreateAccountAssignmentRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(CreateAccountAssignmentRequest::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetId").getter(getter(CreateAccountAssignmentRequest::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetType").getter(getter(CreateAccountAssignmentRequest::targetTypeAsString))
            .setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final SdkField<String> PERMISSION_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionSetArn").getter(getter(CreateAccountAssignmentRequest::permissionSetArn))
            .setter(setter(Builder::permissionSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetArn").build()).build();

    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalType").getter(getter(CreateAccountAssignmentRequest::principalTypeAsString))
            .setter(setter(Builder::principalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalId").getter(getter(CreateAccountAssignmentRequest::principalId))
            .setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD,
            TARGET_ID_FIELD, TARGET_TYPE_FIELD, PERMISSION_SET_ARN_FIELD, PRINCIPAL_TYPE_FIELD, PRINCIPAL_ID_FIELD));

    private final String instanceArn;

    private final String targetId;

    private final String targetType;

    private final String permissionSetArn;

    private final String principalType;

    private final String principalId;

    private CreateAccountAssignmentRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
        this.permissionSetArn = builder.permissionSetArn;
        this.principalType = builder.principalType;
        this.principalId = builder.principalId;
    }

    /**
     * <p>
     * The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information
     * about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon
     * Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more
     *         information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     *         Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General
     *         Reference</i>.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example,
     * 123456789012).
     * </p>
     * 
     * @return TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example,
     *         123456789012).
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * The entity type for which the assignment will be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The entity type for which the assignment will be created.
     * @see TargetType
     */
    public final TargetType targetType() {
        return TargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The entity type for which the assignment will be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The entity type for which the assignment will be created.
     * @see TargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * The ARN of the permission set that the admin wants to grant the principal access to.
     * </p>
     * 
     * @return The ARN of the permission set that the admin wants to grant the principal access to.
     */
    public final String permissionSetArn() {
        return permissionSetArn;
    }

    /**
     * <p>
     * The entity type for which the assignment will be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return The entity type for which the assignment will be created.
     * @see PrincipalType
     */
    public final PrincipalType principalType() {
        return PrincipalType.fromValue(principalType);
    }

    /**
     * <p>
     * The entity type for which the assignment will be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return The entity type for which the assignment will be created.
     * @see PrincipalType
     */
    public final String principalTypeAsString() {
        return principalType;
    }

    /**
     * <p>
     * An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For
     * example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services
     * SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO
     * Identity Store API Reference</a>.
     * </p>
     * 
     * @return An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs
     *         (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon
     *         Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon
     *         Web Services SSO Identity Store API Reference</a>.
     */
    public final String principalId() {
        return principalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(permissionSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(principalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccountAssignmentRequest)) {
            return false;
        }
        CreateAccountAssignmentRequest other = (CreateAccountAssignmentRequest) obj;
        return Objects.equals(instanceArn(), other.instanceArn()) && Objects.equals(targetId(), other.targetId())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString())
                && Objects.equals(permissionSetArn(), other.permissionSetArn())
                && Objects.equals(principalTypeAsString(), other.principalTypeAsString())
                && Objects.equals(principalId(), other.principalId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccountAssignmentRequest").add("InstanceArn", instanceArn()).add("TargetId", targetId())
                .add("TargetType", targetTypeAsString()).add("PermissionSetArn", permissionSetArn())
                .add("PrincipalType", principalTypeAsString()).add("PrincipalId", principalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "PermissionSetArn":
            return Optional.ofNullable(clazz.cast(permissionSetArn()));
        case "PrincipalType":
            return Optional.ofNullable(clazz.cast(principalTypeAsString()));
        case "PrincipalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccountAssignmentRequest, T> g) {
        return obj -> g.apply((CreateAccountAssignmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAccountAssignmentRequest> {
        /**
         * <p>
         * The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more
         * information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more
         *        information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General
         *        Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example,
         * 123456789012).
         * </p>
         * 
         * @param targetId
         *        TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example,
         *        123456789012).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * The entity type for which the assignment will be created.
         * </p>
         * 
         * @param targetType
         *        The entity type for which the assignment will be created.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The entity type for which the assignment will be created.
         * </p>
         * 
         * @param targetType
         *        The entity type for which the assignment will be created.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(TargetType targetType);

        /**
         * <p>
         * The ARN of the permission set that the admin wants to grant the principal access to.
         * </p>
         * 
         * @param permissionSetArn
         *        The ARN of the permission set that the admin wants to grant the principal access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionSetArn(String permissionSetArn);

        /**
         * <p>
         * The entity type for which the assignment will be created.
         * </p>
         * 
         * @param principalType
         *        The entity type for which the assignment will be created.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(String principalType);

        /**
         * <p>
         * The entity type for which the assignment will be created.
         * </p>
         * 
         * @param principalType
         *        The entity type for which the assignment will be created.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(PrincipalType principalType);

        /**
         * <p>
         * An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For
         * example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web
         * Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web
         * Services SSO Identity Store API Reference</a>.
         * </p>
         * 
         * @param principalId
         *        An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are
         *        GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in
         *        Amazon Web Services SSO, see the <a
         *        href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity
         *        Store API Reference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String instanceArn;

        private String targetId;

        private String targetType;

        private String permissionSetArn;

        private String principalType;

        private String principalId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccountAssignmentRequest model) {
            super(model);
            instanceArn(model.instanceArn);
            targetId(model.targetId);
            targetType(model.targetType);
            permissionSetArn(model.permissionSetArn);
            principalType(model.principalType);
            principalId(model.principalId);
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final String getPermissionSetArn() {
            return permissionSetArn;
        }

        public final void setPermissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
        }

        @Override
        public final Builder permissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
            return this;
        }

        public final String getPrincipalType() {
            return principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccountAssignmentRequest build() {
            return new CreateAccountAssignmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
