/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInstanceAccessControlAttributeConfigurationRequest extends SsoAdminRequest
        implements
        ToCopyableBuilder<UpdateInstanceAccessControlAttributeConfigurationRequest.Builder, UpdateInstanceAccessControlAttributeConfigurationRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(UpdateInstanceAccessControlAttributeConfigurationRequest::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<InstanceAccessControlAttributeConfiguration> INSTANCE_ACCESS_CONTROL_ATTRIBUTE_CONFIGURATION_FIELD = SdkField
            .<InstanceAccessControlAttributeConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceAccessControlAttributeConfiguration")
            .getter(getter(UpdateInstanceAccessControlAttributeConfigurationRequest::instanceAccessControlAttributeConfiguration))
            .setter(setter(Builder::instanceAccessControlAttributeConfiguration))
            .constructor(InstanceAccessControlAttributeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("InstanceAccessControlAttributeConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD,
            INSTANCE_ACCESS_CONTROL_ATTRIBUTE_CONFIGURATION_FIELD));

    private final String instanceArn;

    private final InstanceAccessControlAttributeConfiguration instanceAccessControlAttributeConfiguration;

    private UpdateInstanceAccessControlAttributeConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.instanceAccessControlAttributeConfiguration = builder.instanceAccessControlAttributeConfiguration;
    }

    /**
     * <p>
     * The ARN of the IAM Identity Center instance under which the operation will be executed.
     * </p>
     * 
     * @return The ARN of the IAM Identity Center instance under which the operation will be executed.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * Updates the attributes for your ABAC configuration.
     * </p>
     * 
     * @return Updates the attributes for your ABAC configuration.
     */
    public final InstanceAccessControlAttributeConfiguration instanceAccessControlAttributeConfiguration() {
        return instanceAccessControlAttributeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceAccessControlAttributeConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstanceAccessControlAttributeConfigurationRequest)) {
            return false;
        }
        UpdateInstanceAccessControlAttributeConfigurationRequest other = (UpdateInstanceAccessControlAttributeConfigurationRequest) obj;
        return Objects.equals(instanceArn(), other.instanceArn())
                && Objects.equals(instanceAccessControlAttributeConfiguration(),
                        other.instanceAccessControlAttributeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInstanceAccessControlAttributeConfigurationRequest").add("InstanceArn", instanceArn())
                .add("InstanceAccessControlAttributeConfiguration", instanceAccessControlAttributeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "InstanceAccessControlAttributeConfiguration":
            return Optional.ofNullable(clazz.cast(instanceAccessControlAttributeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInstanceAccessControlAttributeConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateInstanceAccessControlAttributeConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateInstanceAccessControlAttributeConfigurationRequest> {
        /**
         * <p>
         * The ARN of the IAM Identity Center instance under which the operation will be executed.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the IAM Identity Center instance under which the operation will be executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * Updates the attributes for your ABAC configuration.
         * </p>
         * 
         * @param instanceAccessControlAttributeConfiguration
         *        Updates the attributes for your ABAC configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceAccessControlAttributeConfiguration(
                InstanceAccessControlAttributeConfiguration instanceAccessControlAttributeConfiguration);

        /**
         * <p>
         * Updates the attributes for your ABAC configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InstanceAccessControlAttributeConfiguration.Builder} avoiding the need to create one manually via
         * {@link InstanceAccessControlAttributeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceAccessControlAttributeConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #instanceAccessControlAttributeConfiguration(InstanceAccessControlAttributeConfiguration)}.
         * 
         * @param instanceAccessControlAttributeConfiguration
         *        a consumer that will call methods on {@link InstanceAccessControlAttributeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceAccessControlAttributeConfiguration(InstanceAccessControlAttributeConfiguration)
         */
        default Builder instanceAccessControlAttributeConfiguration(
                Consumer<InstanceAccessControlAttributeConfiguration.Builder> instanceAccessControlAttributeConfiguration) {
            return instanceAccessControlAttributeConfiguration(InstanceAccessControlAttributeConfiguration.builder()
                    .applyMutation(instanceAccessControlAttributeConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String instanceArn;

        private InstanceAccessControlAttributeConfiguration instanceAccessControlAttributeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInstanceAccessControlAttributeConfigurationRequest model) {
            super(model);
            instanceArn(model.instanceArn);
            instanceAccessControlAttributeConfiguration(model.instanceAccessControlAttributeConfiguration);
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final InstanceAccessControlAttributeConfiguration.Builder getInstanceAccessControlAttributeConfiguration() {
            return instanceAccessControlAttributeConfiguration != null ? instanceAccessControlAttributeConfiguration.toBuilder()
                    : null;
        }

        public final void setInstanceAccessControlAttributeConfiguration(
                InstanceAccessControlAttributeConfiguration.BuilderImpl instanceAccessControlAttributeConfiguration) {
            this.instanceAccessControlAttributeConfiguration = instanceAccessControlAttributeConfiguration != null ? instanceAccessControlAttributeConfiguration
                    .build() : null;
        }

        @Override
        public final Builder instanceAccessControlAttributeConfiguration(
                InstanceAccessControlAttributeConfiguration instanceAccessControlAttributeConfiguration) {
            this.instanceAccessControlAttributeConfiguration = instanceAccessControlAttributeConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInstanceAccessControlAttributeConfigurationRequest build() {
            return new UpdateInstanceAccessControlAttributeConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
