/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPermissionSetProvisioningStatusResponse extends SsoAdminResponse implements
        ToCopyableBuilder<ListPermissionSetProvisioningStatusResponse.Builder, ListPermissionSetProvisioningStatusResponse> {
    private static final SdkField<List<PermissionSetProvisioningStatusMetadata>> PERMISSION_SETS_PROVISIONING_STATUS_FIELD = SdkField
            .<List<PermissionSetProvisioningStatusMetadata>> builder(MarshallingType.LIST)
            .memberName("PermissionSetsProvisioningStatus")
            .getter(getter(ListPermissionSetProvisioningStatusResponse::permissionSetsProvisioningStatus))
            .setter(setter(Builder::permissionSetsProvisioningStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetsProvisioningStatus")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PermissionSetProvisioningStatusMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(PermissionSetProvisioningStatusMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPermissionSetProvisioningStatusResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PERMISSION_SETS_PROVISIONING_STATUS_FIELD, NEXT_TOKEN_FIELD));

    private final List<PermissionSetProvisioningStatusMetadata> permissionSetsProvisioningStatus;

    private final String nextToken;

    private ListPermissionSetProvisioningStatusResponse(BuilderImpl builder) {
        super(builder);
        this.permissionSetsProvisioningStatus = builder.permissionSetsProvisioningStatus;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PermissionSetsProvisioningStatus
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasPermissionSetsProvisioningStatus() {
        return permissionSetsProvisioningStatus != null && !(permissionSetsProvisioningStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status object for the permission set provisioning operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissionSetsProvisioningStatus}
     * method.
     * </p>
     * 
     * @return The status object for the permission set provisioning operation.
     */
    public final List<PermissionSetProvisioningStatusMetadata> permissionSetsProvisioningStatus() {
        return permissionSetsProvisioningStatus;
    }

    /**
     * <p>
     * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make
     * subsequent calls.
     * </p>
     * 
     * @return The pagination token for the list API. Initially the value is null. Use the output of previous API calls
     *         to make subsequent calls.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasPermissionSetsProvisioningStatus() ? permissionSetsProvisioningStatus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPermissionSetProvisioningStatusResponse)) {
            return false;
        }
        ListPermissionSetProvisioningStatusResponse other = (ListPermissionSetProvisioningStatusResponse) obj;
        return hasPermissionSetsProvisioningStatus() == other.hasPermissionSetsProvisioningStatus()
                && Objects.equals(permissionSetsProvisioningStatus(), other.permissionSetsProvisioningStatus())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListPermissionSetProvisioningStatusResponse")
                .add("PermissionSetsProvisioningStatus",
                        hasPermissionSetsProvisioningStatus() ? permissionSetsProvisioningStatus() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PermissionSetsProvisioningStatus":
            return Optional.ofNullable(clazz.cast(permissionSetsProvisioningStatus()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPermissionSetProvisioningStatusResponse, T> g) {
        return obj -> g.apply((ListPermissionSetProvisioningStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPermissionSetProvisioningStatusResponse> {
        /**
         * <p>
         * The status object for the permission set provisioning operation.
         * </p>
         * 
         * @param permissionSetsProvisioningStatus
         *        The status object for the permission set provisioning operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionSetsProvisioningStatus(
                Collection<PermissionSetProvisioningStatusMetadata> permissionSetsProvisioningStatus);

        /**
         * <p>
         * The status object for the permission set provisioning operation.
         * </p>
         * 
         * @param permissionSetsProvisioningStatus
         *        The status object for the permission set provisioning operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionSetsProvisioningStatus(PermissionSetProvisioningStatusMetadata... permissionSetsProvisioningStatus);

        /**
         * <p>
         * The status object for the permission set provisioning operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <PermissionSetProvisioningStatusMetadata>.Builder} avoiding the need to create one manually via {@link List
         * <PermissionSetProvisioningStatusMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PermissionSetProvisioningStatusMetadata>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #permissionSetsProvisioningStatus(List<PermissionSetProvisioningStatusMetadata>)}.
         * 
         * @param permissionSetsProvisioningStatus
         *        a consumer that will call methods on {@link List<PermissionSetProvisioningStatusMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionSetsProvisioningStatus(List<PermissionSetProvisioningStatusMetadata>)
         */
        Builder permissionSetsProvisioningStatus(
                Consumer<PermissionSetProvisioningStatusMetadata.Builder>... permissionSetsProvisioningStatus);

        /**
         * <p>
         * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to
         * make subsequent calls.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the list API. Initially the value is null. Use the output of previous API
         *        calls to make subsequent calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private List<PermissionSetProvisioningStatusMetadata> permissionSetsProvisioningStatus = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPermissionSetProvisioningStatusResponse model) {
            super(model);
            permissionSetsProvisioningStatus(model.permissionSetsProvisioningStatus);
            nextToken(model.nextToken);
        }

        public final List<PermissionSetProvisioningStatusMetadata.Builder> getPermissionSetsProvisioningStatus() {
            List<PermissionSetProvisioningStatusMetadata.Builder> result = PermissionSetProvisioningStatusListCopier
                    .copyToBuilder(this.permissionSetsProvisioningStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissionSetsProvisioningStatus(
                Collection<PermissionSetProvisioningStatusMetadata.BuilderImpl> permissionSetsProvisioningStatus) {
            this.permissionSetsProvisioningStatus = PermissionSetProvisioningStatusListCopier
                    .copyFromBuilder(permissionSetsProvisioningStatus);
        }

        @Override
        @Transient
        public final Builder permissionSetsProvisioningStatus(
                Collection<PermissionSetProvisioningStatusMetadata> permissionSetsProvisioningStatus) {
            this.permissionSetsProvisioningStatus = PermissionSetProvisioningStatusListCopier
                    .copy(permissionSetsProvisioningStatus);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder permissionSetsProvisioningStatus(
                PermissionSetProvisioningStatusMetadata... permissionSetsProvisioningStatus) {
            permissionSetsProvisioningStatus(Arrays.asList(permissionSetsProvisioningStatus));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder permissionSetsProvisioningStatus(
                Consumer<PermissionSetProvisioningStatusMetadata.Builder>... permissionSetsProvisioningStatus) {
            permissionSetsProvisioningStatus(Stream.of(permissionSetsProvisioningStatus)
                    .map(c -> PermissionSetProvisioningStatusMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPermissionSetProvisioningStatusResponse build() {
            return new ListPermissionSetProvisioningStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
