/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An entity that contains IAM policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PermissionSet implements SdkPojo, Serializable, ToCopyableBuilder<PermissionSet.Builder, PermissionSet> {
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate").getter(getter(PermissionSet::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(PermissionSet::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PermissionSet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PERMISSION_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionSetArn").getter(getter(PermissionSet::permissionSetArn))
            .setter(setter(Builder::permissionSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetArn").build()).build();

    private static final SdkField<String> RELAY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelayState").getter(getter(PermissionSet::relayState)).setter(setter(Builder::relayState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayState").build()).build();

    private static final SdkField<String> SESSION_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionDuration").getter(getter(PermissionSet::sessionDuration))
            .setter(setter(Builder::sessionDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionDuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_DATE_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, PERMISSION_SET_ARN_FIELD, RELAY_STATE_FIELD, SESSION_DURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdDate;

    private final String description;

    private final String name;

    private final String permissionSetArn;

    private final String relayState;

    private final String sessionDuration;

    private PermissionSet(BuilderImpl builder) {
        this.createdDate = builder.createdDate;
        this.description = builder.description;
        this.name = builder.name;
        this.permissionSetArn = builder.permissionSetArn;
        this.relayState = builder.relayState;
        this.sessionDuration = builder.sessionDuration;
    }

    /**
     * <p>
     * The date that the permission set was created.
     * </p>
     * 
     * @return The date that the permission set was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The description of the <a>PermissionSet</a>.
     * </p>
     * 
     * @return The description of the <a>PermissionSet</a>.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the permission set.
     * </p>
     * 
     * @return The name of the permission set.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the permission set. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services
     * Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The ARN of the permission set. For more information about ARNs, see <a
     *         href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web
     *         Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String permissionSetArn() {
        return permissionSetArn;
    }

    /**
     * <p>
     * Used to redirect users within the application during the federation authentication process.
     * </p>
     * 
     * @return Used to redirect users within the application during the federation authentication process.
     */
    public final String relayState() {
        return relayState;
    }

    /**
     * <p>
     * The length of time that the application user sessions are valid for in the ISO-8601 standard.
     * </p>
     * 
     * @return The length of time that the application user sessions are valid for in the ISO-8601 standard.
     */
    public final String sessionDuration() {
        return sessionDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(permissionSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(relayState());
        hashCode = 31 * hashCode + Objects.hashCode(sessionDuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionSet)) {
            return false;
        }
        PermissionSet other = (PermissionSet) obj;
        return Objects.equals(createdDate(), other.createdDate()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name()) && Objects.equals(permissionSetArn(), other.permissionSetArn())
                && Objects.equals(relayState(), other.relayState()) && Objects.equals(sessionDuration(), other.sessionDuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PermissionSet").add("CreatedDate", createdDate()).add("Description", description())
                .add("Name", name()).add("PermissionSetArn", permissionSetArn()).add("RelayState", relayState())
                .add("SessionDuration", sessionDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PermissionSetArn":
            return Optional.ofNullable(clazz.cast(permissionSetArn()));
        case "RelayState":
            return Optional.ofNullable(clazz.cast(relayState()));
        case "SessionDuration":
            return Optional.ofNullable(clazz.cast(sessionDuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PermissionSet, T> g) {
        return obj -> g.apply((PermissionSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PermissionSet> {
        /**
         * <p>
         * The date that the permission set was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the permission set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The description of the <a>PermissionSet</a>.
         * </p>
         * 
         * @param description
         *        The description of the <a>PermissionSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the permission set.
         * </p>
         * 
         * @param name
         *        The name of the permission set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the permission set. For more information about ARNs, see <a
         * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services
         * Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param permissionSetArn
         *        The ARN of the permission set. For more information about ARNs, see <a
         *        href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web
         *        Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionSetArn(String permissionSetArn);

        /**
         * <p>
         * Used to redirect users within the application during the federation authentication process.
         * </p>
         * 
         * @param relayState
         *        Used to redirect users within the application during the federation authentication process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relayState(String relayState);

        /**
         * <p>
         * The length of time that the application user sessions are valid for in the ISO-8601 standard.
         * </p>
         * 
         * @param sessionDuration
         *        The length of time that the application user sessions are valid for in the ISO-8601 standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionDuration(String sessionDuration);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdDate;

        private String description;

        private String name;

        private String permissionSetArn;

        private String relayState;

        private String sessionDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionSet model) {
            createdDate(model.createdDate);
            description(model.description);
            name(model.name);
            permissionSetArn(model.permissionSetArn);
            relayState(model.relayState);
            sessionDuration(model.sessionDuration);
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPermissionSetArn() {
            return permissionSetArn;
        }

        public final void setPermissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
        }

        @Override
        public final Builder permissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
            return this;
        }

        public final String getRelayState() {
            return relayState;
        }

        public final void setRelayState(String relayState) {
            this.relayState = relayState;
        }

        @Override
        public final Builder relayState(String relayState) {
            this.relayState = relayState;
            return this;
        }

        public final String getSessionDuration() {
            return sessionDuration;
        }

        public final void setSessionDuration(String sessionDuration) {
            this.sessionDuration = sessionDuration;
        }

        @Override
        public final Builder sessionDuration(String sessionDuration) {
            this.sessionDuration = sessionDuration;
            return this;
        }

        @Override
        public PermissionSet build() {
            return new PermissionSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
