/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTrustedTokenIssuerRequest extends SsoAdminRequest implements
        ToCopyableBuilder<UpdateTrustedTokenIssuerRequest.Builder, UpdateTrustedTokenIssuerRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateTrustedTokenIssuerRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TRUSTED_TOKEN_ISSUER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustedTokenIssuerArn").getter(getter(UpdateTrustedTokenIssuerRequest::trustedTokenIssuerArn))
            .setter(setter(Builder::trustedTokenIssuerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerArn").build())
            .build();

    private static final SdkField<TrustedTokenIssuerUpdateConfiguration> TRUSTED_TOKEN_ISSUER_CONFIGURATION_FIELD = SdkField
            .<TrustedTokenIssuerUpdateConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TrustedTokenIssuerConfiguration")
            .getter(getter(UpdateTrustedTokenIssuerRequest::trustedTokenIssuerConfiguration))
            .setter(setter(Builder::trustedTokenIssuerConfiguration))
            .constructor(TrustedTokenIssuerUpdateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            TRUSTED_TOKEN_ISSUER_ARN_FIELD, TRUSTED_TOKEN_ISSUER_CONFIGURATION_FIELD));

    private final String name;

    private final String trustedTokenIssuerArn;

    private final TrustedTokenIssuerUpdateConfiguration trustedTokenIssuerConfiguration;

    private UpdateTrustedTokenIssuerRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.trustedTokenIssuerArn = builder.trustedTokenIssuerArn;
        this.trustedTokenIssuerConfiguration = builder.trustedTokenIssuerConfiguration;
    }

    /**
     * <p>
     * Specifies the updated name to be applied to the trusted token issuer configuration.
     * </p>
     * 
     * @return Specifies the updated name to be applied to the trusted token issuer configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the ARN of the trusted token issuer configuration that you want to update.
     * </p>
     * 
     * @return Specifies the ARN of the trusted token issuer configuration that you want to update.
     */
    public final String trustedTokenIssuerArn() {
        return trustedTokenIssuerArn;
    }

    /**
     * <p>
     * Specifies a structure with settings to apply to the specified trusted token issuer. The settings that you can
     * provide are determined by the type of the trusted token issuer that you are updating.
     * </p>
     * 
     * @return Specifies a structure with settings to apply to the specified trusted token issuer. The settings that you
     *         can provide are determined by the type of the trusted token issuer that you are updating.
     */
    public final TrustedTokenIssuerUpdateConfiguration trustedTokenIssuerConfiguration() {
        return trustedTokenIssuerConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(trustedTokenIssuerArn());
        hashCode = 31 * hashCode + Objects.hashCode(trustedTokenIssuerConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrustedTokenIssuerRequest)) {
            return false;
        }
        UpdateTrustedTokenIssuerRequest other = (UpdateTrustedTokenIssuerRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(trustedTokenIssuerArn(), other.trustedTokenIssuerArn())
                && Objects.equals(trustedTokenIssuerConfiguration(), other.trustedTokenIssuerConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTrustedTokenIssuerRequest").add("Name", name())
                .add("TrustedTokenIssuerArn", trustedTokenIssuerArn())
                .add("TrustedTokenIssuerConfiguration", trustedTokenIssuerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "TrustedTokenIssuerArn":
            return Optional.ofNullable(clazz.cast(trustedTokenIssuerArn()));
        case "TrustedTokenIssuerConfiguration":
            return Optional.ofNullable(clazz.cast(trustedTokenIssuerConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrustedTokenIssuerRequest, T> g) {
        return obj -> g.apply((UpdateTrustedTokenIssuerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTrustedTokenIssuerRequest> {
        /**
         * <p>
         * Specifies the updated name to be applied to the trusted token issuer configuration.
         * </p>
         * 
         * @param name
         *        Specifies the updated name to be applied to the trusted token issuer configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the ARN of the trusted token issuer configuration that you want to update.
         * </p>
         * 
         * @param trustedTokenIssuerArn
         *        Specifies the ARN of the trusted token issuer configuration that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedTokenIssuerArn(String trustedTokenIssuerArn);

        /**
         * <p>
         * Specifies a structure with settings to apply to the specified trusted token issuer. The settings that you can
         * provide are determined by the type of the trusted token issuer that you are updating.
         * </p>
         * 
         * @param trustedTokenIssuerConfiguration
         *        Specifies a structure with settings to apply to the specified trusted token issuer. The settings that
         *        you can provide are determined by the type of the trusted token issuer that you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedTokenIssuerConfiguration(TrustedTokenIssuerUpdateConfiguration trustedTokenIssuerConfiguration);

        /**
         * <p>
         * Specifies a structure with settings to apply to the specified trusted token issuer. The settings that you can
         * provide are determined by the type of the trusted token issuer that you are updating.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TrustedTokenIssuerUpdateConfiguration.Builder} avoiding the need to create one manually via
         * {@link TrustedTokenIssuerUpdateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrustedTokenIssuerUpdateConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #trustedTokenIssuerConfiguration(TrustedTokenIssuerUpdateConfiguration)}.
         * 
         * @param trustedTokenIssuerConfiguration
         *        a consumer that will call methods on {@link TrustedTokenIssuerUpdateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustedTokenIssuerConfiguration(TrustedTokenIssuerUpdateConfiguration)
         */
        default Builder trustedTokenIssuerConfiguration(
                Consumer<TrustedTokenIssuerUpdateConfiguration.Builder> trustedTokenIssuerConfiguration) {
            return trustedTokenIssuerConfiguration(TrustedTokenIssuerUpdateConfiguration.builder()
                    .applyMutation(trustedTokenIssuerConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String name;

        private String trustedTokenIssuerArn;

        private TrustedTokenIssuerUpdateConfiguration trustedTokenIssuerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrustedTokenIssuerRequest model) {
            super(model);
            name(model.name);
            trustedTokenIssuerArn(model.trustedTokenIssuerArn);
            trustedTokenIssuerConfiguration(model.trustedTokenIssuerConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTrustedTokenIssuerArn() {
            return trustedTokenIssuerArn;
        }

        public final void setTrustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
        }

        @Override
        public final Builder trustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
            return this;
        }

        public final TrustedTokenIssuerUpdateConfiguration.Builder getTrustedTokenIssuerConfiguration() {
            return trustedTokenIssuerConfiguration != null ? trustedTokenIssuerConfiguration.toBuilder() : null;
        }

        public final void setTrustedTokenIssuerConfiguration(
                TrustedTokenIssuerUpdateConfiguration.BuilderImpl trustedTokenIssuerConfiguration) {
            this.trustedTokenIssuerConfiguration = trustedTokenIssuerConfiguration != null ? trustedTokenIssuerConfiguration
                    .build() : null;
        }

        @Override
        public final Builder trustedTokenIssuerConfiguration(TrustedTokenIssuerUpdateConfiguration trustedTokenIssuerConfiguration) {
            this.trustedTokenIssuerConfiguration = trustedTokenIssuerConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrustedTokenIssuerRequest build() {
            return new UpdateTrustedTokenIssuerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
