/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicationProviderResponse extends SsoAdminResponse implements
        ToCopyableBuilder<DescribeApplicationProviderResponse.Builder, DescribeApplicationProviderResponse> {
    private static final SdkField<String> APPLICATION_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationProviderArn").getter(getter(DescribeApplicationProviderResponse::applicationProviderArn))
            .setter(setter(Builder::applicationProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationProviderArn").build())
            .build();

    private static final SdkField<DisplayData> DISPLAY_DATA_FIELD = SdkField.<DisplayData> builder(MarshallingType.SDK_POJO)
            .memberName("DisplayData").getter(getter(DescribeApplicationProviderResponse::displayData))
            .setter(setter(Builder::displayData)).constructor(DisplayData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayData").build()).build();

    private static final SdkField<String> FEDERATION_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FederationProtocol").getter(getter(DescribeApplicationProviderResponse::federationProtocolAsString))
            .setter(setter(Builder::federationProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederationProtocol").build())
            .build();

    private static final SdkField<ResourceServerConfig> RESOURCE_SERVER_CONFIG_FIELD = SdkField
            .<ResourceServerConfig> builder(MarshallingType.SDK_POJO).memberName("ResourceServerConfig")
            .getter(getter(DescribeApplicationProviderResponse::resourceServerConfig))
            .setter(setter(Builder::resourceServerConfig)).constructor(ResourceServerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceServerConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_PROVIDER_ARN_FIELD, DISPLAY_DATA_FIELD, FEDERATION_PROTOCOL_FIELD, RESOURCE_SERVER_CONFIG_FIELD));

    private final String applicationProviderArn;

    private final DisplayData displayData;

    private final String federationProtocol;

    private final ResourceServerConfig resourceServerConfig;

    private DescribeApplicationProviderResponse(BuilderImpl builder) {
        super(builder);
        this.applicationProviderArn = builder.applicationProviderArn;
        this.displayData = builder.displayData;
        this.federationProtocol = builder.federationProtocol;
        this.resourceServerConfig = builder.resourceServerConfig;
    }

    /**
     * <p>
     * The ARN of the application provider.
     * </p>
     * 
     * @return The ARN of the application provider.
     */
    public final String applicationProviderArn() {
        return applicationProviderArn;
    }

    /**
     * <p>
     * A structure with details about the display data for the application provider.
     * </p>
     * 
     * @return A structure with details about the display data for the application provider.
     */
    public final DisplayData displayData() {
        return displayData;
    }

    /**
     * <p>
     * The protocol used to federate to the application provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #federationProtocol} will return {@link FederationProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #federationProtocolAsString}.
     * </p>
     * 
     * @return The protocol used to federate to the application provider.
     * @see FederationProtocol
     */
    public final FederationProtocol federationProtocol() {
        return FederationProtocol.fromValue(federationProtocol);
    }

    /**
     * <p>
     * The protocol used to federate to the application provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #federationProtocol} will return {@link FederationProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #federationProtocolAsString}.
     * </p>
     * 
     * @return The protocol used to federate to the application provider.
     * @see FederationProtocol
     */
    public final String federationProtocolAsString() {
        return federationProtocol;
    }

    /**
     * <p>
     * A structure with details about the receiving application.
     * </p>
     * 
     * @return A structure with details about the receiving application.
     */
    public final ResourceServerConfig resourceServerConfig() {
        return resourceServerConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayData());
        hashCode = 31 * hashCode + Objects.hashCode(federationProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceServerConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationProviderResponse)) {
            return false;
        }
        DescribeApplicationProviderResponse other = (DescribeApplicationProviderResponse) obj;
        return Objects.equals(applicationProviderArn(), other.applicationProviderArn())
                && Objects.equals(displayData(), other.displayData())
                && Objects.equals(federationProtocolAsString(), other.federationProtocolAsString())
                && Objects.equals(resourceServerConfig(), other.resourceServerConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeApplicationProviderResponse").add("ApplicationProviderArn", applicationProviderArn())
                .add("DisplayData", displayData()).add("FederationProtocol", federationProtocolAsString())
                .add("ResourceServerConfig", resourceServerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationProviderArn":
            return Optional.ofNullable(clazz.cast(applicationProviderArn()));
        case "DisplayData":
            return Optional.ofNullable(clazz.cast(displayData()));
        case "FederationProtocol":
            return Optional.ofNullable(clazz.cast(federationProtocolAsString()));
        case "ResourceServerConfig":
            return Optional.ofNullable(clazz.cast(resourceServerConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationProviderResponse, T> g) {
        return obj -> g.apply((DescribeApplicationProviderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeApplicationProviderResponse> {
        /**
         * <p>
         * The ARN of the application provider.
         * </p>
         * 
         * @param applicationProviderArn
         *        The ARN of the application provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationProviderArn(String applicationProviderArn);

        /**
         * <p>
         * A structure with details about the display data for the application provider.
         * </p>
         * 
         * @param displayData
         *        A structure with details about the display data for the application provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayData(DisplayData displayData);

        /**
         * <p>
         * A structure with details about the display data for the application provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link DisplayData.Builder} avoiding the need to
         * create one manually via {@link DisplayData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DisplayData.Builder#build()} is called immediately and its result
         * is passed to {@link #displayData(DisplayData)}.
         * 
         * @param displayData
         *        a consumer that will call methods on {@link DisplayData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayData(DisplayData)
         */
        default Builder displayData(Consumer<DisplayData.Builder> displayData) {
            return displayData(DisplayData.builder().applyMutation(displayData).build());
        }

        /**
         * <p>
         * The protocol used to federate to the application provider.
         * </p>
         * 
         * @param federationProtocol
         *        The protocol used to federate to the application provider.
         * @see FederationProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FederationProtocol
         */
        Builder federationProtocol(String federationProtocol);

        /**
         * <p>
         * The protocol used to federate to the application provider.
         * </p>
         * 
         * @param federationProtocol
         *        The protocol used to federate to the application provider.
         * @see FederationProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FederationProtocol
         */
        Builder federationProtocol(FederationProtocol federationProtocol);

        /**
         * <p>
         * A structure with details about the receiving application.
         * </p>
         * 
         * @param resourceServerConfig
         *        A structure with details about the receiving application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceServerConfig(ResourceServerConfig resourceServerConfig);

        /**
         * <p>
         * A structure with details about the receiving application.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceServerConfig.Builder} avoiding
         * the need to create one manually via {@link ResourceServerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceServerConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceServerConfig(ResourceServerConfig)}.
         * 
         * @param resourceServerConfig
         *        a consumer that will call methods on {@link ResourceServerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceServerConfig(ResourceServerConfig)
         */
        default Builder resourceServerConfig(Consumer<ResourceServerConfig.Builder> resourceServerConfig) {
            return resourceServerConfig(ResourceServerConfig.builder().applyMutation(resourceServerConfig).build());
        }
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private String applicationProviderArn;

        private DisplayData displayData;

        private String federationProtocol;

        private ResourceServerConfig resourceServerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationProviderResponse model) {
            super(model);
            applicationProviderArn(model.applicationProviderArn);
            displayData(model.displayData);
            federationProtocol(model.federationProtocol);
            resourceServerConfig(model.resourceServerConfig);
        }

        public final String getApplicationProviderArn() {
            return applicationProviderArn;
        }

        public final void setApplicationProviderArn(String applicationProviderArn) {
            this.applicationProviderArn = applicationProviderArn;
        }

        @Override
        public final Builder applicationProviderArn(String applicationProviderArn) {
            this.applicationProviderArn = applicationProviderArn;
            return this;
        }

        public final DisplayData.Builder getDisplayData() {
            return displayData != null ? displayData.toBuilder() : null;
        }

        public final void setDisplayData(DisplayData.BuilderImpl displayData) {
            this.displayData = displayData != null ? displayData.build() : null;
        }

        @Override
        public final Builder displayData(DisplayData displayData) {
            this.displayData = displayData;
            return this;
        }

        public final String getFederationProtocol() {
            return federationProtocol;
        }

        public final void setFederationProtocol(String federationProtocol) {
            this.federationProtocol = federationProtocol;
        }

        @Override
        public final Builder federationProtocol(String federationProtocol) {
            this.federationProtocol = federationProtocol;
            return this;
        }

        @Override
        public final Builder federationProtocol(FederationProtocol federationProtocol) {
            this.federationProtocol(federationProtocol == null ? null : federationProtocol.toString());
            return this;
        }

        public final ResourceServerConfig.Builder getResourceServerConfig() {
            return resourceServerConfig != null ? resourceServerConfig.toBuilder() : null;
        }

        public final void setResourceServerConfig(ResourceServerConfig.BuilderImpl resourceServerConfig) {
            this.resourceServerConfig = resourceServerConfig != null ? resourceServerConfig.build() : null;
        }

        @Override
        public final Builder resourceServerConfig(ResourceServerConfig resourceServerConfig) {
            this.resourceServerConfig = resourceServerConfig;
            return this;
        }

        @Override
        public DescribeApplicationProviderResponse build() {
            return new DescribeApplicationProviderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
