/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrustedTokenIssuersResponse extends SsoAdminResponse implements
        ToCopyableBuilder<ListTrustedTokenIssuersResponse.Builder, ListTrustedTokenIssuersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTrustedTokenIssuersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<TrustedTokenIssuerMetadata>> TRUSTED_TOKEN_ISSUERS_FIELD = SdkField
            .<List<TrustedTokenIssuerMetadata>> builder(MarshallingType.LIST)
            .memberName("TrustedTokenIssuers")
            .getter(getter(ListTrustedTokenIssuersResponse::trustedTokenIssuers))
            .setter(setter(Builder::trustedTokenIssuers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrustedTokenIssuerMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrustedTokenIssuerMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TRUSTED_TOKEN_ISSUERS_FIELD));

    private final String nextToken;

    private final List<TrustedTokenIssuerMetadata> trustedTokenIssuers;

    private ListTrustedTokenIssuersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.trustedTokenIssuers = builder.trustedTokenIssuers;
    }

    /**
     * <p>
     * If present, this value indicates that more output is available than is included in the current response. Use this
     * value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part
     * of the output. You should repeat this until the <code>NextToken</code> response element comes back as
     * <code>null</code>. This indicates that this is the last page of results.
     * </p>
     * 
     * @return If present, this value indicates that more output is available than is included in the current response.
     *         Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to
     *         get the next part of the output. You should repeat this until the <code>NextToken</code> response element
     *         comes back as <code>null</code>. This indicates that this is the last page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrustedTokenIssuers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrustedTokenIssuers() {
        return trustedTokenIssuers != null && !(trustedTokenIssuers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array list of the trusted token issuer configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrustedTokenIssuers} method.
     * </p>
     * 
     * @return An array list of the trusted token issuer configurations.
     */
    public final List<TrustedTokenIssuerMetadata> trustedTokenIssuers() {
        return trustedTokenIssuers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrustedTokenIssuers() ? trustedTokenIssuers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrustedTokenIssuersResponse)) {
            return false;
        }
        ListTrustedTokenIssuersResponse other = (ListTrustedTokenIssuersResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasTrustedTokenIssuers() == other.hasTrustedTokenIssuers()
                && Objects.equals(trustedTokenIssuers(), other.trustedTokenIssuers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrustedTokenIssuersResponse").add("NextToken", nextToken())
                .add("TrustedTokenIssuers", hasTrustedTokenIssuers() ? trustedTokenIssuers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TrustedTokenIssuers":
            return Optional.ofNullable(clazz.cast(trustedTokenIssuers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrustedTokenIssuersResponse, T> g) {
        return obj -> g.apply((ListTrustedTokenIssuersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTrustedTokenIssuersResponse> {
        /**
         * <p>
         * If present, this value indicates that more output is available than is included in the current response. Use
         * this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         * next part of the output. You should repeat this until the <code>NextToken</code> response element comes back
         * as <code>null</code>. This indicates that this is the last page of results.
         * </p>
         * 
         * @param nextToken
         *        If present, this value indicates that more output is available than is included in the current
         *        response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the
         *        operation to get the next part of the output. You should repeat this until the <code>NextToken</code>
         *        response element comes back as <code>null</code>. This indicates that this is the last page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array list of the trusted token issuer configurations.
         * </p>
         * 
         * @param trustedTokenIssuers
         *        An array list of the trusted token issuer configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedTokenIssuers(Collection<TrustedTokenIssuerMetadata> trustedTokenIssuers);

        /**
         * <p>
         * An array list of the trusted token issuer configurations.
         * </p>
         * 
         * @param trustedTokenIssuers
         *        An array list of the trusted token issuer configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedTokenIssuers(TrustedTokenIssuerMetadata... trustedTokenIssuers);

        /**
         * <p>
         * An array list of the trusted token issuer configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssoadmin.model.TrustedTokenIssuerMetadata.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.ssoadmin.model.TrustedTokenIssuerMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssoadmin.model.TrustedTokenIssuerMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #trustedTokenIssuers(List<TrustedTokenIssuerMetadata>)}.
         * 
         * @param trustedTokenIssuers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssoadmin.model.TrustedTokenIssuerMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustedTokenIssuers(java.util.Collection<TrustedTokenIssuerMetadata>)
         */
        Builder trustedTokenIssuers(Consumer<TrustedTokenIssuerMetadata.Builder>... trustedTokenIssuers);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<TrustedTokenIssuerMetadata> trustedTokenIssuers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrustedTokenIssuersResponse model) {
            super(model);
            nextToken(model.nextToken);
            trustedTokenIssuers(model.trustedTokenIssuers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TrustedTokenIssuerMetadata.Builder> getTrustedTokenIssuers() {
            List<TrustedTokenIssuerMetadata.Builder> result = TrustedTokenIssuerListCopier
                    .copyToBuilder(this.trustedTokenIssuers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrustedTokenIssuers(Collection<TrustedTokenIssuerMetadata.BuilderImpl> trustedTokenIssuers) {
            this.trustedTokenIssuers = TrustedTokenIssuerListCopier.copyFromBuilder(trustedTokenIssuers);
        }

        @Override
        public final Builder trustedTokenIssuers(Collection<TrustedTokenIssuerMetadata> trustedTokenIssuers) {
            this.trustedTokenIssuers = TrustedTokenIssuerListCopier.copy(trustedTokenIssuers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustedTokenIssuers(TrustedTokenIssuerMetadata... trustedTokenIssuers) {
            trustedTokenIssuers(Arrays.asList(trustedTokenIssuers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustedTokenIssuers(Consumer<TrustedTokenIssuerMetadata.Builder>... trustedTokenIssuers) {
            trustedTokenIssuers(Stream.of(trustedTokenIssuers)
                    .map(c -> TrustedTokenIssuerMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTrustedTokenIssuersResponse build() {
            return new ListTrustedTokenIssuersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
