/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes the options for the access portal associated with an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortalOptions implements SdkPojo, Serializable, ToCopyableBuilder<PortalOptions.Builder, PortalOptions> {
    private static final SdkField<SignInOptions> SIGN_IN_OPTIONS_FIELD = SdkField
            .<SignInOptions> builder(MarshallingType.SDK_POJO).memberName("SignInOptions")
            .getter(getter(PortalOptions::signInOptions)).setter(setter(Builder::signInOptions))
            .constructor(SignInOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignInOptions").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(PortalOptions::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGN_IN_OPTIONS_FIELD,
            VISIBILITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final SignInOptions signInOptions;

    private final String visibility;

    private PortalOptions(BuilderImpl builder) {
        this.signInOptions = builder.signInOptions;
        this.visibility = builder.visibility;
    }

    /**
     * <p>
     * A structure that describes the sign-in options for the access portal.
     * </p>
     * 
     * @return A structure that describes the sign-in options for the access portal.
     */
    public final SignInOptions signInOptions() {
        return signInOptions;
    }

    /**
     * <p>
     * Indicates whether this application is visible in the access portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link ApplicationVisibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityAsString}.
     * </p>
     * 
     * @return Indicates whether this application is visible in the access portal.
     * @see ApplicationVisibility
     */
    public final ApplicationVisibility visibility() {
        return ApplicationVisibility.fromValue(visibility);
    }

    /**
     * <p>
     * Indicates whether this application is visible in the access portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link ApplicationVisibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityAsString}.
     * </p>
     * 
     * @return Indicates whether this application is visible in the access portal.
     * @see ApplicationVisibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(signInOptions());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortalOptions)) {
            return false;
        }
        PortalOptions other = (PortalOptions) obj;
        return Objects.equals(signInOptions(), other.signInOptions())
                && Objects.equals(visibilityAsString(), other.visibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PortalOptions").add("SignInOptions", signInOptions()).add("Visibility", visibilityAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SignInOptions":
            return Optional.ofNullable(clazz.cast(signInOptions()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortalOptions, T> g) {
        return obj -> g.apply((PortalOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortalOptions> {
        /**
         * <p>
         * A structure that describes the sign-in options for the access portal.
         * </p>
         * 
         * @param signInOptions
         *        A structure that describes the sign-in options for the access portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signInOptions(SignInOptions signInOptions);

        /**
         * <p>
         * A structure that describes the sign-in options for the access portal.
         * </p>
         * This is a convenience method that creates an instance of the {@link SignInOptions.Builder} avoiding the need
         * to create one manually via {@link SignInOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SignInOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #signInOptions(SignInOptions)}.
         * 
         * @param signInOptions
         *        a consumer that will call methods on {@link SignInOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signInOptions(SignInOptions)
         */
        default Builder signInOptions(Consumer<SignInOptions.Builder> signInOptions) {
            return signInOptions(SignInOptions.builder().applyMutation(signInOptions).build());
        }

        /**
         * <p>
         * Indicates whether this application is visible in the access portal.
         * </p>
         * 
         * @param visibility
         *        Indicates whether this application is visible in the access portal.
         * @see ApplicationVisibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationVisibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * Indicates whether this application is visible in the access portal.
         * </p>
         * 
         * @param visibility
         *        Indicates whether this application is visible in the access portal.
         * @see ApplicationVisibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationVisibility
         */
        Builder visibility(ApplicationVisibility visibility);
    }

    static final class BuilderImpl implements Builder {
        private SignInOptions signInOptions;

        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(PortalOptions model) {
            signInOptions(model.signInOptions);
            visibility(model.visibility);
        }

        public final SignInOptions.Builder getSignInOptions() {
            return signInOptions != null ? signInOptions.toBuilder() : null;
        }

        public final void setSignInOptions(SignInOptions.BuilderImpl signInOptions) {
            this.signInOptions = signInOptions != null ? signInOptions.build() : null;
        }

        @Override
        public final Builder signInOptions(SignInOptions signInOptions) {
            this.signInOptions = signInOptions;
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(ApplicationVisibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        @Override
        public PortalOptions build() {
            return new PortalOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
