/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationAssignmentConfigurationResponse extends SsoAdminResponse implements
        ToCopyableBuilder<GetApplicationAssignmentConfigurationResponse.Builder, GetApplicationAssignmentConfigurationResponse> {
    private static final SdkField<Boolean> ASSIGNMENT_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AssignmentRequired").getter(getter(GetApplicationAssignmentConfigurationResponse::assignmentRequired))
            .setter(setter(Builder::assignmentRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentRequired").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGNMENT_REQUIRED_FIELD));

    private final Boolean assignmentRequired;

    private GetApplicationAssignmentConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.assignmentRequired = builder.assignmentRequired;
    }

    /**
     * <p>
     * If <code>AssignmentsRequired</code> is <code>true</code> (default value), users don’t have access to the
     * application unless an assignment is created using the <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html"
     * >CreateApplicationAssignment API</a>. If <code>false</code>, all users have access to the application.
     * </p>
     * 
     * @return If <code>AssignmentsRequired</code> is <code>true</code> (default value), users don’t have access to the
     *         application unless an assignment is created using the <a href=
     *         "https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html"
     *         >CreateApplicationAssignment API</a>. If <code>false</code>, all users have access to the application.
     */
    public final Boolean assignmentRequired() {
        return assignmentRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assignmentRequired());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationAssignmentConfigurationResponse)) {
            return false;
        }
        GetApplicationAssignmentConfigurationResponse other = (GetApplicationAssignmentConfigurationResponse) obj;
        return Objects.equals(assignmentRequired(), other.assignmentRequired());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationAssignmentConfigurationResponse").add("AssignmentRequired", assignmentRequired())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssignmentRequired":
            return Optional.ofNullable(clazz.cast(assignmentRequired()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationAssignmentConfigurationResponse, T> g) {
        return obj -> g.apply((GetApplicationAssignmentConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetApplicationAssignmentConfigurationResponse> {
        /**
         * <p>
         * If <code>AssignmentsRequired</code> is <code>true</code> (default value), users don’t have access to the
         * application unless an assignment is created using the <a
         * href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html"
         * >CreateApplicationAssignment API</a>. If <code>false</code>, all users have access to the application.
         * </p>
         * 
         * @param assignmentRequired
         *        If <code>AssignmentsRequired</code> is <code>true</code> (default value), users don’t have access to
         *        the application unless an assignment is created using the <a href=
         *        "https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html"
         *        >CreateApplicationAssignment API</a>. If <code>false</code>, all users have access to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentRequired(Boolean assignmentRequired);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private Boolean assignmentRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationAssignmentConfigurationResponse model) {
            super(model);
            assignmentRequired(model.assignmentRequired);
        }

        public final Boolean getAssignmentRequired() {
            return assignmentRequired;
        }

        public final void setAssignmentRequired(Boolean assignmentRequired) {
            this.assignmentRequired = assignmentRequired;
        }

        @Override
        public final Builder assignmentRequired(Boolean assignmentRequired) {
            this.assignmentRequired = assignmentRequired;
            return this;
        }

        @Override
        public GetApplicationAssignmentConfigurationResponse build() {
            return new GetApplicationAssignmentConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
