/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes an authentication method that can be used by an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationMethod implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationMethod.Builder, AuthenticationMethod> {
    private static final SdkField<IamAuthenticationMethod> IAM_FIELD = SdkField
            .<IamAuthenticationMethod> builder(MarshallingType.SDK_POJO).memberName("Iam")
            .getter(getter(AuthenticationMethod::iam)).setter(setter(Builder::iam)).constructor(IamAuthenticationMethod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iam").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IamAuthenticationMethod iam;

    private final Type type;

    private AuthenticationMethod(BuilderImpl builder) {
        this.iam = builder.iam;
        this.type = builder.type;
    }

    /**
     * <p>
     * A structure that describes details for IAM authentication.
     * </p>
     * 
     * @return A structure that describes details for IAM authentication.
     */
    public final IamAuthenticationMethod iam() {
        return iam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iam());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationMethod)) {
            return false;
        }
        AuthenticationMethod other = (AuthenticationMethod) obj;
        return Objects.equals(iam(), other.iam());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthenticationMethod").add("Iam", iam()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Iam":
            return Optional.ofNullable(clazz.cast(iam()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #iam()} initialized to the given value.
     *
     * <p>
     * A structure that describes details for IAM authentication.
     * </p>
     * 
     * @param iam
     *        A structure that describes details for IAM authentication.
     */
    public static AuthenticationMethod fromIam(IamAuthenticationMethod iam) {
        return builder().iam(iam).build();
    }

    /**
     * Create an instance of this class with {@link #iam()} initialized to the given value.
     *
     * <p>
     * A structure that describes details for IAM authentication.
     * </p>
     * 
     * @param iam
     *        A structure that describes details for IAM authentication.
     */
    public static AuthenticationMethod fromIam(Consumer<IamAuthenticationMethod.Builder> iam) {
        IamAuthenticationMethod.Builder builder = IamAuthenticationMethod.builder();
        iam.accept(builder);
        return fromIam(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Iam", IAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationMethod, T> g) {
        return obj -> g.apply((AuthenticationMethod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationMethod> {
        /**
         * <p>
         * A structure that describes details for IAM authentication.
         * </p>
         * 
         * @param iam
         *        A structure that describes details for IAM authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iam(IamAuthenticationMethod iam);

        /**
         * <p>
         * A structure that describes details for IAM authentication.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamAuthenticationMethod.Builder} avoiding
         * the need to create one manually via {@link IamAuthenticationMethod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamAuthenticationMethod.Builder#build()} is called immediately
         * and its result is passed to {@link #iam(IamAuthenticationMethod)}.
         * 
         * @param iam
         *        a consumer that will call methods on {@link IamAuthenticationMethod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iam(IamAuthenticationMethod)
         */
        default Builder iam(Consumer<IamAuthenticationMethod.Builder> iam) {
            return iam(IamAuthenticationMethod.builder().applyMutation(iam).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IamAuthenticationMethod iam;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationMethod model) {
            iam(model.iam);
        }

        public final IamAuthenticationMethod.Builder getIam() {
            return iam != null ? iam.toBuilder() : null;
        }

        public final void setIam(IamAuthenticationMethod.BuilderImpl iam) {
            Object oldValue = this.iam;
            this.iam = iam != null ? iam.build() : null;
            handleUnionValueChange(Type.IAM, oldValue, this.iam);
        }

        @Override
        public final Builder iam(IamAuthenticationMethod iam) {
            Object oldValue = this.iam;
            this.iam = iam;
            handleUnionValueChange(Type.IAM, oldValue, this.iam);
            return this;
        }

        @Override
        public AuthenticationMethod build() {
            return new AuthenticationMethod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AuthenticationMethod#type()
     */
    public enum Type {
        IAM,

        UNKNOWN_TO_SDK_VERSION
    }
}
