/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrustedTokenIssuerRequest extends SsoAdminRequest implements
        ToCopyableBuilder<CreateTrustedTokenIssuerRequest.Builder, CreateTrustedTokenIssuerRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateTrustedTokenIssuerRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(CreateTrustedTokenIssuerRequest::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateTrustedTokenIssuerRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTrustedTokenIssuerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TrustedTokenIssuerConfiguration> TRUSTED_TOKEN_ISSUER_CONFIGURATION_FIELD = SdkField
            .<TrustedTokenIssuerConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TrustedTokenIssuerConfiguration")
            .getter(getter(CreateTrustedTokenIssuerRequest::trustedTokenIssuerConfiguration))
            .setter(setter(Builder::trustedTokenIssuerConfiguration))
            .constructor(TrustedTokenIssuerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerConfiguration")
                    .build()).build();

    private static final SdkField<String> TRUSTED_TOKEN_ISSUER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustedTokenIssuerType").getter(getter(CreateTrustedTokenIssuerRequest::trustedTokenIssuerTypeAsString))
            .setter(setter(Builder::trustedTokenIssuerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CLIENT_TOKEN_FIELD, INSTANCE_ARN_FIELD, NAME_FIELD, TAGS_FIELD, TRUSTED_TOKEN_ISSUER_CONFIGURATION_FIELD,
                    TRUSTED_TOKEN_ISSUER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String instanceArn;

    private final String name;

    private final List<Tag> tags;

    private final TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration;

    private final String trustedTokenIssuerType;

    private CreateTrustedTokenIssuerRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.instanceArn = builder.instanceArn;
        this.name = builder.name;
        this.tags = builder.tags;
        this.trustedTokenIssuerConfiguration = builder.trustedTokenIssuerConfiguration;
        this.trustedTokenIssuerType = builder.trustedTokenIssuerType;
    }

    /**
     * <p>
     * Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you
     * safely retry the request without accidentally performing the same operation a second time. Passing the same value
     * to a later call to an operation requires that you also pass the same value for all other parameters. We recommend
     * that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.
     * </p>
     * <p>
     * If you don't provide this value, then Amazon Web Services generates a random one for you.
     * </p>
     * <p>
     * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails
     * with an <code>IdempotentParameterMismatch</code> error.
     * </p>
     * 
     * @return Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This
     *         lets you safely retry the request without accidentally performing the same operation a second time.
     *         Passing the same value to a later call to an operation requires that you also pass the same value for all
     *         other parameters. We recommend that you use a <a
     *         href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
     *         <p>
     *         If you don't provide this value, then Amazon Web Services generates a random one for you.
     *         </p>
     *         <p>
     *         If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
     *         retry fails with an <code>IdempotentParameterMismatch</code> error.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specifies the ARN of the instance of IAM Identity Center to contain the new trusted token issuer configuration.
     * </p>
     * 
     * @return Specifies the ARN of the instance of IAM Identity Center to contain the new trusted token issuer
     *         configuration.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * Specifies the name of the new trusted token issuer configuration.
     * </p>
     * 
     * @return Specifies the name of the new trusted token issuer configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies tags to be attached to the new trusted token issuer configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specifies tags to be attached to the new trusted token issuer configuration.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies settings that apply to the new trusted token issuer configuration. The settings that are available
     * depend on what <code>TrustedTokenIssuerType</code> you specify.
     * </p>
     * 
     * @return Specifies settings that apply to the new trusted token issuer configuration. The settings that are
     *         available depend on what <code>TrustedTokenIssuerType</code> you specify.
     */
    public final TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration() {
        return trustedTokenIssuerConfiguration;
    }

    /**
     * <p>
     * Specifies the type of the new trusted token issuer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trustedTokenIssuerType} will return {@link TrustedTokenIssuerType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trustedTokenIssuerTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the new trusted token issuer.
     * @see TrustedTokenIssuerType
     */
    public final TrustedTokenIssuerType trustedTokenIssuerType() {
        return TrustedTokenIssuerType.fromValue(trustedTokenIssuerType);
    }

    /**
     * <p>
     * Specifies the type of the new trusted token issuer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trustedTokenIssuerType} will return {@link TrustedTokenIssuerType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trustedTokenIssuerTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the new trusted token issuer.
     * @see TrustedTokenIssuerType
     */
    public final String trustedTokenIssuerTypeAsString() {
        return trustedTokenIssuerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(trustedTokenIssuerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(trustedTokenIssuerTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrustedTokenIssuerRequest)) {
            return false;
        }
        CreateTrustedTokenIssuerRequest other = (CreateTrustedTokenIssuerRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(instanceArn(), other.instanceArn())
                && Objects.equals(name(), other.name()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(trustedTokenIssuerConfiguration(), other.trustedTokenIssuerConfiguration())
                && Objects.equals(trustedTokenIssuerTypeAsString(), other.trustedTokenIssuerTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrustedTokenIssuerRequest").add("ClientToken", clientToken())
                .add("InstanceArn", instanceArn()).add("Name", name()).add("Tags", hasTags() ? tags() : null)
                .add("TrustedTokenIssuerConfiguration", trustedTokenIssuerConfiguration())
                .add("TrustedTokenIssuerType", trustedTokenIssuerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TrustedTokenIssuerConfiguration":
            return Optional.ofNullable(clazz.cast(trustedTokenIssuerConfiguration()));
        case "TrustedTokenIssuerType":
            return Optional.ofNullable(clazz.cast(trustedTokenIssuerTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("InstanceArn", INSTANCE_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("TrustedTokenIssuerConfiguration", TRUSTED_TOKEN_ISSUER_CONFIGURATION_FIELD);
        map.put("TrustedTokenIssuerType", TRUSTED_TOKEN_ISSUER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrustedTokenIssuerRequest, T> g) {
        return obj -> g.apply((CreateTrustedTokenIssuerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrustedTokenIssuerRequest> {
        /**
         * <p>
         * Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets
         * you safely retry the request without accidentally performing the same operation a second time. Passing the
         * same value to a later call to an operation requires that you also pass the same value for all other
         * parameters. We recommend that you use a <a
         * href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.
         * </p>
         * <p>
         * If you don't provide this value, then Amazon Web Services generates a random one for you.
         * </p>
         * <p>
         * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry
         * fails with an <code>IdempotentParameterMismatch</code> error.
         * </p>
         * 
         * @param clientToken
         *        Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This
         *        lets you safely retry the request without accidentally performing the same operation a second time.
         *        Passing the same value to a later call to an operation requires that you also pass the same value for
         *        all other parameters. We recommend that you use a <a
         *        href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
         *        <p>
         *        If you don't provide this value, then Amazon Web Services generates a random one for you.
         *        </p>
         *        <p>
         *        If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
         *        retry fails with an <code>IdempotentParameterMismatch</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies the ARN of the instance of IAM Identity Center to contain the new trusted token issuer
         * configuration.
         * </p>
         * 
         * @param instanceArn
         *        Specifies the ARN of the instance of IAM Identity Center to contain the new trusted token issuer
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * Specifies the name of the new trusted token issuer configuration.
         * </p>
         * 
         * @param name
         *        Specifies the name of the new trusted token issuer configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies tags to be attached to the new trusted token issuer configuration.
         * </p>
         * 
         * @param tags
         *        Specifies tags to be attached to the new trusted token issuer configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Specifies tags to be attached to the new trusted token issuer configuration.
         * </p>
         * 
         * @param tags
         *        Specifies tags to be attached to the new trusted token issuer configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Specifies tags to be attached to the new trusted token issuer configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssoadmin.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ssoadmin.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssoadmin.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssoadmin.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Specifies settings that apply to the new trusted token issuer configuration. The settings that are available
         * depend on what <code>TrustedTokenIssuerType</code> you specify.
         * </p>
         * 
         * @param trustedTokenIssuerConfiguration
         *        Specifies settings that apply to the new trusted token issuer configuration. The settings that are
         *        available depend on what <code>TrustedTokenIssuerType</code> you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedTokenIssuerConfiguration(TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration);

        /**
         * <p>
         * Specifies settings that apply to the new trusted token issuer configuration. The settings that are available
         * depend on what <code>TrustedTokenIssuerType</code> you specify.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrustedTokenIssuerConfiguration.Builder}
         * avoiding the need to create one manually via {@link TrustedTokenIssuerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrustedTokenIssuerConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #trustedTokenIssuerConfiguration(TrustedTokenIssuerConfiguration)}.
         * 
         * @param trustedTokenIssuerConfiguration
         *        a consumer that will call methods on {@link TrustedTokenIssuerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustedTokenIssuerConfiguration(TrustedTokenIssuerConfiguration)
         */
        default Builder trustedTokenIssuerConfiguration(
                Consumer<TrustedTokenIssuerConfiguration.Builder> trustedTokenIssuerConfiguration) {
            return trustedTokenIssuerConfiguration(TrustedTokenIssuerConfiguration.builder()
                    .applyMutation(trustedTokenIssuerConfiguration).build());
        }

        /**
         * <p>
         * Specifies the type of the new trusted token issuer.
         * </p>
         * 
         * @param trustedTokenIssuerType
         *        Specifies the type of the new trusted token issuer.
         * @see TrustedTokenIssuerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustedTokenIssuerType
         */
        Builder trustedTokenIssuerType(String trustedTokenIssuerType);

        /**
         * <p>
         * Specifies the type of the new trusted token issuer.
         * </p>
         * 
         * @param trustedTokenIssuerType
         *        Specifies the type of the new trusted token issuer.
         * @see TrustedTokenIssuerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustedTokenIssuerType
         */
        Builder trustedTokenIssuerType(TrustedTokenIssuerType trustedTokenIssuerType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String instanceArn;

        private String name;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration;

        private String trustedTokenIssuerType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrustedTokenIssuerRequest model) {
            super(model);
            clientToken(model.clientToken);
            instanceArn(model.instanceArn);
            name(model.name);
            tags(model.tags);
            trustedTokenIssuerConfiguration(model.trustedTokenIssuerConfiguration);
            trustedTokenIssuerType(model.trustedTokenIssuerType);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TrustedTokenIssuerConfiguration.Builder getTrustedTokenIssuerConfiguration() {
            return trustedTokenIssuerConfiguration != null ? trustedTokenIssuerConfiguration.toBuilder() : null;
        }

        public final void setTrustedTokenIssuerConfiguration(
                TrustedTokenIssuerConfiguration.BuilderImpl trustedTokenIssuerConfiguration) {
            this.trustedTokenIssuerConfiguration = trustedTokenIssuerConfiguration != null ? trustedTokenIssuerConfiguration
                    .build() : null;
        }

        @Override
        public final Builder trustedTokenIssuerConfiguration(TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration) {
            this.trustedTokenIssuerConfiguration = trustedTokenIssuerConfiguration;
            return this;
        }

        public final String getTrustedTokenIssuerType() {
            return trustedTokenIssuerType;
        }

        public final void setTrustedTokenIssuerType(String trustedTokenIssuerType) {
            this.trustedTokenIssuerType = trustedTokenIssuerType;
        }

        @Override
        public final Builder trustedTokenIssuerType(String trustedTokenIssuerType) {
            this.trustedTokenIssuerType = trustedTokenIssuerType;
            return this;
        }

        @Override
        public final Builder trustedTokenIssuerType(TrustedTokenIssuerType trustedTokenIssuerType) {
            this.trustedTokenIssuerType(trustedTokenIssuerType == null ? null : trustedTokenIssuerType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrustedTokenIssuerRequest build() {
            return new CreateTrustedTokenIssuerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
