/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteApplicationAuthenticationMethodRequest extends SsoAdminRequest implements
        ToCopyableBuilder<DeleteApplicationAuthenticationMethodRequest.Builder, DeleteApplicationAuthenticationMethodRequest> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn").getter(getter(DeleteApplicationAuthenticationMethodRequest::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final SdkField<String> AUTHENTICATION_METHOD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationMethodType")
            .getter(getter(DeleteApplicationAuthenticationMethodRequest::authenticationMethodTypeAsString))
            .setter(setter(Builder::authenticationMethodType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMethodType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            AUTHENTICATION_METHOD_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationArn;

    private final String authenticationMethodType;

    private DeleteApplicationAuthenticationMethodRequest(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.authenticationMethodType = builder.authenticationMethodType;
    }

    /**
     * <p>
     * Specifies the ARN of the application with the authentication method to delete.
     * </p>
     * 
     * @return Specifies the ARN of the application with the authentication method to delete.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * Specifies the authentication method type to delete from the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMethodType} will return {@link AuthenticationMethodType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authenticationMethodTypeAsString}.
     * </p>
     * 
     * @return Specifies the authentication method type to delete from the application.
     * @see AuthenticationMethodType
     */
    public final AuthenticationMethodType authenticationMethodType() {
        return AuthenticationMethodType.fromValue(authenticationMethodType);
    }

    /**
     * <p>
     * Specifies the authentication method type to delete from the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMethodType} will return {@link AuthenticationMethodType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authenticationMethodTypeAsString}.
     * </p>
     * 
     * @return Specifies the authentication method type to delete from the application.
     * @see AuthenticationMethodType
     */
    public final String authenticationMethodTypeAsString() {
        return authenticationMethodType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationMethodTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationAuthenticationMethodRequest)) {
            return false;
        }
        DeleteApplicationAuthenticationMethodRequest other = (DeleteApplicationAuthenticationMethodRequest) obj;
        return Objects.equals(applicationArn(), other.applicationArn())
                && Objects.equals(authenticationMethodTypeAsString(), other.authenticationMethodTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteApplicationAuthenticationMethodRequest").add("ApplicationArn", applicationArn())
                .add("AuthenticationMethodType", authenticationMethodTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "AuthenticationMethodType":
            return Optional.ofNullable(clazz.cast(authenticationMethodTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("AuthenticationMethodType", AUTHENTICATION_METHOD_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteApplicationAuthenticationMethodRequest, T> g) {
        return obj -> g.apply((DeleteApplicationAuthenticationMethodRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteApplicationAuthenticationMethodRequest> {
        /**
         * <p>
         * Specifies the ARN of the application with the authentication method to delete.
         * </p>
         * 
         * @param applicationArn
         *        Specifies the ARN of the application with the authentication method to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * Specifies the authentication method type to delete from the application.
         * </p>
         * 
         * @param authenticationMethodType
         *        Specifies the authentication method type to delete from the application.
         * @see AuthenticationMethodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationMethodType
         */
        Builder authenticationMethodType(String authenticationMethodType);

        /**
         * <p>
         * Specifies the authentication method type to delete from the application.
         * </p>
         * 
         * @param authenticationMethodType
         *        Specifies the authentication method type to delete from the application.
         * @see AuthenticationMethodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationMethodType
         */
        Builder authenticationMethodType(AuthenticationMethodType authenticationMethodType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String applicationArn;

        private String authenticationMethodType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationAuthenticationMethodRequest model) {
            super(model);
            applicationArn(model.applicationArn);
            authenticationMethodType(model.authenticationMethodType);
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getAuthenticationMethodType() {
            return authenticationMethodType;
        }

        public final void setAuthenticationMethodType(String authenticationMethodType) {
            this.authenticationMethodType = authenticationMethodType;
        }

        @Override
        public final Builder authenticationMethodType(String authenticationMethodType) {
            this.authenticationMethodType = authenticationMethodType;
            return this;
        }

        @Override
        public final Builder authenticationMethodType(AuthenticationMethodType authenticationMethodType) {
            this.authenticationMethodType(authenticationMethodType == null ? null : authenticationMethodType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationAuthenticationMethodRequest build() {
            return new DeleteApplicationAuthenticationMethodRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
