/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationAuthenticationMethodResponse extends SsoAdminResponse implements
        ToCopyableBuilder<GetApplicationAuthenticationMethodResponse.Builder, GetApplicationAuthenticationMethodResponse> {
    private static final SdkField<AuthenticationMethod> AUTHENTICATION_METHOD_FIELD = SdkField
            .<AuthenticationMethod> builder(MarshallingType.SDK_POJO).memberName("AuthenticationMethod")
            .getter(getter(GetApplicationAuthenticationMethodResponse::authenticationMethod))
            .setter(setter(Builder::authenticationMethod)).constructor(AuthenticationMethod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMethod").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_METHOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AuthenticationMethod authenticationMethod;

    private GetApplicationAuthenticationMethodResponse(BuilderImpl builder) {
        super(builder);
        this.authenticationMethod = builder.authenticationMethod;
    }

    /**
     * <p>
     * A structure that contains details about the requested authentication method.
     * </p>
     * 
     * @return A structure that contains details about the requested authentication method.
     */
    public final AuthenticationMethod authenticationMethod() {
        return authenticationMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationMethod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationAuthenticationMethodResponse)) {
            return false;
        }
        GetApplicationAuthenticationMethodResponse other = (GetApplicationAuthenticationMethodResponse) obj;
        return Objects.equals(authenticationMethod(), other.authenticationMethod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationAuthenticationMethodResponse").add("AuthenticationMethod", authenticationMethod())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationMethod":
            return Optional.ofNullable(clazz.cast(authenticationMethod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthenticationMethod", AUTHENTICATION_METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationAuthenticationMethodResponse, T> g) {
        return obj -> g.apply((GetApplicationAuthenticationMethodResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetApplicationAuthenticationMethodResponse> {
        /**
         * <p>
         * A structure that contains details about the requested authentication method.
         * </p>
         * 
         * @param authenticationMethod
         *        A structure that contains details about the requested authentication method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationMethod(AuthenticationMethod authenticationMethod);

        /**
         * <p>
         * A structure that contains details about the requested authentication method.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthenticationMethod.Builder} avoiding
         * the need to create one manually via {@link AuthenticationMethod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthenticationMethod.Builder#build()} is called immediately and
         * its result is passed to {@link #authenticationMethod(AuthenticationMethod)}.
         * 
         * @param authenticationMethod
         *        a consumer that will call methods on {@link AuthenticationMethod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationMethod(AuthenticationMethod)
         */
        default Builder authenticationMethod(Consumer<AuthenticationMethod.Builder> authenticationMethod) {
            return authenticationMethod(AuthenticationMethod.builder().applyMutation(authenticationMethod).build());
        }
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private AuthenticationMethod authenticationMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationAuthenticationMethodResponse model) {
            super(model);
            authenticationMethod(model.authenticationMethod);
        }

        public final AuthenticationMethod.Builder getAuthenticationMethod() {
            return authenticationMethod != null ? authenticationMethod.toBuilder() : null;
        }

        public final void setAuthenticationMethod(AuthenticationMethod.BuilderImpl authenticationMethod) {
            this.authenticationMethod = authenticationMethod != null ? authenticationMethod.build() : null;
        }

        @Override
        public final Builder authenticationMethod(AuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        @Override
        public GetApplicationAuthenticationMethodResponse build() {
            return new GetApplicationAuthenticationMethodResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
