/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationGrantResponse extends SsoAdminResponse implements
        ToCopyableBuilder<GetApplicationGrantResponse.Builder, GetApplicationGrantResponse> {
    private static final SdkField<Grant> GRANT_FIELD = SdkField.<Grant> builder(MarshallingType.SDK_POJO).memberName("Grant")
            .getter(getter(GetApplicationGrantResponse::grant)).setter(setter(Builder::grant)).constructor(Grant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grant").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Grant grant;

    private GetApplicationGrantResponse(BuilderImpl builder) {
        super(builder);
        this.grant = builder.grant;
    }

    /**
     * <p>
     * A structure that describes the requested grant.
     * </p>
     * 
     * @return A structure that describes the requested grant.
     */
    public final Grant grant() {
        return grant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(grant());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationGrantResponse)) {
            return false;
        }
        GetApplicationGrantResponse other = (GetApplicationGrantResponse) obj;
        return Objects.equals(grant(), other.grant());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationGrantResponse").add("Grant", grant()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Grant":
            return Optional.ofNullable(clazz.cast(grant()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Grant", GRANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationGrantResponse, T> g) {
        return obj -> g.apply((GetApplicationGrantResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetApplicationGrantResponse> {
        /**
         * <p>
         * A structure that describes the requested grant.
         * </p>
         * 
         * @param grant
         *        A structure that describes the requested grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grant(Grant grant);

        /**
         * <p>
         * A structure that describes the requested grant.
         * </p>
         * This is a convenience method that creates an instance of the {@link Grant.Builder} avoiding the need to
         * create one manually via {@link Grant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Grant.Builder#build()} is called immediately and its result is
         * passed to {@link #grant(Grant)}.
         * 
         * @param grant
         *        a consumer that will call methods on {@link Grant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grant(Grant)
         */
        default Builder grant(Consumer<Grant.Builder> grant) {
            return grant(Grant.builder().applyMutation(grant).build());
        }
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private Grant grant;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationGrantResponse model) {
            super(model);
            grant(model.grant);
        }

        public final Grant.Builder getGrant() {
            return grant != null ? grant.toBuilder() : null;
        }

        public final void setGrant(Grant.BuilderImpl grant) {
            this.grant = grant != null ? grant.build() : null;
        }

        @Override
        public final Builder grant(Grant grant) {
            this.grant = grant;
            return this;
        }

        @Override
        public GetApplicationGrantResponse build() {
            return new GetApplicationGrantResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
