/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccountAssignmentDeletionStatusResponse extends SsoAdminResponse implements
        ToCopyableBuilder<ListAccountAssignmentDeletionStatusResponse.Builder, ListAccountAssignmentDeletionStatusResponse> {
    private static final SdkField<List<AccountAssignmentOperationStatusMetadata>> ACCOUNT_ASSIGNMENTS_DELETION_STATUS_FIELD = SdkField
            .<List<AccountAssignmentOperationStatusMetadata>> builder(MarshallingType.LIST)
            .memberName("AccountAssignmentsDeletionStatus")
            .getter(getter(ListAccountAssignmentDeletionStatusResponse::accountAssignmentsDeletionStatus))
            .setter(setter(Builder::accountAssignmentsDeletionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssignmentsDeletionStatus")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountAssignmentOperationStatusMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountAssignmentOperationStatusMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAccountAssignmentDeletionStatusResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACCOUNT_ASSIGNMENTS_DELETION_STATUS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AccountAssignmentOperationStatusMetadata> accountAssignmentsDeletionStatus;

    private final String nextToken;

    private ListAccountAssignmentDeletionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.accountAssignmentsDeletionStatus = builder.accountAssignmentsDeletionStatus;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountAssignmentsDeletionStatus
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAccountAssignmentsDeletionStatus() {
        return accountAssignmentsDeletionStatus != null && !(accountAssignmentsDeletionStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status object for the account assignment deletion operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountAssignmentsDeletionStatus}
     * method.
     * </p>
     * 
     * @return The status object for the account assignment deletion operation.
     */
    public final List<AccountAssignmentOperationStatusMetadata> accountAssignmentsDeletionStatus() {
        return accountAssignmentsDeletionStatus;
    }

    /**
     * <p>
     * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make
     * subsequent calls.
     * </p>
     * 
     * @return The pagination token for the list API. Initially the value is null. Use the output of previous API calls
     *         to make subsequent calls.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAccountAssignmentsDeletionStatus() ? accountAssignmentsDeletionStatus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountAssignmentDeletionStatusResponse)) {
            return false;
        }
        ListAccountAssignmentDeletionStatusResponse other = (ListAccountAssignmentDeletionStatusResponse) obj;
        return hasAccountAssignmentsDeletionStatus() == other.hasAccountAssignmentsDeletionStatus()
                && Objects.equals(accountAssignmentsDeletionStatus(), other.accountAssignmentsDeletionStatus())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListAccountAssignmentDeletionStatusResponse")
                .add("AccountAssignmentsDeletionStatus",
                        hasAccountAssignmentsDeletionStatus() ? accountAssignmentsDeletionStatus() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountAssignmentsDeletionStatus":
            return Optional.ofNullable(clazz.cast(accountAssignmentsDeletionStatus()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountAssignmentsDeletionStatus", ACCOUNT_ASSIGNMENTS_DELETION_STATUS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccountAssignmentDeletionStatusResponse, T> g) {
        return obj -> g.apply((ListAccountAssignmentDeletionStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAccountAssignmentDeletionStatusResponse> {
        /**
         * <p>
         * The status object for the account assignment deletion operation.
         * </p>
         * 
         * @param accountAssignmentsDeletionStatus
         *        The status object for the account assignment deletion operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssignmentsDeletionStatus(
                Collection<AccountAssignmentOperationStatusMetadata> accountAssignmentsDeletionStatus);

        /**
         * <p>
         * The status object for the account assignment deletion operation.
         * </p>
         * 
         * @param accountAssignmentsDeletionStatus
         *        The status object for the account assignment deletion operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssignmentsDeletionStatus(AccountAssignmentOperationStatusMetadata... accountAssignmentsDeletionStatus);

        /**
         * <p>
         * The status object for the account assignment deletion operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatusMetadata.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatusMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatusMetadata.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #accountAssignmentsDeletionStatus(List<AccountAssignmentOperationStatusMetadata>)}.
         * 
         * @param accountAssignmentsDeletionStatus
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatusMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountAssignmentsDeletionStatus(java.util.Collection<AccountAssignmentOperationStatusMetadata>)
         */
        Builder accountAssignmentsDeletionStatus(
                Consumer<AccountAssignmentOperationStatusMetadata.Builder>... accountAssignmentsDeletionStatus);

        /**
         * <p>
         * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to
         * make subsequent calls.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the list API. Initially the value is null. Use the output of previous API
         *        calls to make subsequent calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private List<AccountAssignmentOperationStatusMetadata> accountAssignmentsDeletionStatus = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountAssignmentDeletionStatusResponse model) {
            super(model);
            accountAssignmentsDeletionStatus(model.accountAssignmentsDeletionStatus);
            nextToken(model.nextToken);
        }

        public final List<AccountAssignmentOperationStatusMetadata.Builder> getAccountAssignmentsDeletionStatus() {
            List<AccountAssignmentOperationStatusMetadata.Builder> result = AccountAssignmentOperationStatusListCopier
                    .copyToBuilder(this.accountAssignmentsDeletionStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountAssignmentsDeletionStatus(
                Collection<AccountAssignmentOperationStatusMetadata.BuilderImpl> accountAssignmentsDeletionStatus) {
            this.accountAssignmentsDeletionStatus = AccountAssignmentOperationStatusListCopier
                    .copyFromBuilder(accountAssignmentsDeletionStatus);
        }

        @Override
        public final Builder accountAssignmentsDeletionStatus(
                Collection<AccountAssignmentOperationStatusMetadata> accountAssignmentsDeletionStatus) {
            this.accountAssignmentsDeletionStatus = AccountAssignmentOperationStatusListCopier
                    .copy(accountAssignmentsDeletionStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAssignmentsDeletionStatus(
                AccountAssignmentOperationStatusMetadata... accountAssignmentsDeletionStatus) {
            accountAssignmentsDeletionStatus(Arrays.asList(accountAssignmentsDeletionStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAssignmentsDeletionStatus(
                Consumer<AccountAssignmentOperationStatusMetadata.Builder>... accountAssignmentsDeletionStatus) {
            accountAssignmentsDeletionStatus(Stream.of(accountAssignmentsDeletionStatus)
                    .map(c -> AccountAssignmentOperationStatusMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAccountAssignmentDeletionStatusResponse build() {
            return new ListAccountAssignmentDeletionStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
