/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionPermissionSetResponse extends SsoAdminResponse implements
        ToCopyableBuilder<ProvisionPermissionSetResponse.Builder, ProvisionPermissionSetResponse> {
    private static final SdkField<PermissionSetProvisioningStatus> PERMISSION_SET_PROVISIONING_STATUS_FIELD = SdkField
            .<PermissionSetProvisioningStatus> builder(MarshallingType.SDK_POJO)
            .memberName("PermissionSetProvisioningStatus")
            .getter(getter(ProvisionPermissionSetResponse::permissionSetProvisioningStatus))
            .setter(setter(Builder::permissionSetProvisioningStatus))
            .constructor(PermissionSetProvisioningStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetProvisioningStatus")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PERMISSION_SET_PROVISIONING_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final PermissionSetProvisioningStatus permissionSetProvisioningStatus;

    private ProvisionPermissionSetResponse(BuilderImpl builder) {
        super(builder);
        this.permissionSetProvisioningStatus = builder.permissionSetProvisioningStatus;
    }

    /**
     * <p>
     * The status object for the permission set provisioning operation.
     * </p>
     * 
     * @return The status object for the permission set provisioning operation.
     */
    public final PermissionSetProvisioningStatus permissionSetProvisioningStatus() {
        return permissionSetProvisioningStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(permissionSetProvisioningStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionPermissionSetResponse)) {
            return false;
        }
        ProvisionPermissionSetResponse other = (ProvisionPermissionSetResponse) obj;
        return Objects.equals(permissionSetProvisioningStatus(), other.permissionSetProvisioningStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionPermissionSetResponse")
                .add("PermissionSetProvisioningStatus", permissionSetProvisioningStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PermissionSetProvisioningStatus":
            return Optional.ofNullable(clazz.cast(permissionSetProvisioningStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PermissionSetProvisioningStatus", PERMISSION_SET_PROVISIONING_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionPermissionSetResponse, T> g) {
        return obj -> g.apply((ProvisionPermissionSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo, CopyableBuilder<Builder, ProvisionPermissionSetResponse> {
        /**
         * <p>
         * The status object for the permission set provisioning operation.
         * </p>
         * 
         * @param permissionSetProvisioningStatus
         *        The status object for the permission set provisioning operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionSetProvisioningStatus(PermissionSetProvisioningStatus permissionSetProvisioningStatus);

        /**
         * <p>
         * The status object for the permission set provisioning operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link PermissionSetProvisioningStatus.Builder}
         * avoiding the need to create one manually via {@link PermissionSetProvisioningStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PermissionSetProvisioningStatus.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #permissionSetProvisioningStatus(PermissionSetProvisioningStatus)}.
         * 
         * @param permissionSetProvisioningStatus
         *        a consumer that will call methods on {@link PermissionSetProvisioningStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionSetProvisioningStatus(PermissionSetProvisioningStatus)
         */
        default Builder permissionSetProvisioningStatus(
                Consumer<PermissionSetProvisioningStatus.Builder> permissionSetProvisioningStatus) {
            return permissionSetProvisioningStatus(PermissionSetProvisioningStatus.builder()
                    .applyMutation(permissionSetProvisioningStatus).build());
        }
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private PermissionSetProvisioningStatus permissionSetProvisioningStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionPermissionSetResponse model) {
            super(model);
            permissionSetProvisioningStatus(model.permissionSetProvisioningStatus);
        }

        public final PermissionSetProvisioningStatus.Builder getPermissionSetProvisioningStatus() {
            return permissionSetProvisioningStatus != null ? permissionSetProvisioningStatus.toBuilder() : null;
        }

        public final void setPermissionSetProvisioningStatus(
                PermissionSetProvisioningStatus.BuilderImpl permissionSetProvisioningStatus) {
            this.permissionSetProvisioningStatus = permissionSetProvisioningStatus != null ? permissionSetProvisioningStatus
                    .build() : null;
        }

        @Override
        public final Builder permissionSetProvisioningStatus(PermissionSetProvisioningStatus permissionSetProvisioningStatus) {
            this.permissionSetProvisioningStatus = permissionSetProvisioningStatus;
            return this;
        }

        @Override
        public ProvisionPermissionSetResponse build() {
            return new ProvisionPermissionSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
