/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.services.ssoadmin.model.TrustedTokenIssuerListCopier;
import software.amazon.awssdk.services.ssoadmin.model.TrustedTokenIssuerMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrustedTokenIssuersResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, ListTrustedTokenIssuersResponse> {
    private static final SdkField<List<TrustedTokenIssuerMetadata>> TRUSTED_TOKEN_ISSUERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrustedTokenIssuers").getter(ListTrustedTokenIssuersResponse.getter(ListTrustedTokenIssuersResponse::trustedTokenIssuers)).setter(ListTrustedTokenIssuersResponse.setter(Builder::trustedTokenIssuers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrustedTokenIssuerMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTrustedTokenIssuersResponse.getter(ListTrustedTokenIssuersResponse::nextToken)).setter(ListTrustedTokenIssuersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUSTED_TOKEN_ISSUERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTrustedTokenIssuersResponse.memberNameToFieldInitializer();
    private final List<TrustedTokenIssuerMetadata> trustedTokenIssuers;
    private final String nextToken;

    private ListTrustedTokenIssuersResponse(BuilderImpl builder) {
        super(builder);
        this.trustedTokenIssuers = builder.trustedTokenIssuers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTrustedTokenIssuers() {
        return this.trustedTokenIssuers != null && !(this.trustedTokenIssuers instanceof SdkAutoConstructList);
    }

    public final List<TrustedTokenIssuerMetadata> trustedTokenIssuers() {
        return this.trustedTokenIssuers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrustedTokenIssuers() ? this.trustedTokenIssuers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrustedTokenIssuersResponse)) {
            return false;
        }
        ListTrustedTokenIssuersResponse other = (ListTrustedTokenIssuersResponse)((Object)obj);
        return this.hasTrustedTokenIssuers() == other.hasTrustedTokenIssuers() && Objects.equals(this.trustedTokenIssuers(), other.trustedTokenIssuers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrustedTokenIssuersResponse").add("TrustedTokenIssuers", this.hasTrustedTokenIssuers() ? this.trustedTokenIssuers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustedTokenIssuers": {
                return Optional.ofNullable(clazz.cast(this.trustedTokenIssuers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrustedTokenIssuers", TRUSTED_TOKEN_ISSUERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrustedTokenIssuersResponse, T> g) {
        return obj -> g.apply((ListTrustedTokenIssuersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private List<TrustedTokenIssuerMetadata> trustedTokenIssuers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrustedTokenIssuersResponse model) {
            super(model);
            this.trustedTokenIssuers(model.trustedTokenIssuers);
            this.nextToken(model.nextToken);
        }

        public final List<TrustedTokenIssuerMetadata.Builder> getTrustedTokenIssuers() {
            List<TrustedTokenIssuerMetadata.Builder> result = TrustedTokenIssuerListCopier.copyToBuilder(this.trustedTokenIssuers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrustedTokenIssuers(Collection<TrustedTokenIssuerMetadata.BuilderImpl> trustedTokenIssuers) {
            this.trustedTokenIssuers = TrustedTokenIssuerListCopier.copyFromBuilder(trustedTokenIssuers);
        }

        @Override
        public final Builder trustedTokenIssuers(Collection<TrustedTokenIssuerMetadata> trustedTokenIssuers) {
            this.trustedTokenIssuers = TrustedTokenIssuerListCopier.copy(trustedTokenIssuers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustedTokenIssuers(TrustedTokenIssuerMetadata ... trustedTokenIssuers) {
            this.trustedTokenIssuers(Arrays.asList(trustedTokenIssuers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustedTokenIssuers(Consumer<TrustedTokenIssuerMetadata.Builder> ... trustedTokenIssuers) {
            this.trustedTokenIssuers(Stream.of(trustedTokenIssuers).map(c -> (TrustedTokenIssuerMetadata)((TrustedTokenIssuerMetadata.Builder)TrustedTokenIssuerMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTrustedTokenIssuersResponse build() {
            return new ListTrustedTokenIssuersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrustedTokenIssuersResponse> {
        public Builder trustedTokenIssuers(Collection<TrustedTokenIssuerMetadata> var1);

        public Builder trustedTokenIssuers(TrustedTokenIssuerMetadata ... var1);

        public Builder trustedTokenIssuers(Consumer<TrustedTokenIssuerMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

