/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrustedTokenIssuerResponse extends SsoAdminResponse implements
        ToCopyableBuilder<DescribeTrustedTokenIssuerResponse.Builder, DescribeTrustedTokenIssuerResponse> {
    private static final SdkField<String> TRUSTED_TOKEN_ISSUER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustedTokenIssuerArn").getter(getter(DescribeTrustedTokenIssuerResponse::trustedTokenIssuerArn))
            .setter(setter(Builder::trustedTokenIssuerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeTrustedTokenIssuerResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TRUSTED_TOKEN_ISSUER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustedTokenIssuerType")
            .getter(getter(DescribeTrustedTokenIssuerResponse::trustedTokenIssuerTypeAsString))
            .setter(setter(Builder::trustedTokenIssuerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerType").build())
            .build();

    private static final SdkField<TrustedTokenIssuerConfiguration> TRUSTED_TOKEN_ISSUER_CONFIGURATION_FIELD = SdkField
            .<TrustedTokenIssuerConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TrustedTokenIssuerConfiguration")
            .getter(getter(DescribeTrustedTokenIssuerResponse::trustedTokenIssuerConfiguration))
            .setter(setter(Builder::trustedTokenIssuerConfiguration))
            .constructor(TrustedTokenIssuerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRUSTED_TOKEN_ISSUER_ARN_FIELD, NAME_FIELD, TRUSTED_TOKEN_ISSUER_TYPE_FIELD,
                    TRUSTED_TOKEN_ISSUER_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trustedTokenIssuerArn;

    private final String name;

    private final String trustedTokenIssuerType;

    private final TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration;

    private DescribeTrustedTokenIssuerResponse(BuilderImpl builder) {
        super(builder);
        this.trustedTokenIssuerArn = builder.trustedTokenIssuerArn;
        this.name = builder.name;
        this.trustedTokenIssuerType = builder.trustedTokenIssuerType;
        this.trustedTokenIssuerConfiguration = builder.trustedTokenIssuerConfiguration;
    }

    /**
     * <p>
     * The ARN of the trusted token issuer configuration.
     * </p>
     * 
     * @return The ARN of the trusted token issuer configuration.
     */
    public final String trustedTokenIssuerArn() {
        return trustedTokenIssuerArn;
    }

    /**
     * <p>
     * The name of the trusted token issuer configuration.
     * </p>
     * 
     * @return The name of the trusted token issuer configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the trusted token issuer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trustedTokenIssuerType} will return {@link TrustedTokenIssuerType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trustedTokenIssuerTypeAsString}.
     * </p>
     * 
     * @return The type of the trusted token issuer.
     * @see TrustedTokenIssuerType
     */
    public final TrustedTokenIssuerType trustedTokenIssuerType() {
        return TrustedTokenIssuerType.fromValue(trustedTokenIssuerType);
    }

    /**
     * <p>
     * The type of the trusted token issuer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trustedTokenIssuerType} will return {@link TrustedTokenIssuerType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trustedTokenIssuerTypeAsString}.
     * </p>
     * 
     * @return The type of the trusted token issuer.
     * @see TrustedTokenIssuerType
     */
    public final String trustedTokenIssuerTypeAsString() {
        return trustedTokenIssuerType;
    }

    /**
     * <p>
     * A structure the describes the settings that apply of this trusted token issuer.
     * </p>
     * 
     * @return A structure the describes the settings that apply of this trusted token issuer.
     */
    public final TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration() {
        return trustedTokenIssuerConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trustedTokenIssuerArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(trustedTokenIssuerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trustedTokenIssuerConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedTokenIssuerResponse)) {
            return false;
        }
        DescribeTrustedTokenIssuerResponse other = (DescribeTrustedTokenIssuerResponse) obj;
        return Objects.equals(trustedTokenIssuerArn(), other.trustedTokenIssuerArn()) && Objects.equals(name(), other.name())
                && Objects.equals(trustedTokenIssuerTypeAsString(), other.trustedTokenIssuerTypeAsString())
                && Objects.equals(trustedTokenIssuerConfiguration(), other.trustedTokenIssuerConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTrustedTokenIssuerResponse").add("TrustedTokenIssuerArn", trustedTokenIssuerArn())
                .add("Name", name()).add("TrustedTokenIssuerType", trustedTokenIssuerTypeAsString())
                .add("TrustedTokenIssuerConfiguration", trustedTokenIssuerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustedTokenIssuerArn":
            return Optional.ofNullable(clazz.cast(trustedTokenIssuerArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "TrustedTokenIssuerType":
            return Optional.ofNullable(clazz.cast(trustedTokenIssuerTypeAsString()));
        case "TrustedTokenIssuerConfiguration":
            return Optional.ofNullable(clazz.cast(trustedTokenIssuerConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrustedTokenIssuerArn", TRUSTED_TOKEN_ISSUER_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("TrustedTokenIssuerType", TRUSTED_TOKEN_ISSUER_TYPE_FIELD);
        map.put("TrustedTokenIssuerConfiguration", TRUSTED_TOKEN_ISSUER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustedTokenIssuerResponse, T> g) {
        return obj -> g.apply((DescribeTrustedTokenIssuerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTrustedTokenIssuerResponse> {
        /**
         * <p>
         * The ARN of the trusted token issuer configuration.
         * </p>
         * 
         * @param trustedTokenIssuerArn
         *        The ARN of the trusted token issuer configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedTokenIssuerArn(String trustedTokenIssuerArn);

        /**
         * <p>
         * The name of the trusted token issuer configuration.
         * </p>
         * 
         * @param name
         *        The name of the trusted token issuer configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the trusted token issuer.
         * </p>
         * 
         * @param trustedTokenIssuerType
         *        The type of the trusted token issuer.
         * @see TrustedTokenIssuerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustedTokenIssuerType
         */
        Builder trustedTokenIssuerType(String trustedTokenIssuerType);

        /**
         * <p>
         * The type of the trusted token issuer.
         * </p>
         * 
         * @param trustedTokenIssuerType
         *        The type of the trusted token issuer.
         * @see TrustedTokenIssuerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustedTokenIssuerType
         */
        Builder trustedTokenIssuerType(TrustedTokenIssuerType trustedTokenIssuerType);

        /**
         * <p>
         * A structure the describes the settings that apply of this trusted token issuer.
         * </p>
         * 
         * @param trustedTokenIssuerConfiguration
         *        A structure the describes the settings that apply of this trusted token issuer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedTokenIssuerConfiguration(TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration);

        /**
         * <p>
         * A structure the describes the settings that apply of this trusted token issuer.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrustedTokenIssuerConfiguration.Builder}
         * avoiding the need to create one manually via {@link TrustedTokenIssuerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrustedTokenIssuerConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #trustedTokenIssuerConfiguration(TrustedTokenIssuerConfiguration)}.
         * 
         * @param trustedTokenIssuerConfiguration
         *        a consumer that will call methods on {@link TrustedTokenIssuerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustedTokenIssuerConfiguration(TrustedTokenIssuerConfiguration)
         */
        default Builder trustedTokenIssuerConfiguration(
                Consumer<TrustedTokenIssuerConfiguration.Builder> trustedTokenIssuerConfiguration) {
            return trustedTokenIssuerConfiguration(TrustedTokenIssuerConfiguration.builder()
                    .applyMutation(trustedTokenIssuerConfiguration).build());
        }
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private String trustedTokenIssuerArn;

        private String name;

        private String trustedTokenIssuerType;

        private TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedTokenIssuerResponse model) {
            super(model);
            trustedTokenIssuerArn(model.trustedTokenIssuerArn);
            name(model.name);
            trustedTokenIssuerType(model.trustedTokenIssuerType);
            trustedTokenIssuerConfiguration(model.trustedTokenIssuerConfiguration);
        }

        public final String getTrustedTokenIssuerArn() {
            return trustedTokenIssuerArn;
        }

        public final void setTrustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
        }

        @Override
        public final Builder trustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTrustedTokenIssuerType() {
            return trustedTokenIssuerType;
        }

        public final void setTrustedTokenIssuerType(String trustedTokenIssuerType) {
            this.trustedTokenIssuerType = trustedTokenIssuerType;
        }

        @Override
        public final Builder trustedTokenIssuerType(String trustedTokenIssuerType) {
            this.trustedTokenIssuerType = trustedTokenIssuerType;
            return this;
        }

        @Override
        public final Builder trustedTokenIssuerType(TrustedTokenIssuerType trustedTokenIssuerType) {
            this.trustedTokenIssuerType(trustedTokenIssuerType == null ? null : trustedTokenIssuerType.toString());
            return this;
        }

        public final TrustedTokenIssuerConfiguration.Builder getTrustedTokenIssuerConfiguration() {
            return trustedTokenIssuerConfiguration != null ? trustedTokenIssuerConfiguration.toBuilder() : null;
        }

        public final void setTrustedTokenIssuerConfiguration(
                TrustedTokenIssuerConfiguration.BuilderImpl trustedTokenIssuerConfiguration) {
            this.trustedTokenIssuerConfiguration = trustedTokenIssuerConfiguration != null ? trustedTokenIssuerConfiguration
                    .build() : null;
        }

        @Override
        public final Builder trustedTokenIssuerConfiguration(TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration) {
            this.trustedTokenIssuerConfiguration = trustedTokenIssuerConfiguration;
            return this;
        }

        @Override
        public DescribeTrustedTokenIssuerResponse build() {
            return new DescribeTrustedTokenIssuerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
