/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationAccessScopeResponse extends SsoAdminResponse implements
        ToCopyableBuilder<GetApplicationAccessScopeResponse.Builder, GetApplicationAccessScopeResponse> {
    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(GetApplicationAccessScopeResponse::scope)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<List<String>> AUTHORIZED_TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AuthorizedTargets")
            .getter(getter(GetApplicationAccessScopeResponse::authorizedTargets))
            .setter(setter(Builder::authorizedTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD,
            AUTHORIZED_TARGETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scope;

    private final List<String> authorizedTargets;

    private GetApplicationAccessScopeResponse(BuilderImpl builder) {
        super(builder);
        this.scope = builder.scope;
        this.authorizedTargets = builder.authorizedTargets;
    }

    /**
     * <p>
     * The name of the access scope that can be used with the authorized targets.
     * </p>
     * 
     * @return The name of the access scope that can be used with the authorized targets.
     */
    public final String scope() {
        return scope;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedTargets property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthorizedTargets() {
        return authorizedTargets != null && !(authorizedTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of authorized targets associated with this access scope.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedTargets} method.
     * </p>
     * 
     * @return An array of authorized targets associated with this access scope.
     */
    public final List<String> authorizedTargets() {
        return authorizedTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedTargets() ? authorizedTargets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationAccessScopeResponse)) {
            return false;
        }
        GetApplicationAccessScopeResponse other = (GetApplicationAccessScopeResponse) obj;
        return Objects.equals(scope(), other.scope()) && hasAuthorizedTargets() == other.hasAuthorizedTargets()
                && Objects.equals(authorizedTargets(), other.authorizedTargets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationAccessScopeResponse").add("Scope", scope())
                .add("AuthorizedTargets", hasAuthorizedTargets() ? authorizedTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "AuthorizedTargets":
            return Optional.ofNullable(clazz.cast(authorizedTargets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Scope", SCOPE_FIELD);
        map.put("AuthorizedTargets", AUTHORIZED_TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationAccessScopeResponse, T> g) {
        return obj -> g.apply((GetApplicationAccessScopeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetApplicationAccessScopeResponse> {
        /**
         * <p>
         * The name of the access scope that can be used with the authorized targets.
         * </p>
         * 
         * @param scope
         *        The name of the access scope that can be used with the authorized targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(String scope);

        /**
         * <p>
         * An array of authorized targets associated with this access scope.
         * </p>
         * 
         * @param authorizedTargets
         *        An array of authorized targets associated with this access scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedTargets(Collection<String> authorizedTargets);

        /**
         * <p>
         * An array of authorized targets associated with this access scope.
         * </p>
         * 
         * @param authorizedTargets
         *        An array of authorized targets associated with this access scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedTargets(String... authorizedTargets);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private String scope;

        private List<String> authorizedTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationAccessScopeResponse model) {
            super(model);
            scope(model.scope);
            authorizedTargets(model.authorizedTargets);
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final Collection<String> getAuthorizedTargets() {
            if (authorizedTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return authorizedTargets;
        }

        public final void setAuthorizedTargets(Collection<String> authorizedTargets) {
            this.authorizedTargets = ScopeTargetsCopier.copy(authorizedTargets);
        }

        @Override
        public final Builder authorizedTargets(Collection<String> authorizedTargets) {
            this.authorizedTargets = ScopeTargetsCopier.copy(authorizedTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTargets(String... authorizedTargets) {
            authorizedTargets(Arrays.asList(authorizedTargets));
            return this;
        }

        @Override
        public GetApplicationAccessScopeResponse build() {
            return new GetApplicationAccessScopeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
