/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccountAssignmentsForPrincipalRequest extends SsoAdminRequest implements
        ToCopyableBuilder<ListAccountAssignmentsForPrincipalRequest.Builder, ListAccountAssignmentsForPrincipalRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(ListAccountAssignmentsForPrincipalRequest::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalId").getter(getter(ListAccountAssignmentsForPrincipalRequest::principalId))
            .setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()).build();

    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalType").getter(getter(ListAccountAssignmentsForPrincipalRequest::principalTypeAsString))
            .setter(setter(Builder::principalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()).build();

    private static final SdkField<ListAccountAssignmentsFilter> FILTER_FIELD = SdkField
            .<ListAccountAssignmentsFilter> builder(MarshallingType.SDK_POJO).memberName("Filter")
            .getter(getter(ListAccountAssignmentsForPrincipalRequest::filter)).setter(setter(Builder::filter))
            .constructor(ListAccountAssignmentsFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAccountAssignmentsForPrincipalRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListAccountAssignmentsForPrincipalRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD,
            PRINCIPAL_ID_FIELD, PRINCIPAL_TYPE_FIELD, FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceArn;

    private final String principalId;

    private final String principalType;

    private final ListAccountAssignmentsFilter filter;

    private final String nextToken;

    private final Integer maxResults;

    private ListAccountAssignmentsForPrincipalRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.principalId = builder.principalId;
        this.principalType = builder.principalType;
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Specifies the ARN of the instance of IAM Identity Center that contains the principal.
     * </p>
     * 
     * @return Specifies the ARN of the instance of IAM Identity Center that contains the principal.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * Specifies the principal for which you want to retrieve the list of account assignments.
     * </p>
     * 
     * @return Specifies the principal for which you want to retrieve the list of account assignments.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * Specifies the type of the principal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the principal.
     * @see PrincipalType
     */
    public final PrincipalType principalType() {
        return PrincipalType.fromValue(principalType);
    }

    /**
     * <p>
     * Specifies the type of the principal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the principal.
     * @see PrincipalType
     */
    public final String principalTypeAsString() {
        return principalType;
    }

    /**
     * <p>
     * Specifies an Amazon Web Services account ID number. Results are filtered to only those that match this ID number.
     * </p>
     * 
     * @return Specifies an Amazon Web Services account ID number. Results are filtered to only those that match this ID
     *         number.
     */
    public final ListAccountAssignmentsFilter filter() {
        return filter;
    }

    /**
     * <p>
     * Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code>
     * response in the previous request. If you did, it indicates that more output is available. Set this parameter to
     * the value provided by the previous call's <code>NextToken</code> response to request the next page of results.
     * </p>
     * 
     * @return Specifies that you want to receive the next page of results. Valid only if you received a
     *         <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
     *         available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
     *         response to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the total number of results that you want included in each response. If additional items exist beyond
     * the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include
     * the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the
     * next set of results. Note that the service might return fewer results than the maximum even when there are more
     * results available. You should check <code>NextToken</code> after every operation to ensure that you receive all
     * of the results.
     * </p>
     * 
     * @return Specifies the total number of results that you want included in each response. If additional items exist
     *         beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not
     *         null). Include the specified value as the <code>NextToken</code> request parameter in the next call to
     *         the operation to get the next set of results. Note that the service might return fewer results than the
     *         maximum even when there are more results available. You should check <code>NextToken</code> after every
     *         operation to ensure that you receive all of the results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(principalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountAssignmentsForPrincipalRequest)) {
            return false;
        }
        ListAccountAssignmentsForPrincipalRequest other = (ListAccountAssignmentsForPrincipalRequest) obj;
        return Objects.equals(instanceArn(), other.instanceArn()) && Objects.equals(principalId(), other.principalId())
                && Objects.equals(principalTypeAsString(), other.principalTypeAsString())
                && Objects.equals(filter(), other.filter()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccountAssignmentsForPrincipalRequest").add("InstanceArn", instanceArn())
                .add("PrincipalId", principalId()).add("PrincipalType", principalTypeAsString()).add("Filter", filter())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "PrincipalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "PrincipalType":
            return Optional.ofNullable(clazz.cast(principalTypeAsString()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceArn", INSTANCE_ARN_FIELD);
        map.put("PrincipalId", PRINCIPAL_ID_FIELD);
        map.put("PrincipalType", PRINCIPAL_TYPE_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccountAssignmentsForPrincipalRequest, T> g) {
        return obj -> g.apply((ListAccountAssignmentsForPrincipalRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsoAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAccountAssignmentsForPrincipalRequest> {
        /**
         * <p>
         * Specifies the ARN of the instance of IAM Identity Center that contains the principal.
         * </p>
         * 
         * @param instanceArn
         *        Specifies the ARN of the instance of IAM Identity Center that contains the principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * Specifies the principal for which you want to retrieve the list of account assignments.
         * </p>
         * 
         * @param principalId
         *        Specifies the principal for which you want to retrieve the list of account assignments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * Specifies the type of the principal.
         * </p>
         * 
         * @param principalType
         *        Specifies the type of the principal.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(String principalType);

        /**
         * <p>
         * Specifies the type of the principal.
         * </p>
         * 
         * @param principalType
         *        Specifies the type of the principal.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(PrincipalType principalType);

        /**
         * <p>
         * Specifies an Amazon Web Services account ID number. Results are filtered to only those that match this ID
         * number.
         * </p>
         * 
         * @param filter
         *        Specifies an Amazon Web Services account ID number. Results are filtered to only those that match this
         *        ID number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(ListAccountAssignmentsFilter filter);

        /**
         * <p>
         * Specifies an Amazon Web Services account ID number. Results are filtered to only those that match this ID
         * number.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListAccountAssignmentsFilter.Builder}
         * avoiding the need to create one manually via {@link ListAccountAssignmentsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListAccountAssignmentsFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filter(ListAccountAssignmentsFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link ListAccountAssignmentsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(ListAccountAssignmentsFilter)
         */
        default Builder filter(Consumer<ListAccountAssignmentsFilter.Builder> filter) {
            return filter(ListAccountAssignmentsFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * Specifies that you want to receive the next page of results. Valid only if you received a
         * <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         * available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to
         * request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specifies that you want to receive the next page of results. Valid only if you received a
         *        <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         *        available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
         *        response to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the total number of results that you want included in each response. If additional items exist
         * beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not
         * null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the
         * operation to get the next set of results. Note that the service might return fewer results than the maximum
         * even when there are more results available. You should check <code>NextToken</code> after every operation to
         * ensure that you receive all of the results.
         * </p>
         * 
         * @param maxResults
         *        Specifies the total number of results that you want included in each response. If additional items
         *        exist beyond the number you specify, the <code>NextToken</code> response element is returned with a
         *        value (not null). Include the specified value as the <code>NextToken</code> request parameter in the
         *        next call to the operation to get the next set of results. Note that the service might return fewer
         *        results than the maximum even when there are more results available. You should check
         *        <code>NextToken</code> after every operation to ensure that you receive all of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String instanceArn;

        private String principalId;

        private String principalType;

        private ListAccountAssignmentsFilter filter;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountAssignmentsForPrincipalRequest model) {
            super(model);
            instanceArn(model.instanceArn);
            principalId(model.principalId);
            principalType(model.principalType);
            filter(model.filter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getPrincipalType() {
            return principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        public final ListAccountAssignmentsFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(ListAccountAssignmentsFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(ListAccountAssignmentsFilter filter) {
            this.filter = filter;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccountAssignmentsForPrincipalRequest build() {
            return new ListAccountAssignmentsForPrincipalRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
