/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutApplicationSessionConfigurationRequest extends SsoAdminRequest implements
        ToCopyableBuilder<PutApplicationSessionConfigurationRequest.Builder, PutApplicationSessionConfigurationRequest> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn").getter(getter(PutApplicationSessionConfigurationRequest::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final SdkField<String> USER_BACKGROUND_SESSION_APPLICATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UserBackgroundSessionApplicationStatus")
            .getter(getter(PutApplicationSessionConfigurationRequest::userBackgroundSessionApplicationStatusAsString))
            .setter(setter(Builder::userBackgroundSessionApplicationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("UserBackgroundSessionApplicationStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            USER_BACKGROUND_SESSION_APPLICATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationArn;

    private final String userBackgroundSessionApplicationStatus;

    private PutApplicationSessionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.userBackgroundSessionApplicationStatus = builder.userBackgroundSessionApplicationStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application for which to update the session configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application for which to update the session configuration.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The status of user background sessions for the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userBackgroundSessionApplicationStatus} will return
     * {@link UserBackgroundSessionApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #userBackgroundSessionApplicationStatusAsString}.
     * </p>
     * 
     * @return The status of user background sessions for the application.
     * @see UserBackgroundSessionApplicationStatus
     */
    public final UserBackgroundSessionApplicationStatus userBackgroundSessionApplicationStatus() {
        return UserBackgroundSessionApplicationStatus.fromValue(userBackgroundSessionApplicationStatus);
    }

    /**
     * <p>
     * The status of user background sessions for the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userBackgroundSessionApplicationStatus} will return
     * {@link UserBackgroundSessionApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #userBackgroundSessionApplicationStatusAsString}.
     * </p>
     * 
     * @return The status of user background sessions for the application.
     * @see UserBackgroundSessionApplicationStatus
     */
    public final String userBackgroundSessionApplicationStatusAsString() {
        return userBackgroundSessionApplicationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(userBackgroundSessionApplicationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutApplicationSessionConfigurationRequest)) {
            return false;
        }
        PutApplicationSessionConfigurationRequest other = (PutApplicationSessionConfigurationRequest) obj;
        return Objects.equals(applicationArn(), other.applicationArn())
                && Objects.equals(userBackgroundSessionApplicationStatusAsString(),
                        other.userBackgroundSessionApplicationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutApplicationSessionConfigurationRequest").add("ApplicationArn", applicationArn())
                .add("UserBackgroundSessionApplicationStatus", userBackgroundSessionApplicationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "UserBackgroundSessionApplicationStatus":
            return Optional.ofNullable(clazz.cast(userBackgroundSessionApplicationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("UserBackgroundSessionApplicationStatus", USER_BACKGROUND_SESSION_APPLICATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutApplicationSessionConfigurationRequest, T> g) {
        return obj -> g.apply((PutApplicationSessionConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsoAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutApplicationSessionConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application for which to update the session configuration.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) of the application for which to update the session configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The status of user background sessions for the application.
         * </p>
         * 
         * @param userBackgroundSessionApplicationStatus
         *        The status of user background sessions for the application.
         * @see UserBackgroundSessionApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserBackgroundSessionApplicationStatus
         */
        Builder userBackgroundSessionApplicationStatus(String userBackgroundSessionApplicationStatus);

        /**
         * <p>
         * The status of user background sessions for the application.
         * </p>
         * 
         * @param userBackgroundSessionApplicationStatus
         *        The status of user background sessions for the application.
         * @see UserBackgroundSessionApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserBackgroundSessionApplicationStatus
         */
        Builder userBackgroundSessionApplicationStatus(
                UserBackgroundSessionApplicationStatus userBackgroundSessionApplicationStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String applicationArn;

        private String userBackgroundSessionApplicationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PutApplicationSessionConfigurationRequest model) {
            super(model);
            applicationArn(model.applicationArn);
            userBackgroundSessionApplicationStatus(model.userBackgroundSessionApplicationStatus);
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getUserBackgroundSessionApplicationStatus() {
            return userBackgroundSessionApplicationStatus;
        }

        public final void setUserBackgroundSessionApplicationStatus(String userBackgroundSessionApplicationStatus) {
            this.userBackgroundSessionApplicationStatus = userBackgroundSessionApplicationStatus;
        }

        @Override
        public final Builder userBackgroundSessionApplicationStatus(String userBackgroundSessionApplicationStatus) {
            this.userBackgroundSessionApplicationStatus = userBackgroundSessionApplicationStatus;
            return this;
        }

        @Override
        public final Builder userBackgroundSessionApplicationStatus(
                UserBackgroundSessionApplicationStatus userBackgroundSessionApplicationStatus) {
            this.userBackgroundSessionApplicationStatus(userBackgroundSessionApplicationStatus == null ? null
                    : userBackgroundSessionApplicationStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutApplicationSessionConfigurationRequest build() {
            return new PutApplicationSessionConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
