/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterClientRequest extends SsoOidcRequest implements
        ToCopyableBuilder<RegisterClientRequest.Builder, RegisterClientRequest> {
    private static final SdkField<String> CLIENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterClientRequest::clientName)).setter(setter(Builder::clientName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientName").build()).build();

    private static final SdkField<String> CLIENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterClientRequest::clientType)).setter(setter(Builder::clientType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientType").build()).build();

    private static final SdkField<List<String>> SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RegisterClientRequest::scopes))
            .setter(setter(Builder::scopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_NAME_FIELD,
            CLIENT_TYPE_FIELD, SCOPES_FIELD));

    private final String clientName;

    private final String clientType;

    private final List<String> scopes;

    private RegisterClientRequest(BuilderImpl builder) {
        super(builder);
        this.clientName = builder.clientName;
        this.clientType = builder.clientType;
        this.scopes = builder.scopes;
    }

    /**
     * <p>
     * The friendly name of the client.
     * </p>
     * 
     * @return The friendly name of the client.
     */
    public String clientName() {
        return clientName;
    }

    /**
     * <p>
     * The type of client. The service supports only <code>public</code> as a client type. Anything other than public
     * will be rejected by the service.
     * </p>
     * 
     * @return The type of client. The service supports only <code>public</code> as a client type. Anything other than
     *         public will be rejected by the service.
     */
    public String clientType() {
        return clientType;
    }

    /**
     * Returns true if the Scopes property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasScopes() {
        return scopes != null && !(scopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of scopes that are defined by the client. Upon authorization, this list is used to restrict permissions
     * when granting an access token.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasScopes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of scopes that are defined by the client. Upon authorization, this list is used to restrict
     *         permissions when granting an access token.
     */
    public List<String> scopes() {
        return scopes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientName());
        hashCode = 31 * hashCode + Objects.hashCode(clientType());
        hashCode = 31 * hashCode + Objects.hashCode(scopes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterClientRequest)) {
            return false;
        }
        RegisterClientRequest other = (RegisterClientRequest) obj;
        return Objects.equals(clientName(), other.clientName()) && Objects.equals(clientType(), other.clientType())
                && Objects.equals(scopes(), other.scopes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RegisterClientRequest").add("ClientName", clientName()).add("ClientType", clientType())
                .add("Scopes", scopes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientName":
            return Optional.ofNullable(clazz.cast(clientName()));
        case "clientType":
            return Optional.ofNullable(clazz.cast(clientType()));
        case "scopes":
            return Optional.ofNullable(clazz.cast(scopes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterClientRequest, T> g) {
        return obj -> g.apply((RegisterClientRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoOidcRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterClientRequest> {
        /**
         * <p>
         * The friendly name of the client.
         * </p>
         * 
         * @param clientName
         *        The friendly name of the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientName(String clientName);

        /**
         * <p>
         * The type of client. The service supports only <code>public</code> as a client type. Anything other than
         * public will be rejected by the service.
         * </p>
         * 
         * @param clientType
         *        The type of client. The service supports only <code>public</code> as a client type. Anything other
         *        than public will be rejected by the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientType(String clientType);

        /**
         * <p>
         * The list of scopes that are defined by the client. Upon authorization, this list is used to restrict
         * permissions when granting an access token.
         * </p>
         * 
         * @param scopes
         *        The list of scopes that are defined by the client. Upon authorization, this list is used to restrict
         *        permissions when granting an access token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(Collection<String> scopes);

        /**
         * <p>
         * The list of scopes that are defined by the client. Upon authorization, this list is used to restrict
         * permissions when granting an access token.
         * </p>
         * 
         * @param scopes
         *        The list of scopes that are defined by the client. Upon authorization, this list is used to restrict
         *        permissions when granting an access token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(String... scopes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoOidcRequest.BuilderImpl implements Builder {
        private String clientName;

        private String clientType;

        private List<String> scopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterClientRequest model) {
            super(model);
            clientName(model.clientName);
            clientType(model.clientType);
            scopes(model.scopes);
        }

        public final String getClientName() {
            return clientName;
        }

        @Override
        public final Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public final void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public final String getClientType() {
            return clientType;
        }

        @Override
        public final Builder clientType(String clientType) {
            this.clientType = clientType;
            return this;
        }

        public final void setClientType(String clientType) {
            this.clientType = clientType;
        }

        public final Collection<String> getScopes() {
            return scopes;
        }

        @Override
        public final Builder scopes(Collection<String> scopes) {
            this.scopes = ScopesCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(String... scopes) {
            scopes(Arrays.asList(scopes));
            return this;
        }

        public final void setScopes(Collection<String> scopes) {
            this.scopes = ScopesCopier.copy(scopes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterClientRequest build() {
            return new RegisterClientRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
