/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterClientResponse extends SsoOidcResponse implements
        ToCopyableBuilder<RegisterClientResponse.Builder, RegisterClientResponse> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientId").getter(getter(RegisterClientResponse::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()).build();

    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientSecret").getter(getter(RegisterClientResponse::clientSecret))
            .setter(setter(Builder::clientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecret").build()).build();

    private static final SdkField<Long> CLIENT_ID_ISSUED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("clientIdIssuedAt").getter(getter(RegisterClientResponse::clientIdIssuedAt))
            .setter(setter(Builder::clientIdIssuedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientIdIssuedAt").build()).build();

    private static final SdkField<Long> CLIENT_SECRET_EXPIRES_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("clientSecretExpiresAt").getter(getter(RegisterClientResponse::clientSecretExpiresAt))
            .setter(setter(Builder::clientSecretExpiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecretExpiresAt").build())
            .build();

    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizationEndpoint").getter(getter(RegisterClientResponse::authorizationEndpoint))
            .setter(setter(Builder::authorizationEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationEndpoint").build())
            .build();

    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenEndpoint").getter(getter(RegisterClientResponse::tokenEndpoint))
            .setter(setter(Builder::tokenEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD,
            CLIENT_SECRET_FIELD, CLIENT_ID_ISSUED_AT_FIELD, CLIENT_SECRET_EXPIRES_AT_FIELD, AUTHORIZATION_ENDPOINT_FIELD,
            TOKEN_ENDPOINT_FIELD));

    private final String clientId;

    private final String clientSecret;

    private final Long clientIdIssuedAt;

    private final Long clientSecretExpiresAt;

    private final String authorizationEndpoint;

    private final String tokenEndpoint;

    private RegisterClientResponse(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.clientIdIssuedAt = builder.clientIdIssuedAt;
        this.clientSecretExpiresAt = builder.clientSecretExpiresAt;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
    }

    /**
     * <p>
     * The unique identifier string for each client. This client uses this identifier to get authenticated by the
     * service in subsequent calls.
     * </p>
     * 
     * @return The unique identifier string for each client. This client uses this identifier to get authenticated by
     *         the service in subsequent calls.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * A secret string generated for the client. The client will use this string to get authenticated by the service in
     * subsequent calls.
     * </p>
     * 
     * @return A secret string generated for the client. The client will use this string to get authenticated by the
     *         service in subsequent calls.
     */
    public final String clientSecret() {
        return clientSecret;
    }

    /**
     * <p>
     * Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> were issued.
     * </p>
     * 
     * @return Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> were issued.
     */
    public final Long clientIdIssuedAt() {
        return clientIdIssuedAt;
    }

    /**
     * <p>
     * Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> will become invalid.
     * </p>
     * 
     * @return Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> will become invalid.
     */
    public final Long clientSecretExpiresAt() {
        return clientSecretExpiresAt;
    }

    /**
     * <p>
     * The endpoint where the client can request authorization.
     * </p>
     * 
     * @return The endpoint where the client can request authorization.
     */
    public final String authorizationEndpoint() {
        return authorizationEndpoint;
    }

    /**
     * <p>
     * The endpoint where the client can get an access token.
     * </p>
     * 
     * @return The endpoint where the client can get an access token.
     */
    public final String tokenEndpoint() {
        return tokenEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(clientIdIssuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(clientSecretExpiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(tokenEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterClientResponse)) {
            return false;
        }
        RegisterClientResponse other = (RegisterClientResponse) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(clientSecret(), other.clientSecret())
                && Objects.equals(clientIdIssuedAt(), other.clientIdIssuedAt())
                && Objects.equals(clientSecretExpiresAt(), other.clientSecretExpiresAt())
                && Objects.equals(authorizationEndpoint(), other.authorizationEndpoint())
                && Objects.equals(tokenEndpoint(), other.tokenEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterClientResponse").add("ClientId", clientId()).add("ClientSecret", clientSecret())
                .add("ClientIdIssuedAt", clientIdIssuedAt()).add("ClientSecretExpiresAt", clientSecretExpiresAt())
                .add("AuthorizationEndpoint", authorizationEndpoint()).add("TokenEndpoint", tokenEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "clientSecret":
            return Optional.ofNullable(clazz.cast(clientSecret()));
        case "clientIdIssuedAt":
            return Optional.ofNullable(clazz.cast(clientIdIssuedAt()));
        case "clientSecretExpiresAt":
            return Optional.ofNullable(clazz.cast(clientSecretExpiresAt()));
        case "authorizationEndpoint":
            return Optional.ofNullable(clazz.cast(authorizationEndpoint()));
        case "tokenEndpoint":
            return Optional.ofNullable(clazz.cast(tokenEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterClientResponse, T> g) {
        return obj -> g.apply((RegisterClientResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoOidcResponse.Builder, SdkPojo, CopyableBuilder<Builder, RegisterClientResponse> {
        /**
         * <p>
         * The unique identifier string for each client. This client uses this identifier to get authenticated by the
         * service in subsequent calls.
         * </p>
         * 
         * @param clientId
         *        The unique identifier string for each client. This client uses this identifier to get authenticated by
         *        the service in subsequent calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * A secret string generated for the client. The client will use this string to get authenticated by the service
         * in subsequent calls.
         * </p>
         * 
         * @param clientSecret
         *        A secret string generated for the client. The client will use this string to get authenticated by the
         *        service in subsequent calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecret(String clientSecret);

        /**
         * <p>
         * Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> were issued.
         * </p>
         * 
         * @param clientIdIssuedAt
         *        Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> were issued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIdIssuedAt(Long clientIdIssuedAt);

        /**
         * <p>
         * Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> will become invalid.
         * </p>
         * 
         * @param clientSecretExpiresAt
         *        Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> will become
         *        invalid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecretExpiresAt(Long clientSecretExpiresAt);

        /**
         * <p>
         * The endpoint where the client can request authorization.
         * </p>
         * 
         * @param authorizationEndpoint
         *        The endpoint where the client can request authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationEndpoint(String authorizationEndpoint);

        /**
         * <p>
         * The endpoint where the client can get an access token.
         * </p>
         * 
         * @param tokenEndpoint
         *        The endpoint where the client can get an access token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenEndpoint(String tokenEndpoint);
    }

    static final class BuilderImpl extends SsoOidcResponse.BuilderImpl implements Builder {
        private String clientId;

        private String clientSecret;

        private Long clientIdIssuedAt;

        private Long clientSecretExpiresAt;

        private String authorizationEndpoint;

        private String tokenEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterClientResponse model) {
            super(model);
            clientId(model.clientId);
            clientSecret(model.clientSecret);
            clientIdIssuedAt(model.clientIdIssuedAt);
            clientSecretExpiresAt(model.clientSecretExpiresAt);
            authorizationEndpoint(model.authorizationEndpoint);
            tokenEndpoint(model.tokenEndpoint);
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getClientSecret() {
            return clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public final Long getClientIdIssuedAt() {
            return clientIdIssuedAt;
        }

        @Override
        public final Builder clientIdIssuedAt(Long clientIdIssuedAt) {
            this.clientIdIssuedAt = clientIdIssuedAt;
            return this;
        }

        public final void setClientIdIssuedAt(Long clientIdIssuedAt) {
            this.clientIdIssuedAt = clientIdIssuedAt;
        }

        public final Long getClientSecretExpiresAt() {
            return clientSecretExpiresAt;
        }

        @Override
        public final Builder clientSecretExpiresAt(Long clientSecretExpiresAt) {
            this.clientSecretExpiresAt = clientSecretExpiresAt;
            return this;
        }

        public final void setClientSecretExpiresAt(Long clientSecretExpiresAt) {
            this.clientSecretExpiresAt = clientSecretExpiresAt;
        }

        public final String getAuthorizationEndpoint() {
            return authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        public final String getTokenEndpoint() {
            return tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        @Override
        public RegisterClientResponse build() {
            return new RegisterClientResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
