/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssooidc.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTokenRequest extends SsoOidcRequest implements
        ToCopyableBuilder<CreateTokenRequest.Builder, CreateTokenRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientId").getter(getter(CreateTokenRequest::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()).build();

    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientSecret").getter(getter(CreateTokenRequest::clientSecret)).setter(setter(Builder::clientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecret").build()).build();

    private static final SdkField<String> GRANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("grantType").getter(getter(CreateTokenRequest::grantType)).setter(setter(Builder::grantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantType").build()).build();

    private static final SdkField<String> DEVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceCode").getter(getter(CreateTokenRequest::deviceCode)).setter(setter(Builder::deviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceCode").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(CreateTokenRequest::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("refreshToken").getter(getter(CreateTokenRequest::refreshToken)).setter(setter(Builder::refreshToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()).build();

    private static final SdkField<List<String>> SCOPE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("scope")
            .getter(getter(CreateTokenRequest::scope))
            .setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REDIRECT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("redirectUri").getter(getter(CreateTokenRequest::redirectUri)).setter(setter(Builder::redirectUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redirectUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD,
            CLIENT_SECRET_FIELD, GRANT_TYPE_FIELD, DEVICE_CODE_FIELD, CODE_FIELD, REFRESH_TOKEN_FIELD, SCOPE_FIELD,
            REDIRECT_URI_FIELD));

    private final String clientId;

    private final String clientSecret;

    private final String grantType;

    private final String deviceCode;

    private final String code;

    private final String refreshToken;

    private final List<String> scope;

    private final String redirectUri;

    private CreateTokenRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.grantType = builder.grantType;
        this.deviceCode = builder.deviceCode;
        this.code = builder.code;
        this.refreshToken = builder.refreshToken;
        this.scope = builder.scope;
        this.redirectUri = builder.redirectUri;
    }

    /**
     * <p>
     * The unique identifier string for each client. This value should come from the persisted result of the
     * <a>RegisterClient</a> API.
     * </p>
     * 
     * @return The unique identifier string for each client. This value should come from the persisted result of the
     *         <a>RegisterClient</a> API.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * A secret string generated for the client. This value should come from the persisted result of the
     * <a>RegisterClient</a> API.
     * </p>
     * 
     * @return A secret string generated for the client. This value should come from the persisted result of the
     *         <a>RegisterClient</a> API.
     */
    public final String clientSecret() {
        return clientSecret;
    }

    /**
     * <p>
     * Supports grant types for authorization code, refresh token, and device code request.
     * </p>
     * 
     * @return Supports grant types for authorization code, refresh token, and device code request.
     */
    public final String grantType() {
        return grantType;
    }

    /**
     * <p>
     * Used only when calling this API for the device code grant type. This short-term code is used to identify this
     * authentication attempt. This should come from an in-memory reference to the result of the
     * <a>StartDeviceAuthorization</a> API.
     * </p>
     * 
     * @return Used only when calling this API for the device code grant type. This short-term code is used to identify
     *         this authentication attempt. This should come from an in-memory reference to the result of the
     *         <a>StartDeviceAuthorization</a> API.
     */
    public final String deviceCode() {
        return deviceCode;
    }

    /**
     * <p>
     * The authorization code received from the authorization service. This parameter is required to perform an
     * authorization grant request to get access to a token.
     * </p>
     * 
     * @return The authorization code received from the authorization service. This parameter is required to perform an
     *         authorization grant request to get access to a token.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The token used to obtain an access token in the event that the access token is invalid or expired. This token is
     * not issued by the service.
     * </p>
     * 
     * @return The token used to obtain an access token in the event that the access token is invalid or expired. This
     *         token is not issued by the service.
     */
    public final String refreshToken() {
        return refreshToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scope property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasScope() {
        return scope != null && !(scope instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of scopes that is defined by the client. Upon authorization, this list is used to restrict permissions
     * when granting an access token.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScope} method.
     * </p>
     * 
     * @return The list of scopes that is defined by the client. Upon authorization, this list is used to restrict
     *         permissions when granting an access token.
     */
    public final List<String> scope() {
        return scope;
    }

    /**
     * <p>
     * The location of the application that will receive the authorization code. Users authorize the service to send the
     * request to this location.
     * </p>
     * 
     * @return The location of the application that will receive the authorization code. Users authorize the service to
     *         send the request to this location.
     */
    public final String redirectUri() {
        return redirectUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(grantType());
        hashCode = 31 * hashCode + Objects.hashCode(deviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasScope() ? scope() : null);
        hashCode = 31 * hashCode + Objects.hashCode(redirectUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTokenRequest)) {
            return false;
        }
        CreateTokenRequest other = (CreateTokenRequest) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(clientSecret(), other.clientSecret())
                && Objects.equals(grantType(), other.grantType()) && Objects.equals(deviceCode(), other.deviceCode())
                && Objects.equals(code(), other.code()) && Objects.equals(refreshToken(), other.refreshToken())
                && hasScope() == other.hasScope() && Objects.equals(scope(), other.scope())
                && Objects.equals(redirectUri(), other.redirectUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTokenRequest").add("ClientId", clientId()).add("ClientSecret", clientSecret())
                .add("GrantType", grantType()).add("DeviceCode", deviceCode()).add("Code", code())
                .add("RefreshToken", refreshToken()).add("Scope", hasScope() ? scope() : null).add("RedirectUri", redirectUri())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "clientSecret":
            return Optional.ofNullable(clazz.cast(clientSecret()));
        case "grantType":
            return Optional.ofNullable(clazz.cast(grantType()));
        case "deviceCode":
            return Optional.ofNullable(clazz.cast(deviceCode()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "refreshToken":
            return Optional.ofNullable(clazz.cast(refreshToken()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "redirectUri":
            return Optional.ofNullable(clazz.cast(redirectUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTokenRequest, T> g) {
        return obj -> g.apply((CreateTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoOidcRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTokenRequest> {
        /**
         * <p>
         * The unique identifier string for each client. This value should come from the persisted result of the
         * <a>RegisterClient</a> API.
         * </p>
         * 
         * @param clientId
         *        The unique identifier string for each client. This value should come from the persisted result of the
         *        <a>RegisterClient</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * A secret string generated for the client. This value should come from the persisted result of the
         * <a>RegisterClient</a> API.
         * </p>
         * 
         * @param clientSecret
         *        A secret string generated for the client. This value should come from the persisted result of the
         *        <a>RegisterClient</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecret(String clientSecret);

        /**
         * <p>
         * Supports grant types for authorization code, refresh token, and device code request.
         * </p>
         * 
         * @param grantType
         *        Supports grant types for authorization code, refresh token, and device code request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantType(String grantType);

        /**
         * <p>
         * Used only when calling this API for the device code grant type. This short-term code is used to identify this
         * authentication attempt. This should come from an in-memory reference to the result of the
         * <a>StartDeviceAuthorization</a> API.
         * </p>
         * 
         * @param deviceCode
         *        Used only when calling this API for the device code grant type. This short-term code is used to
         *        identify this authentication attempt. This should come from an in-memory reference to the result of
         *        the <a>StartDeviceAuthorization</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCode(String deviceCode);

        /**
         * <p>
         * The authorization code received from the authorization service. This parameter is required to perform an
         * authorization grant request to get access to a token.
         * </p>
         * 
         * @param code
         *        The authorization code received from the authorization service. This parameter is required to perform
         *        an authorization grant request to get access to a token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The token used to obtain an access token in the event that the access token is invalid or expired. This token
         * is not issued by the service.
         * </p>
         * 
         * @param refreshToken
         *        The token used to obtain an access token in the event that the access token is invalid or expired.
         *        This token is not issued by the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshToken(String refreshToken);

        /**
         * <p>
         * The list of scopes that is defined by the client. Upon authorization, this list is used to restrict
         * permissions when granting an access token.
         * </p>
         * 
         * @param scope
         *        The list of scopes that is defined by the client. Upon authorization, this list is used to restrict
         *        permissions when granting an access token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(Collection<String> scope);

        /**
         * <p>
         * The list of scopes that is defined by the client. Upon authorization, this list is used to restrict
         * permissions when granting an access token.
         * </p>
         * 
         * @param scope
         *        The list of scopes that is defined by the client. Upon authorization, this list is used to restrict
         *        permissions when granting an access token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(String... scope);

        /**
         * <p>
         * The location of the application that will receive the authorization code. Users authorize the service to send
         * the request to this location.
         * </p>
         * 
         * @param redirectUri
         *        The location of the application that will receive the authorization code. Users authorize the service
         *        to send the request to this location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectUri(String redirectUri);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoOidcRequest.BuilderImpl implements Builder {
        private String clientId;

        private String clientSecret;

        private String grantType;

        private String deviceCode;

        private String code;

        private String refreshToken;

        private List<String> scope = DefaultSdkAutoConstructList.getInstance();

        private String redirectUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTokenRequest model) {
            super(model);
            clientId(model.clientId);
            clientSecret(model.clientSecret);
            grantType(model.grantType);
            deviceCode(model.deviceCode);
            code(model.code);
            refreshToken(model.refreshToken);
            scope(model.scope);
            redirectUri(model.redirectUri);
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        @Transient
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        @Transient
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final String getGrantType() {
            return grantType;
        }

        public final void setGrantType(String grantType) {
            this.grantType = grantType;
        }

        @Override
        @Transient
        public final Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public final String getDeviceCode() {
            return deviceCode;
        }

        public final void setDeviceCode(String deviceCode) {
            this.deviceCode = deviceCode;
        }

        @Override
        @Transient
        public final Builder deviceCode(String deviceCode) {
            this.deviceCode = deviceCode;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        @Transient
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getRefreshToken() {
            return refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        @Transient
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final Collection<String> getScope() {
            if (scope instanceof SdkAutoConstructList) {
                return null;
            }
            return scope;
        }

        public final void setScope(Collection<String> scope) {
            this.scope = ScopesCopier.copy(scope);
        }

        @Override
        @Transient
        public final Builder scope(Collection<String> scope) {
            this.scope = ScopesCopier.copy(scope);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder scope(String... scope) {
            scope(Arrays.asList(scope));
            return this;
        }

        public final String getRedirectUri() {
            return redirectUri;
        }

        public final void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Override
        @Transient
        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTokenRequest build() {
            return new CreateTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
