/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssooidc.DefaultSsoOidcBaseClientBuilder;
import software.amazon.awssdk.services.ssooidc.DefaultSsoOidcClient;
import software.amazon.awssdk.services.ssooidc.SsoOidcClient;
import software.amazon.awssdk.services.ssooidc.SsoOidcClientBuilder;
import software.amazon.awssdk.services.ssooidc.SsoOidcServiceClientConfiguration;
import software.amazon.awssdk.services.ssooidc.endpoints.SsoOidcEndpointProvider;

@SdkInternalApi
final class DefaultSsoOidcClientBuilder
extends DefaultSsoOidcBaseClientBuilder<SsoOidcClientBuilder, SsoOidcClient>
implements SsoOidcClientBuilder {
    DefaultSsoOidcClientBuilder() {
    }

    @Override
    public DefaultSsoOidcClientBuilder endpointProvider(SsoOidcEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SsoOidcClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSsoOidcClientBuilder.validateClientOptions(clientConfiguration);
        SsoOidcServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSsoOidcClient client = new DefaultSsoOidcClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SsoOidcServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SsoOidcServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

