/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterClientRequest extends SsoOidcRequest implements
        ToCopyableBuilder<RegisterClientRequest.Builder, RegisterClientRequest> {
    private static final SdkField<String> CLIENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientName").getter(getter(RegisterClientRequest::clientName)).setter(setter(Builder::clientName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientName").build()).build();

    private static final SdkField<String> CLIENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientType").getter(getter(RegisterClientRequest::clientType)).setter(setter(Builder::clientType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientType").build()).build();

    private static final SdkField<List<String>> SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("scopes")
            .getter(getter(RegisterClientRequest::scopes))
            .setter(setter(Builder::scopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REDIRECT_URIS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("redirectUris")
            .getter(getter(RegisterClientRequest::redirectUris))
            .setter(setter(Builder::redirectUris))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redirectUris").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> GRANT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("grantTypes")
            .getter(getter(RegisterClientRequest::grantTypes))
            .setter(setter(Builder::grantTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ISSUER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("issuerUrl").getter(getter(RegisterClientRequest::issuerUrl)).setter(setter(Builder::issuerUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuerUrl").build()).build();

    private static final SdkField<String> ENTITLED_APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entitledApplicationArn").getter(getter(RegisterClientRequest::entitledApplicationArn))
            .setter(setter(Builder::entitledApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitledApplicationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_NAME_FIELD,
            CLIENT_TYPE_FIELD, SCOPES_FIELD, REDIRECT_URIS_FIELD, GRANT_TYPES_FIELD, ISSUER_URL_FIELD,
            ENTITLED_APPLICATION_ARN_FIELD));

    private final String clientName;

    private final String clientType;

    private final List<String> scopes;

    private final List<String> redirectUris;

    private final List<String> grantTypes;

    private final String issuerUrl;

    private final String entitledApplicationArn;

    private RegisterClientRequest(BuilderImpl builder) {
        super(builder);
        this.clientName = builder.clientName;
        this.clientType = builder.clientType;
        this.scopes = builder.scopes;
        this.redirectUris = builder.redirectUris;
        this.grantTypes = builder.grantTypes;
        this.issuerUrl = builder.issuerUrl;
        this.entitledApplicationArn = builder.entitledApplicationArn;
    }

    /**
     * <p>
     * The friendly name of the client.
     * </p>
     * 
     * @return The friendly name of the client.
     */
    public final String clientName() {
        return clientName;
    }

    /**
     * <p>
     * The type of client. The service supports only <code>public</code> as a client type. Anything other than public
     * will be rejected by the service.
     * </p>
     * 
     * @return The type of client. The service supports only <code>public</code> as a client type. Anything other than
     *         public will be rejected by the service.
     */
    public final String clientType() {
        return clientType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scopes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScopes() {
        return scopes != null && !(scopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of scopes that are defined by the client. Upon authorization, this list is used to restrict permissions
     * when granting an access token.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScopes} method.
     * </p>
     * 
     * @return The list of scopes that are defined by the client. Upon authorization, this list is used to restrict
     *         permissions when granting an access token.
     */
    public final List<String> scopes() {
        return scopes;
    }

    /**
     * For responses, this returns true if the service returned a value for the RedirectUris property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRedirectUris() {
        return redirectUris != null && !(redirectUris instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of redirect URI that are defined by the client. At completion of authorization, this list is used to
     * restrict what locations the user agent can be redirected back to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRedirectUris} method.
     * </p>
     * 
     * @return The list of redirect URI that are defined by the client. At completion of authorization, this list is
     *         used to restrict what locations the user agent can be redirected back to.
     */
    public final List<String> redirectUris() {
        return redirectUris;
    }

    /**
     * For responses, this returns true if the service returned a value for the GrantTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGrantTypes() {
        return grantTypes != null && !(grantTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of OAuth 2.0 grant types that are defined by the client. This list is used to restrict the token
     * granting flows available to the client.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGrantTypes} method.
     * </p>
     * 
     * @return The list of OAuth 2.0 grant types that are defined by the client. This list is used to restrict the token
     *         granting flows available to the client.
     */
    public final List<String> grantTypes() {
        return grantTypes;
    }

    /**
     * <p>
     * The IAM Identity Center Issuer URL associated with an instance of IAM Identity Center. This value is needed for
     * user access to resources through the client.
     * </p>
     * 
     * @return The IAM Identity Center Issuer URL associated with an instance of IAM Identity Center. This value is
     *         needed for user access to resources through the client.
     */
    public final String issuerUrl() {
        return issuerUrl;
    }

    /**
     * <p>
     * This IAM Identity Center application ARN is used to define administrator-managed configuration for public client
     * access to resources. At authorization, the scopes, grants, and redirect URI available to this client will be
     * restricted by this application resource.
     * </p>
     * 
     * @return This IAM Identity Center application ARN is used to define administrator-managed configuration for public
     *         client access to resources. At authorization, the scopes, grants, and redirect URI available to this
     *         client will be restricted by this application resource.
     */
    public final String entitledApplicationArn() {
        return entitledApplicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientName());
        hashCode = 31 * hashCode + Objects.hashCode(clientType());
        hashCode = 31 * hashCode + Objects.hashCode(hasScopes() ? scopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRedirectUris() ? redirectUris() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGrantTypes() ? grantTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(issuerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(entitledApplicationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterClientRequest)) {
            return false;
        }
        RegisterClientRequest other = (RegisterClientRequest) obj;
        return Objects.equals(clientName(), other.clientName()) && Objects.equals(clientType(), other.clientType())
                && hasScopes() == other.hasScopes() && Objects.equals(scopes(), other.scopes())
                && hasRedirectUris() == other.hasRedirectUris() && Objects.equals(redirectUris(), other.redirectUris())
                && hasGrantTypes() == other.hasGrantTypes() && Objects.equals(grantTypes(), other.grantTypes())
                && Objects.equals(issuerUrl(), other.issuerUrl())
                && Objects.equals(entitledApplicationArn(), other.entitledApplicationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterClientRequest").add("ClientName", clientName()).add("ClientType", clientType())
                .add("Scopes", hasScopes() ? scopes() : null).add("RedirectUris", hasRedirectUris() ? redirectUris() : null)
                .add("GrantTypes", hasGrantTypes() ? grantTypes() : null).add("IssuerUrl", issuerUrl())
                .add("EntitledApplicationArn", entitledApplicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientName":
            return Optional.ofNullable(clazz.cast(clientName()));
        case "clientType":
            return Optional.ofNullable(clazz.cast(clientType()));
        case "scopes":
            return Optional.ofNullable(clazz.cast(scopes()));
        case "redirectUris":
            return Optional.ofNullable(clazz.cast(redirectUris()));
        case "grantTypes":
            return Optional.ofNullable(clazz.cast(grantTypes()));
        case "issuerUrl":
            return Optional.ofNullable(clazz.cast(issuerUrl()));
        case "entitledApplicationArn":
            return Optional.ofNullable(clazz.cast(entitledApplicationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterClientRequest, T> g) {
        return obj -> g.apply((RegisterClientRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoOidcRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterClientRequest> {
        /**
         * <p>
         * The friendly name of the client.
         * </p>
         * 
         * @param clientName
         *        The friendly name of the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientName(String clientName);

        /**
         * <p>
         * The type of client. The service supports only <code>public</code> as a client type. Anything other than
         * public will be rejected by the service.
         * </p>
         * 
         * @param clientType
         *        The type of client. The service supports only <code>public</code> as a client type. Anything other
         *        than public will be rejected by the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientType(String clientType);

        /**
         * <p>
         * The list of scopes that are defined by the client. Upon authorization, this list is used to restrict
         * permissions when granting an access token.
         * </p>
         * 
         * @param scopes
         *        The list of scopes that are defined by the client. Upon authorization, this list is used to restrict
         *        permissions when granting an access token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(Collection<String> scopes);

        /**
         * <p>
         * The list of scopes that are defined by the client. Upon authorization, this list is used to restrict
         * permissions when granting an access token.
         * </p>
         * 
         * @param scopes
         *        The list of scopes that are defined by the client. Upon authorization, this list is used to restrict
         *        permissions when granting an access token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(String... scopes);

        /**
         * <p>
         * The list of redirect URI that are defined by the client. At completion of authorization, this list is used to
         * restrict what locations the user agent can be redirected back to.
         * </p>
         * 
         * @param redirectUris
         *        The list of redirect URI that are defined by the client. At completion of authorization, this list is
         *        used to restrict what locations the user agent can be redirected back to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectUris(Collection<String> redirectUris);

        /**
         * <p>
         * The list of redirect URI that are defined by the client. At completion of authorization, this list is used to
         * restrict what locations the user agent can be redirected back to.
         * </p>
         * 
         * @param redirectUris
         *        The list of redirect URI that are defined by the client. At completion of authorization, this list is
         *        used to restrict what locations the user agent can be redirected back to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectUris(String... redirectUris);

        /**
         * <p>
         * The list of OAuth 2.0 grant types that are defined by the client. This list is used to restrict the token
         * granting flows available to the client.
         * </p>
         * 
         * @param grantTypes
         *        The list of OAuth 2.0 grant types that are defined by the client. This list is used to restrict the
         *        token granting flows available to the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantTypes(Collection<String> grantTypes);

        /**
         * <p>
         * The list of OAuth 2.0 grant types that are defined by the client. This list is used to restrict the token
         * granting flows available to the client.
         * </p>
         * 
         * @param grantTypes
         *        The list of OAuth 2.0 grant types that are defined by the client. This list is used to restrict the
         *        token granting flows available to the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantTypes(String... grantTypes);

        /**
         * <p>
         * The IAM Identity Center Issuer URL associated with an instance of IAM Identity Center. This value is needed
         * for user access to resources through the client.
         * </p>
         * 
         * @param issuerUrl
         *        The IAM Identity Center Issuer URL associated with an instance of IAM Identity Center. This value is
         *        needed for user access to resources through the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuerUrl(String issuerUrl);

        /**
         * <p>
         * This IAM Identity Center application ARN is used to define administrator-managed configuration for public
         * client access to resources. At authorization, the scopes, grants, and redirect URI available to this client
         * will be restricted by this application resource.
         * </p>
         * 
         * @param entitledApplicationArn
         *        This IAM Identity Center application ARN is used to define administrator-managed configuration for
         *        public client access to resources. At authorization, the scopes, grants, and redirect URI available to
         *        this client will be restricted by this application resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitledApplicationArn(String entitledApplicationArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoOidcRequest.BuilderImpl implements Builder {
        private String clientName;

        private String clientType;

        private List<String> scopes = DefaultSdkAutoConstructList.getInstance();

        private List<String> redirectUris = DefaultSdkAutoConstructList.getInstance();

        private List<String> grantTypes = DefaultSdkAutoConstructList.getInstance();

        private String issuerUrl;

        private String entitledApplicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterClientRequest model) {
            super(model);
            clientName(model.clientName);
            clientType(model.clientType);
            scopes(model.scopes);
            redirectUris(model.redirectUris);
            grantTypes(model.grantTypes);
            issuerUrl(model.issuerUrl);
            entitledApplicationArn(model.entitledApplicationArn);
        }

        public final String getClientName() {
            return clientName;
        }

        public final void setClientName(String clientName) {
            this.clientName = clientName;
        }

        @Override
        public final Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public final String getClientType() {
            return clientType;
        }

        public final void setClientType(String clientType) {
            this.clientType = clientType;
        }

        @Override
        public final Builder clientType(String clientType) {
            this.clientType = clientType;
            return this;
        }

        public final Collection<String> getScopes() {
            if (scopes instanceof SdkAutoConstructList) {
                return null;
            }
            return scopes;
        }

        public final void setScopes(Collection<String> scopes) {
            this.scopes = ScopesCopier.copy(scopes);
        }

        @Override
        public final Builder scopes(Collection<String> scopes) {
            this.scopes = ScopesCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(String... scopes) {
            scopes(Arrays.asList(scopes));
            return this;
        }

        public final Collection<String> getRedirectUris() {
            if (redirectUris instanceof SdkAutoConstructList) {
                return null;
            }
            return redirectUris;
        }

        public final void setRedirectUris(Collection<String> redirectUris) {
            this.redirectUris = RedirectUrisCopier.copy(redirectUris);
        }

        @Override
        public final Builder redirectUris(Collection<String> redirectUris) {
            this.redirectUris = RedirectUrisCopier.copy(redirectUris);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redirectUris(String... redirectUris) {
            redirectUris(Arrays.asList(redirectUris));
            return this;
        }

        public final Collection<String> getGrantTypes() {
            if (grantTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return grantTypes;
        }

        public final void setGrantTypes(Collection<String> grantTypes) {
            this.grantTypes = GrantTypesCopier.copy(grantTypes);
        }

        @Override
        public final Builder grantTypes(Collection<String> grantTypes) {
            this.grantTypes = GrantTypesCopier.copy(grantTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTypes(String... grantTypes) {
            grantTypes(Arrays.asList(grantTypes));
            return this;
        }

        public final String getIssuerUrl() {
            return issuerUrl;
        }

        public final void setIssuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
        }

        @Override
        public final Builder issuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
            return this;
        }

        public final String getEntitledApplicationArn() {
            return entitledApplicationArn;
        }

        public final void setEntitledApplicationArn(String entitledApplicationArn) {
            this.entitledApplicationArn = entitledApplicationArn;
        }

        @Override
        public final Builder entitledApplicationArn(String entitledApplicationArn) {
            this.entitledApplicationArn = entitledApplicationArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterClientRequest build() {
            return new RegisterClientRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
