/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssooidc.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains Amazon Web Services-specific parameter extensions for the token endpoint responses and
 * includes the identity context.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAdditionalDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsAdditionalDetails.Builder, AwsAdditionalDetails> {
    private static final SdkField<String> IDENTITY_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityContext").getter(getter(AwsAdditionalDetails::identityContext))
            .setter(setter(Builder::identityContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityContext").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String identityContext;

    private AwsAdditionalDetails(BuilderImpl builder) {
        this.identityContext = builder.identityContext;
    }

    /**
     * <p>
     * STS context assertion that carries a user identifier to the Amazon Web Services service that it calls and can be
     * used to obtain an identity-enhanced IAM role session. This value corresponds to the
     * <code>sts:identity_context</code> claim in the ID token.
     * </p>
     * 
     * @return STS context assertion that carries a user identifier to the Amazon Web Services service that it calls and
     *         can be used to obtain an identity-enhanced IAM role session. This value corresponds to the
     *         <code>sts:identity_context</code> claim in the ID token.
     */
    public final String identityContext() {
        return identityContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAdditionalDetails)) {
            return false;
        }
        AwsAdditionalDetails other = (AwsAdditionalDetails) obj;
        return Objects.equals(identityContext(), other.identityContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAdditionalDetails").add("IdentityContext", identityContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identityContext":
            return Optional.ofNullable(clazz.cast(identityContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identityContext", IDENTITY_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAdditionalDetails, T> g) {
        return obj -> g.apply((AwsAdditionalDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAdditionalDetails> {
        /**
         * <p>
         * STS context assertion that carries a user identifier to the Amazon Web Services service that it calls and can
         * be used to obtain an identity-enhanced IAM role session. This value corresponds to the
         * <code>sts:identity_context</code> claim in the ID token.
         * </p>
         * 
         * @param identityContext
         *        STS context assertion that carries a user identifier to the Amazon Web Services service that it calls
         *        and can be used to obtain an identity-enhanced IAM role session. This value corresponds to the
         *        <code>sts:identity_context</code> claim in the ID token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityContext(String identityContext);
    }

    static final class BuilderImpl implements Builder {
        private String identityContext;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAdditionalDetails model) {
            identityContext(model.identityContext);
        }

        public final String getIdentityContext() {
            return identityContext;
        }

        public final void setIdentityContext(String identityContext) {
            this.identityContext = identityContext;
        }

        @Override
        public final Builder identityContext(String identityContext) {
            this.identityContext = identityContext;
            return this;
        }

        @Override
        public AwsAdditionalDetails build() {
            return new AwsAdditionalDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
