/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateSMBFileShareOutput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSmbFileShareResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<CreateSmbFileShareResponse.Builder, CreateSmbFileShareResponse> {
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSmbFileShareResponse::fileShareARN)).setter(setter(Builder::fileShareARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_ARN_FIELD));

    private final String fileShareARN;

    private CreateSmbFileShareResponse(BuilderImpl builder) {
        super(builder);
        this.fileShareARN = builder.fileShareARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the newly created file share.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the newly created file share.
     */
    public String fileShareARN() {
        return fileShareARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileShareARN());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSmbFileShareResponse)) {
            return false;
        }
        CreateSmbFileShareResponse other = (CreateSmbFileShareResponse) obj;
        return Objects.equals(fileShareARN(), other.fileShareARN());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateSmbFileShareResponse").add("FileShareARN", fileShareARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileShareARN":
            return Optional.ofNullable(clazz.cast(fileShareARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSmbFileShareResponse, T> g) {
        return obj -> g.apply((CreateSmbFileShareResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSmbFileShareResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the newly created file share.
         * </p>
         * 
         * @param fileShareARN
         *        The Amazon Resource Name (ARN) of the newly created file share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareARN(String fileShareARN);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String fileShareARN;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSmbFileShareResponse model) {
            super(model);
            fileShareARN(model.fileShareARN);
        }

        public final String getFileShareARN() {
            return fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        public CreateSmbFileShareResponse build() {
            return new CreateSmbFileShareResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
