/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSnapshotFromVolumeRecoveryPointRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<CreateSnapshotFromVolumeRecoveryPointRequest.Builder, CreateSnapshotFromVolumeRecoveryPointRequest> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSnapshotFromVolumeRecoveryPointRequest::volumeARN)).setter(setter(Builder::volumeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()).build();

    private static final SdkField<String> SNAPSHOT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSnapshotFromVolumeRecoveryPointRequest::snapshotDescription))
            .setter(setter(Builder::snapshotDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD,
            SNAPSHOT_DESCRIPTION_FIELD));

    private final String volumeARN;

    private final String snapshotDescription;

    private CreateSnapshotFromVolumeRecoveryPointRequest(BuilderImpl builder) {
        super(builder);
        this.volumeARN = builder.volumeARN;
        this.snapshotDescription = builder.snapshotDescription;
    }

    /**
     * Returns the value of the VolumeARN property for this object.
     * 
     * @return The value of the VolumeARN property for this object.
     */
    public String volumeARN() {
        return volumeARN;
    }

    /**
     * Returns the value of the SnapshotDescription property for this object.
     * 
     * @return The value of the SnapshotDescription property for this object.
     */
    public String snapshotDescription() {
        return snapshotDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotFromVolumeRecoveryPointRequest)) {
            return false;
        }
        CreateSnapshotFromVolumeRecoveryPointRequest other = (CreateSnapshotFromVolumeRecoveryPointRequest) obj;
        return Objects.equals(volumeARN(), other.volumeARN())
                && Objects.equals(snapshotDescription(), other.snapshotDescription());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateSnapshotFromVolumeRecoveryPointRequest").add("VolumeARN", volumeARN())
                .add("SnapshotDescription", snapshotDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeARN":
            return Optional.ofNullable(clazz.cast(volumeARN()));
        case "SnapshotDescription":
            return Optional.ofNullable(clazz.cast(snapshotDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotFromVolumeRecoveryPointRequest, T> g) {
        return obj -> g.apply((CreateSnapshotFromVolumeRecoveryPointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSnapshotFromVolumeRecoveryPointRequest> {
        /**
         * Sets the value of the VolumeARN property for this object.
         *
         * @param volumeARN
         *        The new value for the VolumeARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeARN(String volumeARN);

        /**
         * Sets the value of the SnapshotDescription property for this object.
         *
         * @param snapshotDescription
         *        The new value for the SnapshotDescription property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotDescription(String snapshotDescription);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String volumeARN;

        private String snapshotDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotFromVolumeRecoveryPointRequest model) {
            super(model);
            volumeARN(model.volumeARN);
            snapshotDescription(model.snapshotDescription);
        }

        public final String getVolumeARN() {
            return volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        public final String getSnapshotDescription() {
            return snapshotDescription;
        }

        @Override
        public final Builder snapshotDescription(String snapshotDescription) {
            this.snapshotDescription = snapshotDescription;
            return this;
        }

        public final void setSnapshotDescription(String snapshotDescription) {
            this.snapshotDescription = snapshotDescription;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSnapshotFromVolumeRecoveryPointRequest build() {
            return new CreateSnapshotFromVolumeRecoveryPointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
