/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateTapeWithBarcodeInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTapeWithBarcodeRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<CreateTapeWithBarcodeRequest.Builder, CreateTapeWithBarcodeRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTapeWithBarcodeRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<Long> TAPE_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CreateTapeWithBarcodeRequest::tapeSizeInBytes)).setter(setter(Builder::tapeSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeSizeInBytes").build()).build();

    private static final SdkField<String> TAPE_BARCODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTapeWithBarcodeRequest::tapeBarcode)).setter(setter(Builder::tapeBarcode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeBarcode").build()).build();

    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateTapeWithBarcodeRequest::kmsEncrypted)).setter(setter(Builder::kmsEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTapeWithBarcodeRequest::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            TAPE_SIZE_IN_BYTES_FIELD, TAPE_BARCODE_FIELD, KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD));

    private final String gatewayARN;

    private final Long tapeSizeInBytes;

    private final String tapeBarcode;

    private final Boolean kmsEncrypted;

    private final String kmsKey;

    private CreateTapeWithBarcodeRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.tapeSizeInBytes = builder.tapeSizeInBytes;
        this.tapeBarcode = builder.tapeBarcode;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tape with. Use the
     * <a>ListGateways</a> operation to return a list of gateways for your account and region.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tape with. Use
     *         the <a>ListGateways</a> operation to return a list of gateways for your account and region.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The size, in bytes, of the virtual tape that you want to create.
     * </p>
     * <note>
     * <p>
     * The size must be aligned by gigabyte (1024*1024*1024 byte).
     * </p>
     * </note>
     * 
     * @return The size, in bytes, of the virtual tape that you want to create.</p> <note>
     *         <p>
     *         The size must be aligned by gigabyte (1024*1024*1024 byte).
     *         </p>
     */
    public Long tapeSizeInBytes() {
        return tapeSizeInBytes;
    }

    /**
     * <p>
     * The barcode that you want to assign to the tape.
     * </p>
     * <note>
     * <p>
     * Barcodes cannot be reused. This includes barcodes used for tapes that have been deleted.
     * </p>
     * </note>
     * 
     * @return The barcode that you want to assign to the tape.</p> <note>
     *         <p>
     *         Barcodes cannot be reused. This includes barcodes used for tapes that have been deleted.
     *         </p>
     */
    public String tapeBarcode() {
        return tapeBarcode;
    }

    /**
     * <p>
     * True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by Amazon
     * S3. Optional.
     * </p>
     * 
     * @return True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by
     *         Amazon S3. Optional.
     */
    public Boolean kmsEncrypted() {
        return kmsEncrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS KMS Key used for Amazon S3 server side encryption. This value can only
     * be set when KMSEncrypted is true. Optional.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS KMS Key used for Amazon S3 server side encryption. This value
     *         can only be set when KMSEncrypted is true. Optional.
     */
    public String kmsKey() {
        return kmsKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(tapeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(tapeBarcode());
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTapeWithBarcodeRequest)) {
            return false;
        }
        CreateTapeWithBarcodeRequest other = (CreateTapeWithBarcodeRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(tapeSizeInBytes(), other.tapeSizeInBytes())
                && Objects.equals(tapeBarcode(), other.tapeBarcode()) && Objects.equals(kmsEncrypted(), other.kmsEncrypted())
                && Objects.equals(kmsKey(), other.kmsKey());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateTapeWithBarcodeRequest").add("GatewayARN", gatewayARN())
                .add("TapeSizeInBytes", tapeSizeInBytes()).add("TapeBarcode", tapeBarcode()).add("KMSEncrypted", kmsEncrypted())
                .add("KMSKey", kmsKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "TapeSizeInBytes":
            return Optional.ofNullable(clazz.cast(tapeSizeInBytes()));
        case "TapeBarcode":
            return Optional.ofNullable(clazz.cast(tapeBarcode()));
        case "KMSEncrypted":
            return Optional.ofNullable(clazz.cast(kmsEncrypted()));
        case "KMSKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTapeWithBarcodeRequest, T> g) {
        return obj -> g.apply((CreateTapeWithBarcodeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTapeWithBarcodeRequest> {
        /**
         * <p>
         * The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tape with. Use the
         * <a>ListGateways</a> operation to return a list of gateways for your account and region.
         * </p>
         * 
         * @param gatewayARN
         *        The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tape with.
         *        Use the <a>ListGateways</a> operation to return a list of gateways for your account and region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The size, in bytes, of the virtual tape that you want to create.
         * </p>
         * <note>
         * <p>
         * The size must be aligned by gigabyte (1024*1024*1024 byte).
         * </p>
         * </note>
         * 
         * @param tapeSizeInBytes
         *        The size, in bytes, of the virtual tape that you want to create.</p> <note>
         *        <p>
         *        The size must be aligned by gigabyte (1024*1024*1024 byte).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeSizeInBytes(Long tapeSizeInBytes);

        /**
         * <p>
         * The barcode that you want to assign to the tape.
         * </p>
         * <note>
         * <p>
         * Barcodes cannot be reused. This includes barcodes used for tapes that have been deleted.
         * </p>
         * </note>
         * 
         * @param tapeBarcode
         *        The barcode that you want to assign to the tape.</p> <note>
         *        <p>
         *        Barcodes cannot be reused. This includes barcodes used for tapes that have been deleted.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeBarcode(String tapeBarcode);

        /**
         * <p>
         * True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by
         * Amazon S3. Optional.
         * </p>
         * 
         * @param kmsEncrypted
         *        True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed
         *        by Amazon S3. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncrypted(Boolean kmsEncrypted);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS KMS Key used for Amazon S3 server side encryption. This value can
         * only be set when KMSEncrypted is true. Optional.
         * </p>
         * 
         * @param kmsKey
         *        The Amazon Resource Name (ARN) of the AWS KMS Key used for Amazon S3 server side encryption. This
         *        value can only be set when KMSEncrypted is true. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private Long tapeSizeInBytes;

        private String tapeBarcode;

        private Boolean kmsEncrypted;

        private String kmsKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTapeWithBarcodeRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            tapeSizeInBytes(model.tapeSizeInBytes);
            tapeBarcode(model.tapeBarcode);
            kmsEncrypted(model.kmsEncrypted);
            kmsKey(model.kmsKey);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Long getTapeSizeInBytes() {
            return tapeSizeInBytes;
        }

        @Override
        public final Builder tapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
            return this;
        }

        public final void setTapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
        }

        public final String getTapeBarcode() {
            return tapeBarcode;
        }

        @Override
        public final Builder tapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
            return this;
        }

        public final void setTapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
        }

        public final Boolean getKMSEncrypted() {
            return kmsEncrypted;
        }

        @Override
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final void setKMSEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        public final String getKMSKey() {
            return kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKMSKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTapeWithBarcodeRequest build() {
            return new CreateTapeWithBarcodeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
