/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSmbSettingsResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeSmbSettingsResponse.Builder, DescribeSmbSettingsResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSmbSettingsResponse::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSmbSettingsResponse::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<Boolean> SMB_GUEST_PASSWORD_SET_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DescribeSmbSettingsResponse::smbGuestPasswordSet)).setter(setter(Builder::smbGuestPasswordSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBGuestPasswordSet").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            DOMAIN_NAME_FIELD, SMB_GUEST_PASSWORD_SET_FIELD));

    private final String gatewayARN;

    private final String domainName;

    private final Boolean smbGuestPasswordSet;

    private DescribeSmbSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.domainName = builder.domainName;
        this.smbGuestPasswordSet = builder.smbGuestPasswordSet;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The name of the domain that the gateway is joined to.
     * </p>
     * 
     * @return The name of the domain that the gateway is joined to.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * This value is true if a password for the guest user “smbguest” is set, and otherwise false.
     * </p>
     * 
     * @return This value is true if a password for the guest user “smbguest” is set, and otherwise false.
     */
    public Boolean smbGuestPasswordSet() {
        return smbGuestPasswordSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(smbGuestPasswordSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSmbSettingsResponse)) {
            return false;
        }
        DescribeSmbSettingsResponse other = (DescribeSmbSettingsResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(smbGuestPasswordSet(), other.smbGuestPasswordSet());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeSmbSettingsResponse").add("GatewayARN", gatewayARN()).add("DomainName", domainName())
                .add("SMBGuestPasswordSet", smbGuestPasswordSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "SMBGuestPasswordSet":
            return Optional.ofNullable(clazz.cast(smbGuestPasswordSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSmbSettingsResponse, T> g) {
        return obj -> g.apply((DescribeSmbSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSmbSettingsResponse> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The name of the domain that the gateway is joined to.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that the gateway is joined to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * This value is true if a password for the guest user “smbguest” is set, and otherwise false.
         * </p>
         * 
         * @param smbGuestPasswordSet
         *        This value is true if a password for the guest user “smbguest” is set, and otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smbGuestPasswordSet(Boolean smbGuestPasswordSet);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private String domainName;

        private Boolean smbGuestPasswordSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSmbSettingsResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            domainName(model.domainName);
            smbGuestPasswordSet(model.smbGuestPasswordSet);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Boolean getSMBGuestPasswordSet() {
            return smbGuestPasswordSet;
        }

        @Override
        public final Builder smbGuestPasswordSet(Boolean smbGuestPasswordSet) {
            this.smbGuestPasswordSet = smbGuestPasswordSet;
            return this;
        }

        public final void setSMBGuestPasswordSet(Boolean smbGuestPasswordSet) {
            this.smbGuestPasswordSet = smbGuestPasswordSet;
        }

        @Override
        public DescribeSmbSettingsResponse build() {
            return new DescribeSmbSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
