/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeTapesInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTapesRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<DescribeTapesRequest.Builder, DescribeTapesRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTapesRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<List<String>> TAPE_AR_NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTapesRequest::tapeARNs))
            .setter(setter(Builder::tapeARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTapesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeTapesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            TAPE_AR_NS_FIELD, MARKER_FIELD, LIMIT_FIELD));

    private final String gatewayARN;

    private final List<String> tapeARNs;

    private final String marker;

    private final Integer limit;

    private DescribeTapesRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.tapeARNs = builder.tapeARNs;
        this.marker = builder.marker;
        this.limit = builder.limit;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to describe.
     * If this parameter is not specified, Tape gateway returns a description of all virtual tapes associated with the
     * specified gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to
     *         describe. If this parameter is not specified, Tape gateway returns a description of all virtual tapes
     *         associated with the specified gateway.
     */
    public List<String> tapeARNs() {
        return tapeARNs;
    }

    /**
     * <p>
     * A marker value, obtained in a previous call to <code>DescribeTapes</code>. This marker indicates which page of
     * results to retrieve.
     * </p>
     * <p>
     * If not specified, the first page of results is retrieved.
     * </p>
     * 
     * @return A marker value, obtained in a previous call to <code>DescribeTapes</code>. This marker indicates which
     *         page of results to retrieve. </p>
     *         <p>
     *         If not specified, the first page of results is retrieved.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Specifies that the number of virtual tapes described be limited to the specified number.
     * </p>
     * <note>
     * <p>
     * Amazon Web Services may impose its own limit, if this field is not set.
     * </p>
     * </note>
     * 
     * @return Specifies that the number of virtual tapes described be limited to the specified number.</p> <note>
     *         <p>
     *         Amazon Web Services may impose its own limit, if this field is not set.
     *         </p>
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(tapeARNs());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTapesRequest)) {
            return false;
        }
        DescribeTapesRequest other = (DescribeTapesRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(tapeARNs(), other.tapeARNs())
                && Objects.equals(marker(), other.marker()) && Objects.equals(limit(), other.limit());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeTapesRequest").add("GatewayARN", gatewayARN()).add("TapeARNs", tapeARNs())
                .add("Marker", marker()).add("Limit", limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "TapeARNs":
            return Optional.ofNullable(clazz.cast(tapeARNs()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTapesRequest, T> g) {
        return obj -> g.apply((DescribeTapesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTapesRequest> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to
         * describe. If this parameter is not specified, Tape gateway returns a description of all virtual tapes
         * associated with the specified gateway.
         * </p>
         * 
         * @param tapeARNs
         *        Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to
         *        describe. If this parameter is not specified, Tape gateway returns a description of all virtual tapes
         *        associated with the specified gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARNs(Collection<String> tapeARNs);

        /**
         * <p>
         * Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to
         * describe. If this parameter is not specified, Tape gateway returns a description of all virtual tapes
         * associated with the specified gateway.
         * </p>
         * 
         * @param tapeARNs
         *        Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to
         *        describe. If this parameter is not specified, Tape gateway returns a description of all virtual tapes
         *        associated with the specified gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARNs(String... tapeARNs);

        /**
         * <p>
         * A marker value, obtained in a previous call to <code>DescribeTapes</code>. This marker indicates which page
         * of results to retrieve.
         * </p>
         * <p>
         * If not specified, the first page of results is retrieved.
         * </p>
         * 
         * @param marker
         *        A marker value, obtained in a previous call to <code>DescribeTapes</code>. This marker indicates which
         *        page of results to retrieve. </p>
         *        <p>
         *        If not specified, the first page of results is retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Specifies that the number of virtual tapes described be limited to the specified number.
         * </p>
         * <note>
         * <p>
         * Amazon Web Services may impose its own limit, if this field is not set.
         * </p>
         * </note>
         * 
         * @param limit
         *        Specifies that the number of virtual tapes described be limited to the specified number.</p> <note>
         *        <p>
         *        Amazon Web Services may impose its own limit, if this field is not set.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private List<String> tapeARNs = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTapesRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            tapeARNs(model.tapeARNs);
            marker(model.marker);
            limit(model.limit);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Collection<String> getTapeARNs() {
            return tapeARNs;
        }

        @Override
        public final Builder tapeARNs(Collection<String> tapeARNs) {
            this.tapeARNs = TapeARNsCopier.copy(tapeARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapeARNs(String... tapeARNs) {
            tapeARNs(Arrays.asList(tapeARNs));
            return this;
        }

        public final void setTapeARNs(Collection<String> tapeARNs) {
            this.tapeARNs = TapeARNsCopier.copy(tapeARNs);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTapesRequest build() {
            return new DescribeTapesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
