/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a gateway object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GatewayInfo implements SdkPojo, Serializable, ToCopyableBuilder<GatewayInfo.Builder, GatewayInfo> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GatewayInfo::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GatewayInfo::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> GATEWAY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GatewayInfo::gatewayType)).setter(setter(Builder::gatewayType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayType").build()).build();

    private static final SdkField<String> GATEWAY_OPERATIONAL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GatewayInfo::gatewayOperationalState)).setter(setter(Builder::gatewayOperationalState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayOperationalState").build())
            .build();

    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GatewayInfo::gatewayName)).setter(setter(Builder::gatewayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD,
            GATEWAY_ARN_FIELD, GATEWAY_TYPE_FIELD, GATEWAY_OPERATIONAL_STATE_FIELD, GATEWAY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String gatewayId;

    private final String gatewayARN;

    private final String gatewayType;

    private final String gatewayOperationalState;

    private final String gatewayName;

    private GatewayInfo(BuilderImpl builder) {
        this.gatewayId = builder.gatewayId;
        this.gatewayARN = builder.gatewayARN;
        this.gatewayType = builder.gatewayType;
        this.gatewayOperationalState = builder.gatewayOperationalState;
        this.gatewayName = builder.gatewayName;
    }

    /**
     * <p>
     * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon
     * Resource Name (ARN), which you use as input for other operations.
     * </p>
     * 
     * @return The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway
     *         Amazon Resource Name (ARN), which you use as input for other operations.
     */
    public String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list of gateways
     * for your account and region.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list of
     *         gateways for your account and region.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The type of the gateway.
     * </p>
     * 
     * @return The type of the gateway.
     */
    public String gatewayType() {
        return gatewayType;
    }

    /**
     * <p>
     * The state of the gateway.
     * </p>
     * <p>
     * Valid Values: DISABLED or ACTIVE
     * </p>
     * 
     * @return The state of the gateway.</p>
     *         <p>
     *         Valid Values: DISABLED or ACTIVE
     */
    public String gatewayOperationalState() {
        return gatewayOperationalState;
    }

    /**
     * <p>
     * The name of the gateway.
     * </p>
     * 
     * @return The name of the gateway.
     */
    public String gatewayName() {
        return gatewayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayType());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayOperationalState());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayInfo)) {
            return false;
        }
        GatewayInfo other = (GatewayInfo) obj;
        return Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(gatewayARN(), other.gatewayARN())
                && Objects.equals(gatewayType(), other.gatewayType())
                && Objects.equals(gatewayOperationalState(), other.gatewayOperationalState())
                && Objects.equals(gatewayName(), other.gatewayName());
    }

    @Override
    public String toString() {
        return ToString.builder("GatewayInfo").add("GatewayId", gatewayId()).add("GatewayARN", gatewayARN())
                .add("GatewayType", gatewayType()).add("GatewayOperationalState", gatewayOperationalState())
                .add("GatewayName", gatewayName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "GatewayType":
            return Optional.ofNullable(clazz.cast(gatewayType()));
        case "GatewayOperationalState":
            return Optional.ofNullable(clazz.cast(gatewayOperationalState()));
        case "GatewayName":
            return Optional.ofNullable(clazz.cast(gatewayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GatewayInfo, T> g) {
        return obj -> g.apply((GatewayInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GatewayInfo> {
        /**
         * <p>
         * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon
         * Resource Name (ARN), which you use as input for other operations.
         * </p>
         * 
         * @param gatewayId
         *        The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway
         *        Amazon Resource Name (ARN), which you use as input for other operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list of
         * gateways for your account and region.
         * </p>
         * 
         * @param gatewayARN
         *        The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list
         *        of gateways for your account and region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The type of the gateway.
         * </p>
         * 
         * @param gatewayType
         *        The type of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayType(String gatewayType);

        /**
         * <p>
         * The state of the gateway.
         * </p>
         * <p>
         * Valid Values: DISABLED or ACTIVE
         * </p>
         * 
         * @param gatewayOperationalState
         *        The state of the gateway.</p>
         *        <p>
         *        Valid Values: DISABLED or ACTIVE
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayOperationalState(String gatewayOperationalState);

        /**
         * <p>
         * The name of the gateway.
         * </p>
         * 
         * @param gatewayName
         *        The name of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayName(String gatewayName);
    }

    static final class BuilderImpl implements Builder {
        private String gatewayId;

        private String gatewayARN;

        private String gatewayType;

        private String gatewayOperationalState;

        private String gatewayName;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayInfo model) {
            gatewayId(model.gatewayId);
            gatewayARN(model.gatewayARN);
            gatewayType(model.gatewayType);
            gatewayOperationalState(model.gatewayOperationalState);
            gatewayName(model.gatewayName);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getGatewayType() {
            return gatewayType;
        }

        @Override
        public final Builder gatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
            return this;
        }

        public final void setGatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
        }

        public final String getGatewayOperationalState() {
            return gatewayOperationalState;
        }

        @Override
        public final Builder gatewayOperationalState(String gatewayOperationalState) {
            this.gatewayOperationalState = gatewayOperationalState;
            return this;
        }

        public final void setGatewayOperationalState(String gatewayOperationalState) {
            this.gatewayOperationalState = gatewayOperationalState;
        }

        public final String getGatewayName() {
            return gatewayName;
        }

        @Override
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        @Override
        public GatewayInfo build() {
            return new GatewayInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
