/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * JoinDomainInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JoinDomainRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<JoinDomainRequest.Builder, JoinDomainRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JoinDomainRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JoinDomainRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JoinDomainRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JoinDomainRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            DOMAIN_NAME_FIELD, USER_NAME_FIELD, PASSWORD_FIELD));

    private final String gatewayARN;

    private final String domainName;

    private final String userName;

    private final String password;

    private JoinDomainRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.domainName = builder.domainName;
        this.userName = builder.userName;
        this.password = builder.password;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) of the file gateway you want to add to the Active Directory domain.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) of the file gateway you want to add to the Active Directory domain.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The name of the domain that you want the gateway to join.
     * </p>
     * 
     * @return The name of the domain that you want the gateway to join.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Sets the user name of user who has permission to add the gateway to the Active Directory domain.
     * </p>
     * 
     * @return Sets the user name of user who has permission to add the gateway to the Active Directory domain.
     */
    public String userName() {
        return userName;
    }

    /**
     * <p>
     * Sets the password of the user who has permission to add the gateway to the Active Directory domain.
     * </p>
     * 
     * @return Sets the password of the user who has permission to add the gateway to the Active Directory domain.
     */
    public String password() {
        return password;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinDomainRequest)) {
            return false;
        }
        JoinDomainRequest other = (JoinDomainRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(userName(), other.userName()) && Objects.equals(password(), other.password());
    }

    @Override
    public String toString() {
        return ToString.builder("JoinDomainRequest").add("GatewayARN", gatewayARN()).add("DomainName", domainName())
                .add("UserName", userName()).add("Password", password()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JoinDomainRequest, T> g) {
        return obj -> g.apply((JoinDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, JoinDomainRequest> {
        /**
         * <p>
         * The unique Amazon Resource Name (ARN) of the file gateway you want to add to the Active Directory domain.
         * </p>
         * 
         * @param gatewayARN
         *        The unique Amazon Resource Name (ARN) of the file gateway you want to add to the Active Directory
         *        domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The name of the domain that you want the gateway to join.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that you want the gateway to join.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Sets the user name of user who has permission to add the gateway to the Active Directory domain.
         * </p>
         * 
         * @param userName
         *        Sets the user name of user who has permission to add the gateway to the Active Directory domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * Sets the password of the user who has permission to add the gateway to the Active Directory domain.
         * </p>
         * 
         * @param password
         *        Sets the password of the user who has permission to add the gateway to the Active Directory domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private String domainName;

        private String userName;

        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(JoinDomainRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            domainName(model.domainName);
            userName(model.userName);
            password(model.password);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public JoinDomainRequest build() {
            return new JoinDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
