/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ListVolumeInitiatorsOutput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVolumeInitiatorsResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<ListVolumeInitiatorsResponse.Builder, ListVolumeInitiatorsResponse> {
    private static final SdkField<List<String>> INITIATORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListVolumeInitiatorsResponse::initiators))
            .setter(setter(Builder::initiators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Initiators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIATORS_FIELD));

    private final List<String> initiators;

    private ListVolumeInitiatorsResponse(BuilderImpl builder) {
        super(builder);
        this.initiators = builder.initiators;
    }

    /**
     * <p>
     * The host names and port numbers of all iSCSI initiators that are connected to the gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The host names and port numbers of all iSCSI initiators that are connected to the gateway.
     */
    public List<String> initiators() {
        return initiators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initiators());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVolumeInitiatorsResponse)) {
            return false;
        }
        ListVolumeInitiatorsResponse other = (ListVolumeInitiatorsResponse) obj;
        return Objects.equals(initiators(), other.initiators());
    }

    @Override
    public String toString() {
        return ToString.builder("ListVolumeInitiatorsResponse").add("Initiators", initiators()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Initiators":
            return Optional.ofNullable(clazz.cast(initiators()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVolumeInitiatorsResponse, T> g) {
        return obj -> g.apply((ListVolumeInitiatorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListVolumeInitiatorsResponse> {
        /**
         * <p>
         * The host names and port numbers of all iSCSI initiators that are connected to the gateway.
         * </p>
         * 
         * @param initiators
         *        The host names and port numbers of all iSCSI initiators that are connected to the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiators(Collection<String> initiators);

        /**
         * <p>
         * The host names and port numbers of all iSCSI initiators that are connected to the gateway.
         * </p>
         * 
         * @param initiators
         *        The host names and port numbers of all iSCSI initiators that are connected to the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiators(String... initiators);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<String> initiators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVolumeInitiatorsResponse model) {
            super(model);
            initiators(model.initiators);
        }

        public final Collection<String> getInitiators() {
            return initiators;
        }

        @Override
        public final Builder initiators(Collection<String> initiators) {
            this.initiators = InitiatorsCopier.copy(initiators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initiators(String... initiators) {
            initiators(Arrays.asList(initiators));
            return this;
        }

        public final void setInitiators(Collection<String> initiators) {
            this.initiators = InitiatorsCopier.copy(initiators);
        }

        @Override
        public ListVolumeInitiatorsResponse build() {
            return new ListVolumeInitiatorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
