/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes Network File System (NFS) file share default values. Files and folders stored as Amazon S3 objects in S3
 * buckets don't, by default, have Unix file permissions assigned to them. Upon discovery in an S3 bucket by Storage
 * Gateway, the S3 objects that represent files and folders are assigned these default Unix permissions. This operation
 * is only supported for file gateways.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NFSFileShareDefaults implements SdkPojo, Serializable,
        ToCopyableBuilder<NFSFileShareDefaults.Builder, NFSFileShareDefaults> {
    private static final SdkField<String> FILE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NFSFileShareDefaults::fileMode)).setter(setter(Builder::fileMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileMode").build()).build();

    private static final SdkField<String> DIRECTORY_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NFSFileShareDefaults::directoryMode)).setter(setter(Builder::directoryMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryMode").build()).build();

    private static final SdkField<Long> GROUP_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(NFSFileShareDefaults::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<Long> OWNER_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(NFSFileShareDefaults::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_MODE_FIELD,
            DIRECTORY_MODE_FIELD, GROUP_ID_FIELD, OWNER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileMode;

    private final String directoryMode;

    private final Long groupId;

    private final Long ownerId;

    private NFSFileShareDefaults(BuilderImpl builder) {
        this.fileMode = builder.fileMode;
        this.directoryMode = builder.directoryMode;
        this.groupId = builder.groupId;
        this.ownerId = builder.ownerId;
    }

    /**
     * <p>
     * The Unix file mode in the form "nnnn". For example, "0666" represents the default file mode inside the file
     * share. The default value is 0666.
     * </p>
     * 
     * @return The Unix file mode in the form "nnnn". For example, "0666" represents the default file mode inside the
     *         file share. The default value is 0666.
     */
    public String fileMode() {
        return fileMode;
    }

    /**
     * <p>
     * The Unix directory mode in the form "nnnn". For example, "0666" represents the default access mode for all
     * directories inside the file share. The default value is 0777.
     * </p>
     * 
     * @return The Unix directory mode in the form "nnnn". For example, "0666" represents the default access mode for
     *         all directories inside the file share. The default value is 0777.
     */
    public String directoryMode() {
        return directoryMode;
    }

    /**
     * <p>
     * The default group ID for the file share (unless the files have another group ID specified). The default value is
     * nfsnobody.
     * </p>
     * 
     * @return The default group ID for the file share (unless the files have another group ID specified). The default
     *         value is nfsnobody.
     */
    public Long groupId() {
        return groupId;
    }

    /**
     * <p>
     * The default owner ID for files in the file share (unless the files have another owner ID specified). The default
     * value is nfsnobody.
     * </p>
     * 
     * @return The default owner ID for files in the file share (unless the files have another owner ID specified). The
     *         default value is nfsnobody.
     */
    public Long ownerId() {
        return ownerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileMode());
        hashCode = 31 * hashCode + Objects.hashCode(directoryMode());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NFSFileShareDefaults)) {
            return false;
        }
        NFSFileShareDefaults other = (NFSFileShareDefaults) obj;
        return Objects.equals(fileMode(), other.fileMode()) && Objects.equals(directoryMode(), other.directoryMode())
                && Objects.equals(groupId(), other.groupId()) && Objects.equals(ownerId(), other.ownerId());
    }

    @Override
    public String toString() {
        return ToString.builder("NFSFileShareDefaults").add("FileMode", fileMode()).add("DirectoryMode", directoryMode())
                .add("GroupId", groupId()).add("OwnerId", ownerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileMode":
            return Optional.ofNullable(clazz.cast(fileMode()));
        case "DirectoryMode":
            return Optional.ofNullable(clazz.cast(directoryMode()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NFSFileShareDefaults, T> g) {
        return obj -> g.apply((NFSFileShareDefaults) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NFSFileShareDefaults> {
        /**
         * <p>
         * The Unix file mode in the form "nnnn". For example, "0666" represents the default file mode inside the file
         * share. The default value is 0666.
         * </p>
         * 
         * @param fileMode
         *        The Unix file mode in the form "nnnn". For example, "0666" represents the default file mode inside the
         *        file share. The default value is 0666.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileMode(String fileMode);

        /**
         * <p>
         * The Unix directory mode in the form "nnnn". For example, "0666" represents the default access mode for all
         * directories inside the file share. The default value is 0777.
         * </p>
         * 
         * @param directoryMode
         *        The Unix directory mode in the form "nnnn". For example, "0666" represents the default access mode for
         *        all directories inside the file share. The default value is 0777.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryMode(String directoryMode);

        /**
         * <p>
         * The default group ID for the file share (unless the files have another group ID specified). The default value
         * is nfsnobody.
         * </p>
         * 
         * @param groupId
         *        The default group ID for the file share (unless the files have another group ID specified). The
         *        default value is nfsnobody.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(Long groupId);

        /**
         * <p>
         * The default owner ID for files in the file share (unless the files have another owner ID specified). The
         * default value is nfsnobody.
         * </p>
         * 
         * @param ownerId
         *        The default owner ID for files in the file share (unless the files have another owner ID specified).
         *        The default value is nfsnobody.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(Long ownerId);
    }

    static final class BuilderImpl implements Builder {
        private String fileMode;

        private String directoryMode;

        private Long groupId;

        private Long ownerId;

        private BuilderImpl() {
        }

        private BuilderImpl(NFSFileShareDefaults model) {
            fileMode(model.fileMode);
            directoryMode(model.directoryMode);
            groupId(model.groupId);
            ownerId(model.ownerId);
        }

        public final String getFileMode() {
            return fileMode;
        }

        @Override
        public final Builder fileMode(String fileMode) {
            this.fileMode = fileMode;
            return this;
        }

        public final void setFileMode(String fileMode) {
            this.fileMode = fileMode;
        }

        public final String getDirectoryMode() {
            return directoryMode;
        }

        @Override
        public final Builder directoryMode(String directoryMode) {
            this.directoryMode = directoryMode;
            return this;
        }

        public final void setDirectoryMode(String directoryMode) {
            this.directoryMode = directoryMode;
        }

        public final Long getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(Long groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(Long groupId) {
            this.groupId = groupId;
        }

        public final Long getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(Long ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(Long ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public NFSFileShareDefaults build() {
            return new NFSFileShareDefaults(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
