/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing the following fields:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>UpdateMaintenanceStartTimeInput$DayOfWeek</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateMaintenanceStartTimeInput$HourOfDay</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateMaintenanceStartTimeInput$MinuteOfHour</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMaintenanceStartTimeRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<UpdateMaintenanceStartTimeRequest.Builder, UpdateMaintenanceStartTimeRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateMaintenanceStartTimeRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<Integer> HOUR_OF_DAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateMaintenanceStartTimeRequest::hourOfDay)).setter(setter(Builder::hourOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourOfDay").build()).build();

    private static final SdkField<Integer> MINUTE_OF_HOUR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateMaintenanceStartTimeRequest::minuteOfHour)).setter(setter(Builder::minuteOfHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinuteOfHour").build()).build();

    private static final SdkField<Integer> DAY_OF_WEEK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateMaintenanceStartTimeRequest::dayOfWeek)).setter(setter(Builder::dayOfWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfWeek").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            HOUR_OF_DAY_FIELD, MINUTE_OF_HOUR_FIELD, DAY_OF_WEEK_FIELD));

    private final String gatewayARN;

    private final Integer hourOfDay;

    private final Integer minuteOfHour;

    private final Integer dayOfWeek;

    private UpdateMaintenanceStartTimeRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.hourOfDay = builder.hourOfDay;
        this.minuteOfHour = builder.minuteOfHour;
        this.dayOfWeek = builder.dayOfWeek;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (00 to
     * 23). The hour of the day is in the time zone of the gateway.
     * </p>
     * 
     * @return The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour
     *         (00 to 23). The hour of the day is in the time zone of the gateway.
     */
    public Integer hourOfDay() {
        return hourOfDay;
    }

    /**
     * <p>
     * The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (00 to
     * 59). The minute of the hour is in the time zone of the gateway.
     * </p>
     * 
     * @return The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the
     *         minute (00 to 59). The minute of the hour is in the time zone of the gateway.
     */
    public Integer minuteOfHour() {
        return minuteOfHour;
    }

    /**
     * <p>
     * The maintenance start time day of the week represented as an ordinal number from 0 to 6, where 0 represents
     * Sunday and 6 Saturday.
     * </p>
     * 
     * @return The maintenance start time day of the week represented as an ordinal number from 0 to 6, where 0
     *         represents Sunday and 6 Saturday.
     */
    public Integer dayOfWeek() {
        return dayOfWeek;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(hourOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(minuteOfHour());
        hashCode = 31 * hashCode + Objects.hashCode(dayOfWeek());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMaintenanceStartTimeRequest)) {
            return false;
        }
        UpdateMaintenanceStartTimeRequest other = (UpdateMaintenanceStartTimeRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(hourOfDay(), other.hourOfDay())
                && Objects.equals(minuteOfHour(), other.minuteOfHour()) && Objects.equals(dayOfWeek(), other.dayOfWeek());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateMaintenanceStartTimeRequest").add("GatewayARN", gatewayARN())
                .add("HourOfDay", hourOfDay()).add("MinuteOfHour", minuteOfHour()).add("DayOfWeek", dayOfWeek()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "HourOfDay":
            return Optional.ofNullable(clazz.cast(hourOfDay()));
        case "MinuteOfHour":
            return Optional.ofNullable(clazz.cast(minuteOfHour()));
        case "DayOfWeek":
            return Optional.ofNullable(clazz.cast(dayOfWeek()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMaintenanceStartTimeRequest, T> g) {
        return obj -> g.apply((UpdateMaintenanceStartTimeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMaintenanceStartTimeRequest> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (00 to
         * 23). The hour of the day is in the time zone of the gateway.
         * </p>
         * 
         * @param hourOfDay
         *        The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour
         *        (00 to 23). The hour of the day is in the time zone of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourOfDay(Integer hourOfDay);

        /**
         * <p>
         * The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute
         * (00 to 59). The minute of the hour is in the time zone of the gateway.
         * </p>
         * 
         * @param minuteOfHour
         *        The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the
         *        minute (00 to 59). The minute of the hour is in the time zone of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minuteOfHour(Integer minuteOfHour);

        /**
         * <p>
         * The maintenance start time day of the week represented as an ordinal number from 0 to 6, where 0 represents
         * Sunday and 6 Saturday.
         * </p>
         * 
         * @param dayOfWeek
         *        The maintenance start time day of the week represented as an ordinal number from 0 to 6, where 0
         *        represents Sunday and 6 Saturday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dayOfWeek(Integer dayOfWeek);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private Integer hourOfDay;

        private Integer minuteOfHour;

        private Integer dayOfWeek;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMaintenanceStartTimeRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            hourOfDay(model.hourOfDay);
            minuteOfHour(model.minuteOfHour);
            dayOfWeek(model.dayOfWeek);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Integer getHourOfDay() {
            return hourOfDay;
        }

        @Override
        public final Builder hourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
            return this;
        }

        public final void setHourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
        }

        public final Integer getMinuteOfHour() {
            return minuteOfHour;
        }

        @Override
        public final Builder minuteOfHour(Integer minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
            return this;
        }

        public final void setMinuteOfHour(Integer minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
        }

        public final Integer getDayOfWeek() {
            return dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public final void setDayOfWeek(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMaintenanceStartTimeRequest build() {
            return new UpdateMaintenanceStartTimeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
