/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a device object associated with a tape gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VTLDevice implements SdkPojo, Serializable, ToCopyableBuilder<VTLDevice.Builder, VTLDevice> {
    private static final SdkField<String> VTL_DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VTLDevice::vtlDeviceARN)).setter(setter(Builder::vtlDeviceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDeviceARN").build()).build();

    private static final SdkField<String> VTL_DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VTLDevice::vtlDeviceType)).setter(setter(Builder::vtlDeviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDeviceType").build()).build();

    private static final SdkField<String> VTL_DEVICE_VENDOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VTLDevice::vtlDeviceVendor)).setter(setter(Builder::vtlDeviceVendor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDeviceVendor").build()).build();

    private static final SdkField<String> VTL_DEVICE_PRODUCT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(VTLDevice::vtlDeviceProductIdentifier))
            .setter(setter(Builder::vtlDeviceProductIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDeviceProductIdentifier").build())
            .build();

    private static final SdkField<DeviceiSCSIAttributes> DEVICEI_SCSI_ATTRIBUTES_FIELD = SdkField
            .<DeviceiSCSIAttributes> builder(MarshallingType.SDK_POJO).getter(getter(VTLDevice::deviceiSCSIAttributes))
            .setter(setter(Builder::deviceiSCSIAttributes)).constructor(DeviceiSCSIAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceiSCSIAttributes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VTL_DEVICE_ARN_FIELD,
            VTL_DEVICE_TYPE_FIELD, VTL_DEVICE_VENDOR_FIELD, VTL_DEVICE_PRODUCT_IDENTIFIER_FIELD, DEVICEI_SCSI_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vtlDeviceARN;

    private final String vtlDeviceType;

    private final String vtlDeviceVendor;

    private final String vtlDeviceProductIdentifier;

    private final DeviceiSCSIAttributes deviceiSCSIAttributes;

    private VTLDevice(BuilderImpl builder) {
        this.vtlDeviceARN = builder.vtlDeviceARN;
        this.vtlDeviceType = builder.vtlDeviceType;
        this.vtlDeviceVendor = builder.vtlDeviceVendor;
        this.vtlDeviceProductIdentifier = builder.vtlDeviceProductIdentifier;
        this.deviceiSCSIAttributes = builder.deviceiSCSIAttributes;
    }

    /**
     * <p>
     * Specifies the unique Amazon Resource Name (ARN) of the device (tape drive or media changer).
     * </p>
     * 
     * @return Specifies the unique Amazon Resource Name (ARN) of the device (tape drive or media changer).
     */
    public String vtlDeviceARN() {
        return vtlDeviceARN;
    }

    /**
     * Returns the value of the VTLDeviceType property for this object.
     * 
     * @return The value of the VTLDeviceType property for this object.
     */
    public String vtlDeviceType() {
        return vtlDeviceType;
    }

    /**
     * Returns the value of the VTLDeviceVendor property for this object.
     * 
     * @return The value of the VTLDeviceVendor property for this object.
     */
    public String vtlDeviceVendor() {
        return vtlDeviceVendor;
    }

    /**
     * Returns the value of the VTLDeviceProductIdentifier property for this object.
     * 
     * @return The value of the VTLDeviceProductIdentifier property for this object.
     */
    public String vtlDeviceProductIdentifier() {
        return vtlDeviceProductIdentifier;
    }

    /**
     * <p>
     * A list of iSCSI information about a VTL device.
     * </p>
     * 
     * @return A list of iSCSI information about a VTL device.
     */
    public DeviceiSCSIAttributes deviceiSCSIAttributes() {
        return deviceiSCSIAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vtlDeviceARN());
        hashCode = 31 * hashCode + Objects.hashCode(vtlDeviceType());
        hashCode = 31 * hashCode + Objects.hashCode(vtlDeviceVendor());
        hashCode = 31 * hashCode + Objects.hashCode(vtlDeviceProductIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(deviceiSCSIAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VTLDevice)) {
            return false;
        }
        VTLDevice other = (VTLDevice) obj;
        return Objects.equals(vtlDeviceARN(), other.vtlDeviceARN()) && Objects.equals(vtlDeviceType(), other.vtlDeviceType())
                && Objects.equals(vtlDeviceVendor(), other.vtlDeviceVendor())
                && Objects.equals(vtlDeviceProductIdentifier(), other.vtlDeviceProductIdentifier())
                && Objects.equals(deviceiSCSIAttributes(), other.deviceiSCSIAttributes());
    }

    @Override
    public String toString() {
        return ToString.builder("VTLDevice").add("VTLDeviceARN", vtlDeviceARN()).add("VTLDeviceType", vtlDeviceType())
                .add("VTLDeviceVendor", vtlDeviceVendor()).add("VTLDeviceProductIdentifier", vtlDeviceProductIdentifier())
                .add("DeviceiSCSIAttributes", deviceiSCSIAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VTLDeviceARN":
            return Optional.ofNullable(clazz.cast(vtlDeviceARN()));
        case "VTLDeviceType":
            return Optional.ofNullable(clazz.cast(vtlDeviceType()));
        case "VTLDeviceVendor":
            return Optional.ofNullable(clazz.cast(vtlDeviceVendor()));
        case "VTLDeviceProductIdentifier":
            return Optional.ofNullable(clazz.cast(vtlDeviceProductIdentifier()));
        case "DeviceiSCSIAttributes":
            return Optional.ofNullable(clazz.cast(deviceiSCSIAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VTLDevice, T> g) {
        return obj -> g.apply((VTLDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VTLDevice> {
        /**
         * <p>
         * Specifies the unique Amazon Resource Name (ARN) of the device (tape drive or media changer).
         * </p>
         * 
         * @param vtlDeviceARN
         *        Specifies the unique Amazon Resource Name (ARN) of the device (tape drive or media changer).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vtlDeviceARN(String vtlDeviceARN);

        /**
         * Sets the value of the VTLDeviceType property for this object.
         *
         * @param vtlDeviceType
         *        The new value for the VTLDeviceType property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vtlDeviceType(String vtlDeviceType);

        /**
         * Sets the value of the VTLDeviceVendor property for this object.
         *
         * @param vtlDeviceVendor
         *        The new value for the VTLDeviceVendor property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vtlDeviceVendor(String vtlDeviceVendor);

        /**
         * Sets the value of the VTLDeviceProductIdentifier property for this object.
         *
         * @param vtlDeviceProductIdentifier
         *        The new value for the VTLDeviceProductIdentifier property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vtlDeviceProductIdentifier(String vtlDeviceProductIdentifier);

        /**
         * <p>
         * A list of iSCSI information about a VTL device.
         * </p>
         * 
         * @param deviceiSCSIAttributes
         *        A list of iSCSI information about a VTL device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceiSCSIAttributes(DeviceiSCSIAttributes deviceiSCSIAttributes);

        /**
         * <p>
         * A list of iSCSI information about a VTL device.
         * </p>
         * This is a convenience that creates an instance of the {@link DeviceiSCSIAttributes.Builder} avoiding the need
         * to create one manually via {@link DeviceiSCSIAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceiSCSIAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #deviceiSCSIAttributes(DeviceiSCSIAttributes)}.
         * 
         * @param deviceiSCSIAttributes
         *        a consumer that will call methods on {@link DeviceiSCSIAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceiSCSIAttributes(DeviceiSCSIAttributes)
         */
        default Builder deviceiSCSIAttributes(Consumer<DeviceiSCSIAttributes.Builder> deviceiSCSIAttributes) {
            return deviceiSCSIAttributes(DeviceiSCSIAttributes.builder().applyMutation(deviceiSCSIAttributes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String vtlDeviceARN;

        private String vtlDeviceType;

        private String vtlDeviceVendor;

        private String vtlDeviceProductIdentifier;

        private DeviceiSCSIAttributes deviceiSCSIAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(VTLDevice model) {
            vtlDeviceARN(model.vtlDeviceARN);
            vtlDeviceType(model.vtlDeviceType);
            vtlDeviceVendor(model.vtlDeviceVendor);
            vtlDeviceProductIdentifier(model.vtlDeviceProductIdentifier);
            deviceiSCSIAttributes(model.deviceiSCSIAttributes);
        }

        public final String getVTLDeviceARN() {
            return vtlDeviceARN;
        }

        @Override
        public final Builder vtlDeviceARN(String vtlDeviceARN) {
            this.vtlDeviceARN = vtlDeviceARN;
            return this;
        }

        public final void setVTLDeviceARN(String vtlDeviceARN) {
            this.vtlDeviceARN = vtlDeviceARN;
        }

        public final String getVTLDeviceType() {
            return vtlDeviceType;
        }

        @Override
        public final Builder vtlDeviceType(String vtlDeviceType) {
            this.vtlDeviceType = vtlDeviceType;
            return this;
        }

        public final void setVTLDeviceType(String vtlDeviceType) {
            this.vtlDeviceType = vtlDeviceType;
        }

        public final String getVTLDeviceVendor() {
            return vtlDeviceVendor;
        }

        @Override
        public final Builder vtlDeviceVendor(String vtlDeviceVendor) {
            this.vtlDeviceVendor = vtlDeviceVendor;
            return this;
        }

        public final void setVTLDeviceVendor(String vtlDeviceVendor) {
            this.vtlDeviceVendor = vtlDeviceVendor;
        }

        public final String getVTLDeviceProductIdentifier() {
            return vtlDeviceProductIdentifier;
        }

        @Override
        public final Builder vtlDeviceProductIdentifier(String vtlDeviceProductIdentifier) {
            this.vtlDeviceProductIdentifier = vtlDeviceProductIdentifier;
            return this;
        }

        public final void setVTLDeviceProductIdentifier(String vtlDeviceProductIdentifier) {
            this.vtlDeviceProductIdentifier = vtlDeviceProductIdentifier;
        }

        public final DeviceiSCSIAttributes.Builder getDeviceiSCSIAttributes() {
            return deviceiSCSIAttributes != null ? deviceiSCSIAttributes.toBuilder() : null;
        }

        @Override
        public final Builder deviceiSCSIAttributes(DeviceiSCSIAttributes deviceiSCSIAttributes) {
            this.deviceiSCSIAttributes = deviceiSCSIAttributes;
            return this;
        }

        public final void setDeviceiSCSIAttributes(DeviceiSCSIAttributes.BuilderImpl deviceiSCSIAttributes) {
            this.deviceiSCSIAttributes = deviceiSCSIAttributes != null ? deviceiSCSIAttributes.build() : null;
        }

        @Override
        public VTLDevice build() {
            return new VTLDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
