/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeRecoveryPointInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<VolumeRecoveryPointInfo.Builder, VolumeRecoveryPointInfo> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeRecoveryPointInfo::volumeARN)).setter(setter(Builder::volumeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()).build();

    private static final SdkField<Long> VOLUME_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(VolumeRecoveryPointInfo::volumeSizeInBytes)).setter(setter(Builder::volumeSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInBytes").build()).build();

    private static final SdkField<Long> VOLUME_USAGE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(VolumeRecoveryPointInfo::volumeUsageInBytes)).setter(setter(Builder::volumeUsageInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeUsageInBytes").build())
            .build();

    private static final SdkField<String> VOLUME_RECOVERY_POINT_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeRecoveryPointInfo::volumeRecoveryPointTime)).setter(setter(Builder::volumeRecoveryPointTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeRecoveryPointTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD,
            VOLUME_SIZE_IN_BYTES_FIELD, VOLUME_USAGE_IN_BYTES_FIELD, VOLUME_RECOVERY_POINT_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String volumeARN;

    private final Long volumeSizeInBytes;

    private final Long volumeUsageInBytes;

    private final String volumeRecoveryPointTime;

    private VolumeRecoveryPointInfo(BuilderImpl builder) {
        this.volumeARN = builder.volumeARN;
        this.volumeSizeInBytes = builder.volumeSizeInBytes;
        this.volumeUsageInBytes = builder.volumeUsageInBytes;
        this.volumeRecoveryPointTime = builder.volumeRecoveryPointTime;
    }

    /**
     * Returns the value of the VolumeARN property for this object.
     * 
     * @return The value of the VolumeARN property for this object.
     */
    public String volumeARN() {
        return volumeARN;
    }

    /**
     * Returns the value of the VolumeSizeInBytes property for this object.
     * 
     * @return The value of the VolumeSizeInBytes property for this object.
     */
    public Long volumeSizeInBytes() {
        return volumeSizeInBytes;
    }

    /**
     * Returns the value of the VolumeUsageInBytes property for this object.
     * 
     * @return The value of the VolumeUsageInBytes property for this object.
     */
    public Long volumeUsageInBytes() {
        return volumeUsageInBytes;
    }

    /**
     * Returns the value of the VolumeRecoveryPointTime property for this object.
     * 
     * @return The value of the VolumeRecoveryPointTime property for this object.
     */
    public String volumeRecoveryPointTime() {
        return volumeRecoveryPointTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(volumeUsageInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(volumeRecoveryPointTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeRecoveryPointInfo)) {
            return false;
        }
        VolumeRecoveryPointInfo other = (VolumeRecoveryPointInfo) obj;
        return Objects.equals(volumeARN(), other.volumeARN()) && Objects.equals(volumeSizeInBytes(), other.volumeSizeInBytes())
                && Objects.equals(volumeUsageInBytes(), other.volumeUsageInBytes())
                && Objects.equals(volumeRecoveryPointTime(), other.volumeRecoveryPointTime());
    }

    @Override
    public String toString() {
        return ToString.builder("VolumeRecoveryPointInfo").add("VolumeARN", volumeARN())
                .add("VolumeSizeInBytes", volumeSizeInBytes()).add("VolumeUsageInBytes", volumeUsageInBytes())
                .add("VolumeRecoveryPointTime", volumeRecoveryPointTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeARN":
            return Optional.ofNullable(clazz.cast(volumeARN()));
        case "VolumeSizeInBytes":
            return Optional.ofNullable(clazz.cast(volumeSizeInBytes()));
        case "VolumeUsageInBytes":
            return Optional.ofNullable(clazz.cast(volumeUsageInBytes()));
        case "VolumeRecoveryPointTime":
            return Optional.ofNullable(clazz.cast(volumeRecoveryPointTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeRecoveryPointInfo, T> g) {
        return obj -> g.apply((VolumeRecoveryPointInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeRecoveryPointInfo> {
        /**
         * Sets the value of the VolumeARN property for this object.
         *
         * @param volumeARN
         *        The new value for the VolumeARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeARN(String volumeARN);

        /**
         * Sets the value of the VolumeSizeInBytes property for this object.
         *
         * @param volumeSizeInBytes
         *        The new value for the VolumeSizeInBytes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInBytes(Long volumeSizeInBytes);

        /**
         * Sets the value of the VolumeUsageInBytes property for this object.
         *
         * @param volumeUsageInBytes
         *        The new value for the VolumeUsageInBytes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeUsageInBytes(Long volumeUsageInBytes);

        /**
         * Sets the value of the VolumeRecoveryPointTime property for this object.
         *
         * @param volumeRecoveryPointTime
         *        The new value for the VolumeRecoveryPointTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeRecoveryPointTime(String volumeRecoveryPointTime);
    }

    static final class BuilderImpl implements Builder {
        private String volumeARN;

        private Long volumeSizeInBytes;

        private Long volumeUsageInBytes;

        private String volumeRecoveryPointTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeRecoveryPointInfo model) {
            volumeARN(model.volumeARN);
            volumeSizeInBytes(model.volumeSizeInBytes);
            volumeUsageInBytes(model.volumeUsageInBytes);
            volumeRecoveryPointTime(model.volumeRecoveryPointTime);
        }

        public final String getVolumeARN() {
            return volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        public final Long getVolumeSizeInBytes() {
            return volumeSizeInBytes;
        }

        @Override
        public final Builder volumeSizeInBytes(Long volumeSizeInBytes) {
            this.volumeSizeInBytes = volumeSizeInBytes;
            return this;
        }

        public final void setVolumeSizeInBytes(Long volumeSizeInBytes) {
            this.volumeSizeInBytes = volumeSizeInBytes;
        }

        public final Long getVolumeUsageInBytes() {
            return volumeUsageInBytes;
        }

        @Override
        public final Builder volumeUsageInBytes(Long volumeUsageInBytes) {
            this.volumeUsageInBytes = volumeUsageInBytes;
            return this;
        }

        public final void setVolumeUsageInBytes(Long volumeUsageInBytes) {
            this.volumeUsageInBytes = volumeUsageInBytes;
        }

        public final String getVolumeRecoveryPointTime() {
            return volumeRecoveryPointTime;
        }

        @Override
        public final Builder volumeRecoveryPointTime(String volumeRecoveryPointTime) {
            this.volumeRecoveryPointTime = volumeRecoveryPointTime;
            return this;
        }

        public final void setVolumeRecoveryPointTime(String volumeRecoveryPointTime) {
            this.volumeRecoveryPointTime = volumeRecoveryPointTime;
        }

        @Override
        public VolumeRecoveryPointInfo build() {
            return new VolumeRecoveryPointInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
